/*
 * $RCSfile: PicturesCheckBox.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class PicturesCheckBox extends JCheckBox implements FocusListener {
    private boolean state = false;
    private JLabel label = null;
    private String labelString = null;
    private String labelAbove = null;
    private String labelBelow = null;
    private String id = null;
    private boolean labelDisabled = false;
    private ButtonIcon buttonIcon;
    private ButtonIcon focusedSelectedCheckBoxIcon;
    private ButtonIcon focusedCheckBoxIcon;
    private ButtonIcon checkBoxIcon;
    private ButtonIcon selectedCheckBoxIcon;

    //  private ScriptConfiguration config;
    public PicturesCheckBox() {
        //    config = Cotroller.getConfiguration();
        addFocusListener(this);
        setIconSet();
        setPreferredSize(null);
    }

    public void setOneLabel(String label) {
        //    configMan = ConfigurationManager.getConfigurationManager();
        setLabel(label);
        this.label.setOpaque(true);
        addFocusListener(this);
    }

    public void setTwoLabels(String labelAbove, String labelBelow) {
        //    configMan = ConfigurationManager.getConfigurationManager();
        setLabel(labelAbove + labelBelow);
        this.labelAbove = labelAbove;
        this.labelBelow = labelBelow;
        this.label.setOpaque(true);
    }

    public void createPicturesCheckBox() {
        //    configMan = ConfigurationManager.getConfigurationManager();
        if ((this.labelAbove != null) && (this.labelBelow != null)) {
            addFocusListener(this);
            buttonIcon = new ButtonIcon(labelAbove, labelBelow, getSize());
            focusedSelectedCheckBoxIcon = new ButtonIcon(true, true, labelAbove, labelBelow, getSize());
            focusedCheckBoxIcon = new ButtonIcon(false, true, labelAbove, labelBelow, getSize());
            checkBoxIcon = new ButtonIcon(false, false, labelAbove, labelBelow, getSize());
            selectedCheckBoxIcon = new ButtonIcon(true, false, labelAbove, labelBelow, getSize());
            setIconSet();
            setPreferredSize(buttonIcon.getDimension());
        } else if (getLabelString() != null) {
            addFocusListener(this);
            buttonIcon = new ButtonIcon(getLabelString(), null, getSize());
            focusedSelectedCheckBoxIcon = new ButtonIcon(true, true, getLabelString(), null, getSize());
            focusedCheckBoxIcon = new ButtonIcon(false, true, getLabelString(), null, getSize());
            checkBoxIcon = new ButtonIcon(false, false, getLabelString(), null, getSize());
            selectedCheckBoxIcon = new ButtonIcon(true, false, getLabelString(), null, getSize());
            setIconSet();
            setPreferredSize(buttonIcon.getDimension());
        } else
            System.out.println("Empty label! No checkbox created.");
    }

    public void setSize(Dimension d) {
        super.setSize(d);
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
    }

    public void setLabel(String label) {
        this.label = new JLabel(label);
        this.labelString = label;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void disableLabel(boolean disabled) {
        labelDisabled = disabled;
        //  	label.setForeground(configMan.getColorTable().getTextColorDisabledText());
        label.setForeground(new Color(255, 0, 0));
    }

    public void setIconSet() {
        if (hasFocus()) {
            setIcon(focusedCheckBoxIcon);
            setSelectedIcon(focusedSelectedCheckBoxIcon);
            setDisabledIcon(checkBoxIcon);
            setDisabledSelectedIcon(selectedCheckBoxIcon);
        } else {
            setIcon(checkBoxIcon);
            setSelectedIcon(selectedCheckBoxIcon);
            setDisabledIcon(selectedCheckBoxIcon);
            setDisabledSelectedIcon(selectedCheckBoxIcon);
        }
    }

    public void setChecked(boolean checked) {
        System.out.println("setChecked: " + checked);
        if (checked) {
            focusGained(new FocusEvent(this, FocusEvent.FOCUS_GAINED));

            /*
                setIcon(focusedCheckBoxIcon);
                setSelectedIcon(focusedSelectedCheckBoxIcon);
                setDisabledIcon(checkBoxIcon);
                setDisabledSelectedIcon(selectedCheckBoxIcon);
            */
        } else {
            focusLost(new FocusEvent(this, FocusEvent.FOCUS_LOST));

            /*
			setIcon(checkBoxIcon);
			setSelectedIcon(selectedCheckBoxIcon);
			setDisabledIcon(selectedCheckBoxIcon);
			setDisabledSelectedIcon(selectedCheckBoxIcon);
			*/
        }
    }

    public void focusGained(FocusEvent e) {
        Color color = new Color(245, 167, 0);
        this.requestFocus();
        if (label != null) {
            if (!isEnabled()) {
                transferFocus();
            } else {
                this.label.setBackground(color);
                this.setState(true);
            }
        }
        setIconSet();
    }

    public void focusLost(FocusEvent e) {
        if (label != null) {
            this.label.setBackground(null);
            this.setState(false);
        }
        setIconSet();
    }

    public void setControlID(String id) {
        this.id = id;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean getState() {
        return this.state;
    }
}
