/*
 * $RCSfile: LabelIcon.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.gui;

import reform.resmedicinae.reform.formular.script.*;

import javax.swing.*;
import java.awt.*;

public class LabelIcon implements Icon {
    private String labelString = null;
    private String labelBelow = null;
    private String labelAbove = null;
    private String id = null;
    private boolean labelDisabled = false;
    private int iconheight = 10;
    private int iconwidth = 10;
    private ScriptConfiguration scriptConfiguration;

    public LabelIcon() {
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
    }

    public void setTextLabelAbove(String labelAbove) {
        this.labelAbove = labelAbove;
    }

    public void setTextLabelBelow(String labelBelow) {
        this.labelBelow = labelBelow;
    }

    public String getTextLabelLabelAbove() {
        return this.labelAbove;
    }

    public String getTextLabelLabelBelow() {
        return this.labelBelow;
    }

    public int getIconHeight() {
        return this.iconheight;
    }

    public int getIconWidth() {
        return this.iconwidth;
    }

    public void setControlID(String id) {
        this.id = id;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.labelAbove != null) {
            if (this.labelBelow != null) {
                g.setFont(new Font("Label", Font.PLAIN, 10));
                g.setColor(scriptConfiguration.getFontColor());
                //		g.setBackground(scriptConfiguration.getScriptBackGroundColorWhite());
                g.drawString(this.labelAbove, x, y + 10);
                g.drawString(this.labelBelow, x, y + 21);
            } else {
                g.setFont(new Font("Label", Font.PLAIN, 10));
                g.setColor(scriptConfiguration.getFontColor());
                //		g.setBackground(scriptConfiguration.getScriptBackGroundColorWhite());
                g.drawString(this.labelAbove, x, y + 21);
            }
        }
    }
}
