/*
 * $RCSfile: GeneralHintDialog.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.gui;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Creates a dialog for displaying events, hints, mistakes and other messages for the user
 * @see createDialog
 * @see my_ActionListenerGHD
 */
public class GeneralHintDialog extends JDialog {
    /**
     * Constructor Creates an instance of this class and creates the dialog of createDialog.
     * The maximum of charchters in on row is confined to 40
     * @param frame frame to paint the dialog at
     * @param hint string that includes the hint to show
     */
    public GeneralHintDialog(JFrame frame, String hint) {
        super(frame, "General Hint / Error", true);
        createDialog cD = new createDialog(this, hint, 40);
        this.show();
    }

    /**
     * Constructor Creates an instance of this class and creates the dialog of createDialog.
     * @param frame frame to paint the dialog at
     * @param hint string that includes the hint to show
     * @param width value that confides the maximum of charcters in one row
     */
    public GeneralHintDialog(JFrame frame, String hint, int width) {
        super(frame, "General Hint / Error", true);
        createDialog cD = new createDialog(this, hint, width);
        this.show();
    }

    /**
     * Creates a dialog
     * @see GeneralHintDialog
     * @see my_ActionListenerGHD
     */
    public class createDialog {
        /**
         * Constructor Manages the Layout of the dialog. If hint has more than width character, it will be devided in parts
         * Every part will be shown as a several row on the dialog.
         * @param d JDialog, auf dem der String ausggeben werden soll
         * @param hint String, der den Hinweis enthaelt
         */
        createDialog(JDialog dialog, String hint, int width) {
            int rows = 0;
            String part = "";
            Vector parts = new Vector();
            JPanel wp = new BorderPanel(5);
            JPanel wtp = new BorderPanel(10);
            JPanel lowerdPanel = new BorderPanel(10);
            wp.setLayout(new FlowLayout(1, 1, FlowLayout.CENTER));
            JButton wbutt = new JButton("O.K.");
            wbutt.addActionListener(new my_ActionListenerGHD(dialog));
            wp.add(wbutt);
            while (hint.length() > 0) {
                rows++;
                if ((hint.length() > width) && (hint.substring(width).indexOf(" ") != -1)) {
                    part = hint.substring(0, width);
                    hint = hint.substring(width);
                    part += hint.substring(0, hint.indexOf(" "));
                    hint = hint.substring(hint.indexOf(" "));
                } else {
                    part = hint;
                    hint = "";
                }
                ;
                parts.addElement(part);
            }
            ;
            wtp.setLayout(new GridLayout(parts.size(), 1));
            wtp.setForeground(Color.red);
            for (int i = 0; i < parts.size(); i++)
                wtp.add(new JLabel(parts.elementAt(i).toString(), JLabel.CENTER));
            wtp.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            lowerdPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
            lowerdPanel.add(wtp);
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add("Center", lowerdPanel);
            dialog.getContentPane().add("South", wp);
            dialog.setSize(width * 7 + 40, rows * 20 + 110);
            dialog.setLocation(280, 280);
        }
    }


    /**
     * This class controls the button actions used by createDialog
     * @see GeneralHintDialog
     * @see createDialog
     */
    public class my_ActionListenerGHD implements ActionListener {
        public JDialog pwar;

        /**
         * Constructor
         * @param diall JDialog thats actions have to be controlled
         */
        my_ActionListenerGHD(JDialog diall) {
            pwar = diall;
        }

        /** Invoked when an action occurs. */
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JButton) {
                if (e.getActionCommand().equals("O.K.")) {
                    pwar.hide();
                }
                ;
            }
            ;
        }
    }
}
