/*
 * $RCSfile: ButtonIcon.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.gui;

import reform.resmedicinae.reform.formular.script.*;

import javax.swing.*;
import java.awt.*;

class ButtonIcon implements Icon {
    private boolean isSelected;
    private boolean focused;
    private boolean disabled;
    private PicturesCheckBox picturesCheckBox = null;
    private int columns = 1;
    private int iconheight = 15;
    private int iconwidth = 0;
    private int outerRectangleHeight = 17;
    private int outerRectangleWidth = 0;
    private int innerRectangleHeight = 15;
    private int innerRectangleWidth = 0;
    private String labelBelow = null;
    private String labelAbove = null;
    private int labelSize = 0;
    private ScriptConfiguration scriptConfiguration;

    public ButtonIcon(String labelAbove, String labelBelow, Dimension d) {
        this.disabled = true;
        setLabelAbove(labelAbove);
        setLabelBelow(labelBelow);
        setLabelSize();
        setColumns();
        if ((d.height != 0) || (d.width != 0))
            setSize(d);
        else
            setButtonDimension();
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
    }

    public ButtonIcon(boolean selected, boolean focused, String labelAbove, String labelBelow, Dimension d) {
        this.isSelected = selected;
        this.focused = focused;
        setLabelAbove(labelAbove);
        setLabelBelow(labelBelow);
        setLabelSize();
        setColumns();
        if ((d.height != 0) || (d.width != 0))
            setSize(d);
        else
            setButtonDimension();
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
    }

    public ButtonIcon(PicturesCheckBox picturesCheckBox, boolean selected, boolean focused, String labelAbove,
                      String labelBelow, Dimension d) {
        this.isSelected = selected;
        this.focused = focused;
        this.picturesCheckBox = picturesCheckBox;
        setLabelAbove(labelAbove);
        setLabelBelow(labelBelow);
        setLabelSize();
        setColumns();
        if ((d.height != 0) || (d.width != 0))
            setSize(d);
        else
            setButtonDimension();
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
    }

    public void setColumns() {
        if ((this.labelAbove == null) || (this.labelBelow == null))
            this.columns = 1;
        else
            this.columns = 2;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setLabelAbove(String labelAbove) {
        this.labelAbove = labelAbove;
    }

    public String getLabelAbove() {
        return this.labelAbove;
    }

    public void setLabelBelow(String labelBelow) {
        this.labelBelow = labelBelow;
    }

    public String getLabelBelow() {
        if (this.labelBelow != null)
            return this.labelBelow;
        else
            return "";
    }

    private void setButtonDimension() {
        this.iconwidth = getLabelSize() + 4;
        this.innerRectangleWidth = this.iconwidth;
        this.outerRectangleWidth = this.innerRectangleWidth + 4;
        this.iconheight = 12 * getColumns();
        this.innerRectangleHeight = this.iconheight;
        this.outerRectangleHeight = this.innerRectangleHeight + 4;
    }

    public Dimension getDimension() {
        return new Dimension(this.innerRectangleWidth + 1, this.innerRectangleHeight + 1);
        //	return new Dimension(this.outerRectangleWidth+1,this.outerRectangleHeight+1);
    }

    public int getIconHeight() {
        return iconheight;
    }

    public int getIconWidth() {
        return iconwidth;
    }

    public void setLabelSize() {
        this.labelSize = (Math.max(getLabelAbove().length(), getLabelBelow().length()) + 1) * 6;
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setSize(Dimension d) {
        this.iconwidth = d.height;
        this.innerRectangleWidth = this.iconwidth;
        this.outerRectangleWidth = this.innerRectangleWidth + 4;
        this.iconheight = d.width;
        this.innerRectangleHeight = this.iconheight;
        this.outerRectangleHeight = this.innerRectangleHeight + 4;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        /*if (disabled) {

		g.drawRect(x,y,outerRectangleHeight, outerRectangleWidth);

		g.setColor(configMan.getColorTable().getBorderColorDisabledCheckBox());
		g.fillRect(x,y,outerRectangleHeight, outerRectangleWidth);

		g.drawRect(x+2,y+2,innerRectangleHeight,innerRectangleWidth);

		g.setColor(configMan.getColorTable().getInnerColorDisabledCheckBox());
		g.fillRect(x+2,y+2,innerRectangleHeight,innerRectangleWidth);
		}
		else {*/

        if (this.focused == false) {
            /*
                g.setColor(scriptConfiguration.getBorderColorCheckBox());
                g.drawRect(x,y, outerRectangleWidth,outerRectangleHeight);
                g.fillRect(x,y,outerRectangleWidth,outerRectangleHeight);
            */

            g.setColor(scriptConfiguration.getBorderColorCheckBox());
            g.drawRect(x + 1, y + 1, innerRectangleWidth + 1, innerRectangleHeight + 1);
            g.setColor(scriptConfiguration.getInnerColorCheckBox());
            g.fillRect(x + 2, y + 2, innerRectangleWidth, innerRectangleHeight);
            g.setFont(scriptConfiguration.getScriptFont());
            g.setColor(scriptConfiguration.getFontColor());
            if (getColumns() == 2) {
                g.drawString(getLabelAbove(), x + 5, y + 11);
                g.drawString(getLabelBelow(), x + 5, y + 23);
            } else {
                if (this.labelAbove != null)
                    g.drawString(getLabelAbove(), x + 5, y + 11);
                else
                    g.drawString(getLabelBelow(), x + 5, y + 11);
            }
        } else {
            /*
                g.drawRect(x,y,outerRectangleWidth,outerRectangleHeight);

                g.setColor(scriptConfiguration.getBorderColorFocusedCheckBox());
                g.fillRect(x,y, outerRectangleWidth,outerRectangleHeight);
            */

            g.setColor(scriptConfiguration.getBorderColorCheckBox());
            g.drawRect(x + 1, y + 1, innerRectangleWidth + 1, innerRectangleHeight + 1);
            g.setColor(scriptConfiguration.getInnerColorFocusedCheckBox());
            g.fillRect(x + 2, y + 2, innerRectangleWidth, innerRectangleHeight);
            g.setFont(scriptConfiguration.getScriptFont());
            g.setColor(scriptConfiguration.getFontColor());
            if (getColumns() == 2) {
                g.drawString(getLabelAbove(), x + 5, y + 11);
                g.drawString(getLabelBelow(), x + 5, y + 23);
            } else {
                if (this.labelAbove != null)
                    g.drawString(getLabelAbove(), x + 5, y + 11);
                else
                    g.drawString(getLabelBelow(), x + 5, y + 11);
            }
        }
        if (this.isSelected == true) {
            g.setColor(scriptConfiguration.getBorderColor());
            g.drawLine(x + 2, y + 2, x + innerRectangleWidth, y + innerRectangleHeight);
            g.drawLine(x + 2, y + innerRectangleHeight, x + innerRectangleWidth, y + 2);

/*
			g.drawLine(x+2,y+2,x+innerRectangleWidth,y+innerRectangleHeight);
			g.drawLine(x+2,y+innerRectangleHeight,x+innerRectangleWidth,y+2);
*/
        }
    }
}
