/*
 * $RCSfile: ScriptView.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform.formular.script;

import reform.resmedicinae.reform.formular.*;
import reform.resmedicinae.reform.gui.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 * This class represents the Script application view.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:48 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ScriptView extends FormularView {
    private JTextField tf1Insurance = null;
    private JTextField tfName = null;
    private JTextField tfBirthday = null;
    private JTextField tfInsurance1 = null;
    private JTextField tfInsurance2 = null;
    private JTextField tfInsurance3 = null;
    private JTextField tfDate1 = null;
    private JTextField tfDate2 = null;
    private JTextField tfDate3 = null;
    private PicturesCheckBox cbGebuehr1 = null;
    private PicturesCheckBox cbGebuehr2 = null;
    private PicturesCheckBox cbNoctu = null;
    private PicturesCheckBox cbSonstige = null;
    private PicturesCheckBox cbUnfall = null;
    private PicturesCheckBox cbAUnfall = null;
    private PicturesCheckBox cbBVG = null;
    private PicturesCheckBox cbHiflsmittel = null;
    private PicturesCheckBox cbImpfstoff = null;
    private PicturesCheckBox cbBedarf = null;
    private PicturesCheckBox cbAutIdem1 = null;
    private PicturesCheckBox cbAutIdem2 = null;
    private PicturesCheckBox cbAutIdem3 = null;
    private JTextField tfDayOfAccident = null;
    private JTextField tfEmployerNumber = null;
    private JTextArea taRezept = null;
    private ScriptConfiguration scriptConfiguration;

    //	private Script controller = null;
    //	private ResPanel graphicToPrint = null;
    public void initialize() {
        try {
            super.initialize();
            //			setModel(model);
            //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            scriptConfiguration = ScriptConfiguration.getScriptConfiguration(); // noch ins model packen
            this.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            //	this.setResizable(false);
            this.setLocation(300, 300);
            this.setLayout(new BorderLayout());
            this.add(drawFormular(), BorderLayout.SOUTH);
            this.setTitle("Formular: Script");
            //	clearAllTextFields();
            //	this.show();
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
            e.printStackTrace();
        }
    }

    /** Initializes the Script view. */

/*	public void initialize()
	{

		try
		{

			super.initialize();
			scriptConfiguration = ScriptConfiguration.getScriptConfiguration();

			// Set panel properties and add child components.
			//setMinimumSize(640,480);
			//add(abc(), BorderLayout.SOUTH);
			this.add(drawFormular(), BorderLayout.SOUTH);
			setResizable(true);
*/

    /*
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			String[] st = ge.getAvailableFontFamilyNames();
			for (int i=0;i<st.length;i++) System.out.println("Fonts: "+st[i]+"\n");
		*/

/*
		} catch(Exception e)
		{

			//?? getLogger().log("");
			System.out.println("Fehler: " + e);
		}
	}
*/

    /**
     * Creates the script formular
     * @return the ResPanel with the new added Button
     */
    protected ResPanel drawFormular() throws Exception {
        ResPanel mainPanel = new ResPanel();
        //	ResPanel northPanel = new ResPanel();
        if (mainPanel != null) {
            Font fontLabel = new Font("Label", Font.PLAIN, 10);
            setForeground(scriptConfiguration.getFontColor());
            mainPanel.setLayout(new GridLayout(2, 1));
            //			northPanel.setLayout(new GridBagLayout());
            mainPanel.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            //			northPanel.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            ResPanel allgAngabenPanel = new ResPanel();
            allgAngabenPanel.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            ResPanel zusatzPanel = new ResPanel();
            zusatzPanel.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            ResPanel scriptPanel = new ResPanel();
            scriptPanel.setBackground(scriptConfiguration.getScriptBackGroundColorRed());
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            allgAngabenPanel.setLayout(gridbag);
            JTextField tf1InsuranceLabel = new JTextField();
            tf1InsuranceLabel.setColumns(36);
            tf1InsuranceLabel.setText("Krankenkasse bzw. Kostentrger");
            tf1InsuranceLabel.setEnabled(false);
            tf1Insurance = new JTextField();
            tf1Insurance.setColumns(36);
            tf1Insurance.setForeground(scriptConfiguration.getFontColor());
            tf1Insurance.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfNameLabel = new JTextField();
            tfNameLabel.setColumns(25);
            tfNameLabel.setText("Name, Vorname des Versicherten");
            tfNameLabel.setEnabled(false);
            tfName = new JTextField();
            tfName.setColumns(25);
            tfName.setForeground(scriptConfiguration.getFontColor());
            tfName.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfBirthdayLabel = new JTextField();
            tfBirthdayLabel.setColumns(11);
            tfBirthdayLabel.setText("geb. am");
            tfBirthdayLabel.setEnabled(false);
            tfBirthday = new JTextField();
            tfBirthday.setColumns(11);
            tfBirthday.setForeground(scriptConfiguration.getFontColor());
            tfBirthday.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfInsurance1Label = new JTextField();
            tfInsurance1Label.setColumns(12);
            tfInsurance1Label.setText("Kassen-Nr.");
            tfInsurance1Label.setEnabled(false);
            tfInsurance1 = new JTextField();
            tfInsurance1.setColumns(12);
            tfInsurance1.setForeground(scriptConfiguration.getFontColor());
            tfInsurance1.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfInsurance2Label = new JTextField();
            tfInsurance2Label.setColumns(13);
            tfInsurance2Label.setText("Versicherten-Nr.");
            tfInsurance2Label.setEnabled(false);
            tfInsurance2 = new JTextField();
            tfInsurance2.setColumns(13);
            tfInsurance2.setForeground(scriptConfiguration.getFontColor());
            tfInsurance2.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfInsurance3Label = new JTextField();
            tfInsurance3Label.setColumns(11);
            tfInsurance3Label.setText("Status");
            tfInsurance3Label.setEnabled(false);
            tfInsurance3 = new JTextField();
            tfInsurance3.setColumns(11);
            tfInsurance3.setForeground(scriptConfiguration.getFontColor());
            tfInsurance3.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfDate1Label = new JTextField();
            tfDate1Label.setColumns(12);
            tfDate1Label.setText("Vertragsarzt-Nr.");
            tfDate1Label.setEnabled(false);
            tfDate1 = new JTextField();
            tfDate1.setColumns(12);
            tfDate1.setForeground(scriptConfiguration.getFontColor());
            tfDate1.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfDate2Label = new JTextField();
            tfDate2Label.setColumns(13);
            tfDate2Label.setText("VK gltig bis");
            tfDate2Label.setEnabled(false);
            tfDate2 = new JTextField();
            tfDate2.setColumns(13);
            tfDate2.setForeground(scriptConfiguration.getFontColor());
            tfDate2.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfDate3Label = new JTextField();
            tfDate3Label.setColumns(11);
            tfDate3Label.setText("Datum");
            tfDate3Label.setEnabled(false);
            tfDate3 = new JTextField();
            tfDate3.setColumns(11);
            tfDate3.setForeground(scriptConfiguration.getFontColor());
            tfDate3.getDocument().addDocumentListener(getDocumentListener());
            cbGebuehr1 = new PicturesCheckBox();
            cbGebuehr1.setTwoLabels("Gebhr", "frei");
            cbGebuehr1.setSize(new Dimension(25, 40));
            cbGebuehr1.createPicturesCheckBox();
            cbGebuehr1.disableLabel(false);
            cbGebuehr1.addItemListener(getItemListener());
            Dimension d = cbGebuehr1.getSize();
            cbGebuehr2 = new PicturesCheckBox();
            cbGebuehr2.setTwoLabels("Geb.-", "pfl.");
            cbGebuehr2.setSize(new Dimension(25, 40));
            cbGebuehr2.createPicturesCheckBox();
            cbGebuehr2.addItemListener(getItemListener());
            cbNoctu = new PicturesCheckBox();
            cbNoctu.setOneLabel("noctu");
            cbNoctu.setSize(new Dimension(13, 40));
            cbNoctu.createPicturesCheckBox();
            cbNoctu.addItemListener(getItemListener());
            cbSonstige = new PicturesCheckBox();
            cbSonstige.setOneLabel("Sonstige");
            cbSonstige.setSize(new Dimension(13, 40));
            cbSonstige.createPicturesCheckBox();
            cbSonstige.addItemListener(getItemListener());
            cbUnfall = new PicturesCheckBox();
            cbUnfall.setOneLabel("Unfall");
            cbUnfall.setSize(new Dimension(13, 40));
            cbUnfall.createPicturesCheckBox();
            cbUnfall.addItemListener(getItemListener());
            cbAUnfall = new PicturesCheckBox();
            cbAUnfall.setTwoLabels("Arbeits-", "unfall");
            cbAUnfall.setSize(new Dimension(25, 40));
            cbAUnfall.createPicturesCheckBox();
            cbAUnfall.addItemListener(getItemListener());
            ButtonGroup buttonGroupFee = new ButtonGroup();
            buttonGroupFee.add(cbGebuehr1);
            buttonGroupFee.add(cbGebuehr2);
            //	buttonGroupFee.add(cbNoctu);
            //	buttonGroupFee.add(cbSonstige);
            ButtonGroup buttonGroupAccident = new ButtonGroup();
            buttonGroupAccident.add(cbUnfall);
            buttonGroupAccident.add(cbAUnfall);
            c.anchor = GridBagConstraints.NORTHWEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(15, 5, 0, 5);
            gridbag.setConstraints(cbGebuehr1, c);
            allgAngabenPanel.add(cbGebuehr1);
            c.gridy = 1;
            c.insets = new Insets(5, 5, 0, 5);
            gridbag.setConstraints(cbGebuehr2, c);
            allgAngabenPanel.add(cbGebuehr2);
            c.gridy = 2;
            c.insets = new Insets(0, 5, 0, 5);
            gridbag.setConstraints(cbNoctu, c);
            allgAngabenPanel.add(cbNoctu);
            c.insets = new Insets(15, 5, 0, 5);
            gridbag.setConstraints(cbSonstige, c);
            allgAngabenPanel.add(cbSonstige);
            c.insets = new Insets(30, 5, 0, 5);
            gridbag.setConstraints(cbUnfall, c);
            allgAngabenPanel.add(cbUnfall);
            c.gridy = 3;
            c.insets = new Insets(5, 5, 0, 5);
            gridbag.setConstraints(cbAUnfall, c);
            allgAngabenPanel.add(cbAUnfall);
            c.weightx = 0.9;
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 3;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tf1InsuranceLabel, c);
            allgAngabenPanel.add(tf1InsuranceLabel);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tf1Insurance, c);
            allgAngabenPanel.add(tf1Insurance);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 2;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfNameLabel, c);
            allgAngabenPanel.add(tfNameLabel);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfName, c);
            allgAngabenPanel.add(tfName);
            c.gridx = 3;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfBirthdayLabel, c);
            allgAngabenPanel.add(tfBirthdayLabel);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfBirthday, c);
            allgAngabenPanel.add(tfBirthday);
            c.gridy = 2;
            c.gridx = 1;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfInsurance1Label, c);
            allgAngabenPanel.add(tfInsurance1Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfInsurance1, c);
            allgAngabenPanel.add(tfInsurance1);
            c.gridx = 2;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfInsurance2Label, c);
            allgAngabenPanel.add(tfInsurance2Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfInsurance2, c);
            allgAngabenPanel.add(tfInsurance2);
            c.gridx = 3;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfInsurance3Label, c);
            allgAngabenPanel.add(tfInsurance3Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfInsurance3, c);
            allgAngabenPanel.add(tfInsurance3);
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfDate1Label, c);
            allgAngabenPanel.add(tfDate1Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfDate1, c);
            allgAngabenPanel.add(tfDate1);
            c.gridx = 2;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfDate2Label, c);
            allgAngabenPanel.add(tfDate2Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfDate2, c);
            allgAngabenPanel.add(tfDate2);
            c.gridx = 3;
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfDate3Label, c);
            allgAngabenPanel.add(tfDate3Label);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfDate3, c);
            allgAngabenPanel.add(tfDate3);
            gridbag = new GridBagLayout();
            c = new GridBagConstraints();
            zusatzPanel.setLayout(gridbag);
            TLabel lBVG = new TLabel("BVG");
            lBVG.setPreferredSize(new Dimension(25, 32));
            cbBVG = new PicturesCheckBox();
            cbBVG.setOneLabel("6");
            //	cbBVG.setSize(new Dimension(20,30));
            cbBVG.createPicturesCheckBox();
            cbBVG.addItemListener(getItemListener());
            TLabel lHilfsmittel = new TLabel("Hilfs-", "mittel");
            lHilfsmittel.setPreferredSize(new Dimension(30, 32));
            cbHiflsmittel = new PicturesCheckBox();
            cbHiflsmittel.setOneLabel("7");
            //	cbHiflsmittel.setSize(new Dimension(20,30));
            cbHiflsmittel.createPicturesCheckBox();
            cbHiflsmittel.addItemListener(getItemListener());
            TLabel lImpfstoff = new TLabel("Impf-", "stoff");
            lImpfstoff.setPreferredSize(new Dimension(25, 32));
            cbImpfstoff = new PicturesCheckBox();
            cbImpfstoff.setOneLabel("8");
            //	cbImpfstoff.setSize(new Dimension(20,30));
            cbImpfstoff.createPicturesCheckBox();
            cbImpfstoff.addItemListener(getItemListener());
            TLabel lBedarf = new TLabel("Spr.-St.", "Bedarf");
            lBedarf.setPreferredSize(new Dimension(35, 32));
            cbBedarf = new PicturesCheckBox();
            cbBedarf.setOneLabel("9");
            //	cbBedarf.setSize(new Dimension(20,30));
            cbBedarf.createPicturesCheckBox();
            cbBedarf.addItemListener(getItemListener());
            c.anchor = GridBagConstraints.NORTHWEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 10, 0, 0);
            gridbag.setConstraints(lBVG, c);
            zusatzPanel.add(lBVG);
            c.gridy = 1;
            gridbag.setConstraints(cbBVG, c);
            zusatzPanel.add(cbBVG);
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 0);
            gridbag.setConstraints(lHilfsmittel, c);
            zusatzPanel.add(lHilfsmittel);
            c.gridy = 1;
            gridbag.setConstraints(cbHiflsmittel, c);
            zusatzPanel.add(cbHiflsmittel);
            c.gridx = 2;
            c.gridy = 0;
            //	c.insets = new Insets(0,90,0,0);
            gridbag.setConstraints(lImpfstoff, c);
            zusatzPanel.add(lImpfstoff);
            c.gridy = 1;
            gridbag.setConstraints(cbImpfstoff, c);
            zusatzPanel.add(cbImpfstoff);
            c.gridx = 3;
            c.gridy = 0;
            //	c.insets = new Insets(0,130,0,0);
            gridbag.setConstraints(lBedarf, c);
            zusatzPanel.add(lBedarf);
            c.gridy = 1;
            gridbag.setConstraints(cbBedarf, c);
            zusatzPanel.add(cbBedarf);
            gridbag = new GridBagLayout();
            c = new GridBagConstraints();
            scriptPanel.setLayout(gridbag);
            Font fontBoldLabel = new Font("BoldLabel", Font.BOLD, 12);
            JLabel lRp1 = new JLabel();
            lRp1.setFont(fontBoldLabel);
            lRp1.setText("Rp. ");
            lRp1.setForeground(scriptConfiguration.getFontColor());
            JLabel lRp2 = new JLabel();
            lRp2.setFont(fontLabel);
            lRp2.setText("(Bitte Leerume durchstreichen)");
            lRp2.setForeground(scriptConfiguration.getFontColor());
            JLabel lStempel = new JLabel();
            lStempel.setFont(fontLabel);
            lStempel.setText("Vertragsarztstempel");
            lStempel.setForeground(scriptConfiguration.getFontColor());
            JLabel lUnterschrift1 = new JLabel();
            lUnterschrift1.setText("Unterschrift des Arztes");
            lUnterschrift1.setFont(new Font("PlainLabel", Font.PLAIN, 10));
            lUnterschrift1.setForeground(scriptConfiguration.getFontColor());
            JLabel lUnterschrift2 = new JLabel();
            lUnterschrift2.setFont(fontLabel);
            lUnterschrift2.setText("Muster 16 (4.2002)");
            lUnterschrift2.setForeground(scriptConfiguration.getFontColor());
            JLabel lAccidentAtWork = new JLabel();
            lAccidentAtWork.setFont(fontLabel);
            lAccidentAtWork.setText("Bei Arbeitsunfall auszufllen!");
            lAccidentAtWork.setForeground(scriptConfiguration.getFontColor());
            lAccidentAtWork.setForeground(scriptConfiguration.getFontColor());
            JTextField tfDayOfAccidentLabel = new JTextField();
            tfDayOfAccidentLabel.setColumns(6);
            tfDayOfAccidentLabel.setText("UnfallTag");
            tfDayOfAccidentLabel.setEnabled(false);
            tfDayOfAccident = new JTextField();
            tfDayOfAccident.setColumns(6);
            tfDayOfAccident.setForeground(scriptConfiguration.getFontColor());
            tfDayOfAccident.getDocument().addDocumentListener(getDocumentListener());
            JTextField tfEmployerNumberLabel = new JTextField();
            tfEmployerNumberLabel.setColumns(30);
            tfEmployerNumberLabel.setText("Unfallbetrieb oder Arbeitgebernummer");
            tfEmployerNumberLabel.setEnabled(false);
            tfEmployerNumber = new JTextField();
            tfEmployerNumber.setColumns(30);
            tfEmployerNumber.setForeground(scriptConfiguration.getFontColor());
            tfEmployerNumber.getDocument().addDocumentListener(getDocumentListener());
            cbAutIdem1 = new PicturesCheckBox();
            cbAutIdem1.setTwoLabels("aut", "idem");
            cbAutIdem1.setSize(new Dimension(25, 40));
            cbAutIdem1.createPicturesCheckBox();
            cbAutIdem1.addItemListener(getItemListener());
            cbAutIdem2 = new PicturesCheckBox();
            cbAutIdem2.setTwoLabels("aut", "idem");
            cbAutIdem2.setSize(new Dimension(25, 40));
            cbAutIdem2.createPicturesCheckBox();
            cbAutIdem2.addItemListener(getItemListener());
            cbAutIdem3 = new PicturesCheckBox();
            cbAutIdem3.setTwoLabels("aut", "idem");
            cbAutIdem3.setSize(new Dimension(25, 40));
            cbAutIdem3.createPicturesCheckBox();
            cbAutIdem3.addItemListener(getItemListener());
            ButtonGroup buttonGroupAutIdem = new ButtonGroup();
            buttonGroupAutIdem.add(cbAutIdem1);
            buttonGroupAutIdem.add(cbAutIdem2);
            buttonGroupAutIdem.add(cbAutIdem3);
            taRezept = new JTextArea();
            taRezept.setColumns(36);
            taRezept.setRows(8);
            taRezept.getDocument().addDocumentListener(getDocumentListener());
            //	taRezept.setBackground(new Color(255,200,190));
            c.anchor = GridBagConstraints.NORTHWEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(5, 10, 0, 0);
            gridbag.setConstraints(lRp1, c);
            scriptPanel.add(lRp1);
            c.gridx = 2;
            c.insets = new Insets(7, 0, 0, 0);
            gridbag.setConstraints(lRp2, c);
            scriptPanel.add(lRp2);
            c.gridx = 8;
            c.gridy = 0;
            c.insets = new Insets(7, 20, 0, 0);
            gridbag.setConstraints(lStempel, c);
            scriptPanel.add(lStempel);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(20, 5, 0, 0);
            gridbag.setConstraints(cbAutIdem1, c);
            scriptPanel.add(cbAutIdem1);
            c.gridy = 2;
            c.insets = new Insets(10, 5, 0, 0);
            gridbag.setConstraints(cbAutIdem2, c);
            scriptPanel.add(cbAutIdem2);
            c.gridy = 3;
            gridbag.setConstraints(cbAutIdem3, c);
            scriptPanel.add(cbAutIdem3);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 7;
            c.gridheight = 4;
            c.insets = new Insets(2, 5, 0, 0);
            gridbag.setConstraints(taRezept, c);
            scriptPanel.add(taRezept);
            c.gridx = 8;
            c.gridy = 4;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 20, 0, 0);
            gridbag.setConstraints(lUnterschrift1, c);
            scriptPanel.add(lUnterschrift1);
            c.gridy = 4;
            c.insets = new Insets(15, 35, 0, 0);
            gridbag.setConstraints(lUnterschrift2, c);
            scriptPanel.add(lUnterschrift2);
            c.gridx = 0;
            c.gridy = 5;
            c.gridwidth = 3;
            c.insets = new Insets(0, 5, 0, 0);
            gridbag.setConstraints(lAccidentAtWork, c);
            scriptPanel.add(lAccidentAtWork);
            c.gridx = 0;
            c.gridy = 6;
            c.gridwidth = 2;
            c.insets = new Insets(5, 5, 0, 0);
            gridbag.setConstraints(tfDayOfAccidentLabel, c);
            scriptPanel.add(tfDayOfAccidentLabel);
            c.insets = new Insets(25, 5, 0, 0);
            gridbag.setConstraints(tfDayOfAccident, c);
            scriptPanel.add(tfDayOfAccident);
            c.gridx = 2;
            c.gridwidth = 2;
            c.insets = new Insets(5, 0, 0, 0);
            gridbag.setConstraints(tfEmployerNumberLabel, c);
            scriptPanel.add(tfEmployerNumberLabel);
            c.insets = new Insets(25, 0, 0, 0);
            gridbag.setConstraints(tfEmployerNumber, c);
            scriptPanel.add(tfEmployerNumber);
            gridbag = new GridBagLayout();
            c = new GridBagConstraints();
            c.anchor = GridBagConstraints.NORTHWEST;
            c.fill = GridBagConstraints.NONE;
            c.weightx = 0.5;
            c.gridy = 0;
            c.gridwidth = GridBagConstraints.RELATIVE;
            mainPanel.setLayout(gridbag);
            gridbag.setConstraints(allgAngabenPanel, c);
            mainPanel.add(allgAngabenPanel);
            c.gridwidth = GridBagConstraints.REMAINDER;
            gridbag.setConstraints(zusatzPanel, c);
            mainPanel.add(zusatzPanel);
            c.weightx = 1.0;
            c.gridy = 1;
            gridbag.setConstraints(scriptPanel, c);
            mainPanel.add(scriptPanel);

/*
			gridbag = new GridBagLayout();
			c = new GridBagConstraints();
			mainPanel.setLayout(gridbag);

			c.anchor = GridBagConstraints.WEST;
			c.gridx = 0;
			c.gridy = 0;
			//	c.insets = new Insets(20,0,0,0);
			gridbag.setConstraints(allgAngabenPanel, c);
			mainPanel.add(allgAngabenPanel);
		//	c.anchor = GridBagConstraints.EAST;
			c.gridx = 1;
			c.gridy = 0;
			gridbag.setConstraints(zusatzPanel, c);
			mainPanel.add(zusatzPanel);
			c.anchor = GridBagConstraints.SOUTH;
			c.gridx = 0;
			c.gridy = 1;
			c.gridwidth = 2;
			gridbag.setConstraints(scriptPanel, c);
			mainPanel.add(scriptPanel);
*/

            //	mainPanel.add(northPanel);
            //	mainPanel.add(scriptPanel);
            //		southPanel.add(scriptPanel,BorderLayout.NORTH);
            //	  	northPanel.add(gebuehrenPanel,BorderLayout.CENTER);
            //		mainPanel.add(northPanel,BorderLayout.NORTH);
            //		mainPanel.add(scriptPanel,BorderLayout.WEST);
            //  	mainPanel.setBackground(scriptBackGroundColorRed);
            //      mainPanel.setSize(300,900);
            //		mainPanel.add(new SButton(ScriptController.EXIT_SYSTEM_CONTROL_ID),BorderLayout.SOUTH);
        } else {
            throw new Exception("Cannot create input panel. Some parameter is null.");
        }
        return mainPanel;
    }

    /**
     * Creates a title.
     * @return the title
     */
    public String createTitle() {
        return "Script";
    }

    /**
     * Creates an icon.
     * @return the icon
     */
    public String createIcon() {
        return "Icon";
    }

    /**
     * Creates a border layout.
     * @return the border layout
     */
    public BorderLayout createBorderLayout() {
        return new BorderLayout();
    }

    /**
     * Returns the content of textfield tf1
     * @return the content of textfield tf1
     */
    public org.resmedicinae.resmedlib.term.String getTf1Insurance() {
        return new org.resmedicinae.resmedlib.term.String(tf1Insurance.getText());
    }

    /**
     * Returns the content of textfield tfName
     * @return the content of textfield tfName
     */
    public org.resmedicinae.resmedlib.term.String getHealthRecordName() {
        return new org.resmedicinae.resmedlib.term.String(tfName.getText());
    }

    /**
     * Returns the content of textfield tfBirthday
     * @return the content of textfield tfBirthday
     */
    public org.resmedicinae.resmedlib.term.String getBirthdayday() {
        return new org.resmedicinae.resmedlib.term.String(tfBirthday.getText());
    }

    /**
     * Returns the content of textfield tfInsurance1
     * @return the content of textfield tfInsurance1
     */
    public org.resmedicinae.resmedlib.term.String getInsurance1() {
        return new org.resmedicinae.resmedlib.term.String(tfInsurance1.getText());
    }

    /**
     * Returns the content of textfield tfInsurance2
     * @return the content of textfield tfInsurance2
     */
    public org.resmedicinae.resmedlib.term.String getInsurance2() {
        return new org.resmedicinae.resmedlib.term.String(tfInsurance2.getText());
    }

    /**
     * Returns the content of textfield tfInsurance3
     * @return the content of textfield tfInsurance3
     */
    public org.resmedicinae.resmedlib.term.String getInsurance3() {
        return new org.resmedicinae.resmedlib.term.String(tfInsurance3.getText());
    }

    /**
     * Returns the content of textfield tfDate1
     * @return the content of textfield tfDate1
     */
    public org.resmedicinae.resmedlib.term.String getDate1() {
        return new org.resmedicinae.resmedlib.term.String(tfDate1.getText());
    }

    /**
     * Returns the content of textfield tfDate2
     * @return the content of textfield tfDate2
     */
    public org.resmedicinae.resmedlib.term.String getDate2() {
        return new org.resmedicinae.resmedlib.term.String(tfDate2.getText());
    }

    /**
     * Returns the content of textfield tfDate3
     * @return the content of textfield tfDate3
     */
    public org.resmedicinae.resmedlib.term.String getDate3() {
        return new org.resmedicinae.resmedlib.term.String(tfDate3.getText());
    }

    /**
     * Returns the content of textfield tfDayOfAccident
     * @return the content of textfield tfDayOfAccident
     */
    public org.resmedicinae.resmedlib.term.String getDayOfAccident() {
        return new org.resmedicinae.resmedlib.term.String(tfDayOfAccident.getText());
    }

    /**
     * Returns the content of textfield tfEmployerNumber
     * @return the content of textfield tfEmployerNumber
     */
    public org.resmedicinae.resmedlib.term.String getEmployerNumber() {
        return new org.resmedicinae.resmedlib.term.String(tfEmployerNumber.getText());
    }

    /**
     * Returns the content of textfield tfTaxe3
     * @return the content of textfield tfTaxe3
     */
    public org.resmedicinae.resmedlib.term.String getRezept() {
        return new org.resmedicinae.resmedlib.term.String(taRezept.getText());
    }

    public PicturesCheckBox getCbGebuehr1() {
        return cbGebuehr1;
    }

    public PicturesCheckBox getCbGebuehr2() {
        return cbGebuehr2;
    }

    public PicturesCheckBox getCbNoctu() {
        return cbNoctu;
    }

    public PicturesCheckBox getCbSonstige() {
        return cbSonstige;
    }

    public PicturesCheckBox getCbUnfall() {
        return cbUnfall;
    }

    public PicturesCheckBox getCbAUnfall() {
        return cbAUnfall;
    }

    public PicturesCheckBox getCbBVG() {
        return cbBVG;
    }

    public PicturesCheckBox getCbHiflsmittel() {
        return cbHiflsmittel;
    }

    public PicturesCheckBox getCbImpfstoff() {
        return cbImpfstoff;
    }

    public PicturesCheckBox getCbBedarf() {
        return cbBedarf;
    }

    public PicturesCheckBox getCbAutIdem1() {
        return cbAutIdem1;
    }

    public PicturesCheckBox getCbAutIdem2() {
        return cbAutIdem2;
    }

    public PicturesCheckBox getCbAutIdem3() {
        return cbAutIdem3;
    }

    public void setTf1Insurance(org.resmedicinae.resmedlib.term.String tf1Insurance) {
        this.tf1Insurance.setText(tf1Insurance.getValue());
    }

    public void setTfName(org.resmedicinae.resmedlib.term.String tfName) {
        this.tfName.setText(tfName.getValue());
    }

    public void setTfBirthday(org.resmedicinae.resmedlib.term.String tfBirthday) {
        this.tfBirthday.setText(tfBirthday.getValue());
    }

    public void setTfInsurance1(org.resmedicinae.resmedlib.term.String tfInsurance1) {
        this.tfInsurance1.setText(tfInsurance1.getValue());
    }

    public void setTfInsurance2(org.resmedicinae.resmedlib.term.String tfInsurance2) {
        this.tfInsurance2.setText(tfInsurance2.getValue());
    }

    public void setTfInsurance3(org.resmedicinae.resmedlib.term.String tfInsurance3) {
        this.tfInsurance3.setText(tfInsurance3.getValue());
    }

    public void setTfDate1(org.resmedicinae.resmedlib.term.String tfDate1) {
        this.tfDate1.setText(tfDate1.getValue());
    }

    public void setTfDate2(org.resmedicinae.resmedlib.term.String tfDate2) {
        this.tfDate2.setText(tfDate2.getValue());
    }

    public void setTfDate3(org.resmedicinae.resmedlib.term.String tfDate3) {
        this.tfDate3.setText(tfDate3.getValue());
    }

    public void setCbGebuehr1(PicturesCheckBox cbGebuehr1) {
        this.cbGebuehr1 = cbGebuehr1;
    }

    public void setCbGebuehr2(PicturesCheckBox cbGebuehr2) {
        this.cbGebuehr2 = cbGebuehr2;
    }

    public void setCbNoctu(PicturesCheckBox cbNoctu) {
        this.cbNoctu = cbNoctu;
    }

    public void setCbSonstige(PicturesCheckBox cbSonstige) {
        this.cbSonstige = cbSonstige;
    }

    public void setCbUnfall(PicturesCheckBox cbUnfall) {
        this.cbUnfall = cbUnfall;
    }

    public void setCbAUnfall(PicturesCheckBox cbAUnfall) {
        this.cbAUnfall = cbAUnfall;
    }

    public void setCbBVG(PicturesCheckBox cbBVG) {
        this.cbBVG = cbBVG;
    }

    public void setCbHiflsmittel(PicturesCheckBox cbHiflsmittel) {
        this.cbHiflsmittel = cbHiflsmittel;
    }

    public void setCbImpfstoff(PicturesCheckBox cbImpfstoff) {
        this.cbImpfstoff = cbImpfstoff;
    }

    public void setCbBedarf(PicturesCheckBox cbBedarf) {
        this.cbBedarf = cbBedarf;
    }

    public void setCbAutIdem1(PicturesCheckBox cbAutIdem1) {
        this.cbAutIdem1 = cbAutIdem1;
    }

    public void setCbAutIdem2(PicturesCheckBox cbAutIdem2) {
        this.cbAutIdem2 = cbAutIdem2;
    }

    public void setCbAutIdem3(PicturesCheckBox cbAutIdem3) {
        this.cbAutIdem3 = cbAutIdem3;
    }

    public void setTfDayOfAccident(org.resmedicinae.resmedlib.term.String tfDayOfAccident) {
        this.tfDayOfAccident.setText(tfDayOfAccident.getValue());
    }

    public void setTfEmployerNumber(org.resmedicinae.resmedlib.term.String tfEmployerNumber) {
        this.tfEmployerNumber.setText(tfEmployerNumber.getValue());
    }

    public void setTaRezept(org.resmedicinae.resmedlib.term.String taRezept) {
        this.taRezept.setText(taRezept.getValue());
    }

    public void setScriptConfiguration(ScriptConfiguration scriptConfiguration) {
        this.scriptConfiguration = scriptConfiguration;
    }
    /*
	public Script getController()
	{
		return this.controller;
	}

	public void setController(Script controller)
	{
		this.controller = controller;
	}

*/

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 605;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 445;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Script.DESTROY_SCRIPT_FORMULAR_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    public void getPrintMask(Graphics2D graphics, Rectangle printArea, FontMetrics fontMetrics) {
        ScriptModel model = (ScriptModel) getModel();
        float relPosX = 0;
        float relPosY = 0;
        float absPosX = (float) (printArea.getX() + relPosX);
        float absPosY = (float) (printArea.getY() + relPosY);
        absPosX += 20;
        if (model.getTf1Insurance() != null)
            graphics.drawString(model.getTf1Insurance().getValue(), absPosX, absPosY);
        absPosY += 50;
        if (model.getHealthRecordName() != null)
            graphics.drawString(model.getHealthRecordName().getValue(), absPosX, absPosY);
        absPosX += 160;
        if (model.getBirthdayday() != null)
            graphics.drawString(model.getBirthdayday().getValue(), absPosX, absPosY);
        absPosX -= 160;
        absPosY += 29;
        if (model.getInsurance1() != null)
            graphics.drawString(model.getInsurance1().getValue(), absPosX, absPosY);
        absPosX += 60;
        if (model.getInsurance2() != null)
            graphics.drawString(model.getInsurance2().getValue(), absPosX, absPosY);
        absPosX += 100;
        if (model.getInsurance3() != null)
            graphics.drawString(model.getInsurance3().getValue(), absPosX, absPosY);
        absPosX -= 160;
        absPosY += 24;
        if (model.getDate1() != null)
            graphics.drawString(model.getDate1().getValue(), absPosX, absPosY);
        absPosX += 83;
        if (model.getDate2() != null)
            graphics.drawString(model.getDate2().getValue(), absPosX, absPosY);
        absPosX += 70;
        if (model.getDate3() != null)
            graphics.drawString(model.getDate3().getValue(), absPosX, absPosY);
        absPosX -= 150;
        absPosY += 28;
        if (model.getRezept() != null)
            graphics.drawString(model.getRezept().getValue(), absPosX, absPosY);
        absPosX = (float) (printArea.getX() + relPosX + 3);
        absPosY = (float) (printArea.getY() + relPosY + 240);
        if (model.getDayOfAccident() != null)
            graphics.drawString(model.getDayOfAccident().getValue(), absPosX, absPosY);
        absPosX += 58;
        if (model.getEmployerNumber() != null)
            graphics.drawString(model.getEmployerNumber().getValue(), absPosX, absPosY);
        absPosX = (float) (printArea.getX() + relPosX);
        absPosY = (float) (printArea.getY() + relPosY);
        if (model.getCbGebuehr() != null) {
            if (model.getCbGebuehr().getValue().compareTo("Gebhrfrei") == 0) {
                graphics.drawString("X", absPosX, absPosY);
                absPosY += 17;
            } else if (model.getCbGebuehr().getValue().compareTo("Geb.-pfl.") == 0) {
                absPosY += 17;
                graphics.drawString("X", absPosX, absPosY);
            }
        } else {
            absPosY += 17;
        }
        absPosY += 17;
        if (model.getCbNoctu() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
        absPosY += 24;
        if (model.getCbSonstige() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
        if (model.getCbUnfall() != null) {
            if (model.getCbUnfall().getValue().compareTo("Unfall") == 0) {
                absPosY += 24;
                graphics.drawString("X", absPosX, absPosY);
                absPosY += 25;
            } else if (model.getCbUnfall().getValue().compareTo("Arbeits-unfall") == 0) {
                absPosY += 49;
                graphics.drawString("X", absPosX, absPosY);
            }
        } else {
            absPosY += 49;
        }
        absPosY += 36;
        if (model.getCbAutIdem() != 0) {
            if (model.getCbAutIdem() == 1) {
                graphics.drawString("X", absPosX, absPosY);
            } else if (model.getCbAutIdem() == 2) {
                absPosY += 22;
                graphics.drawString("X", absPosX, absPosY);
            } else if (model.getCbAutIdem() == 3) {
                absPosY += 44;
                graphics.drawString("X", absPosX, absPosY);
            }
        }
        absPosX = (float) (printArea.getX() + relPosX + 252);
        absPosY = (float) (printArea.getY() + relPosY);
        if (model.getCbBVG() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
        absPosX += 15;
        if (model.getCbHiflsmittel() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
        absPosX += 15;
        if (model.getCbImpfstoff() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
        absPosX += 15;
        if (model.getCbBedarf() != null) {
            graphics.drawString("X", absPosX, absPosY);
        }
    }
}
