/*
 * $RCSfile: ReFormView.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform;

import org.resmedicinae.application.controller.basic.*;
import reform.resmedicinae.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.component.view.swing.*;
import org.resmedicinae.resmedlib.term.String;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class represents the Printer application view.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:46 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ReFormView extends SwingView {
    /** Initializes the ReForm view. */
    public void initialize() {
        try {
            super.initialize();
            //	setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            // Set panel properties and add child components.
            this.setTitle("ReForm");
            setResizable(true);
            setLayout(new BorderLayout());
            add(createPanel(), BorderLayout.CENTER);
            //setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            setDialogBounds(createDialogBounds());
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
        }
    }


    /**
     * Creates a splash window.
     * @return the splash window
     */
    public ResWindow createSplashWindow() {
        /*??
        getLogger().log(Level.CONFIG, "Create splash window.");
        return new org.resmedicinae.resmedlib.presentation.AbstractSplashWindow(this, 1, 8);
        */
        return null;
    }

    /**
     * Creates a title.
     * @return the title
     */
    public String createTitle() {
        return "Printer";
    }

    /**
     * Creates a icon.
     * @return the icon
     */
    public String createIcon() {
        return "Icon";
    }

    /**
     * Creates a border layout.
     * @return the border layout
     */
    public BorderLayout createBorderLayout() {
        return new BorderLayout();
    }

    /**
     * Returns the menu bar. menu2.setMnemonic(KeyEvent.VK_E); ??Todo: Replace return type with ResMenuBar
     * @return the menu bar
     */
    public ResMenuBar getMenuBar() {
        ResMenuBar mb = new ResMenuBar();
        ResMenu menu1 = new ResMenu(); // file
        ResMenu menu2 = new ResMenu(); // card index
        ResMenu menu3 = new ResMenu(); // healthRecord
        ResMenu menu4 = new ResMenu(); // formular
        ResMenu menu5 = new ResMenu(); // help
        ResMenuItem menuItem12 = new ResMenuItem();
        ResMenuItem menuItem13 = new ResMenuItem();
        ResMenuItem menuItem14 = new ResMenuItem();
        ResMenuItem menuItem15 = new ResMenuItem();
        ResMenuItem menuItem16 = new ResMenuItem();
        ResMenuItem menuItem17 = new ResMenuItem();
        ResMenuItem menuItem19 = new ResMenuItem();
        ResMenuItem menuItem20 = new ResMenuItem();
        ResMenuItem menuItem21 = new ResMenuItem();
        ResMenuItem menuItem22 = new ResMenuItem();
        ResMenuItem menuItem23 = new ResMenuItem();
        ResMenuItem menuItem30 = new ResMenuItem();
        ResMenuItem menuItem31 = new ResMenuItem();
        ResMenuItem menuItem32 = new ResMenuItem();
        ResMenuItem menuItem33 = new ResMenuItem();
        ResMenuItem menuItem34 = new ResMenuItem();
        ResMenuItem menuItem35 = new ResMenuItem();
        ResMenuItem menuItem40 = new ResMenuItem();
        ResMenuItem menuItem41 = new ResMenuItem();
        ResMenuItem menuItem42 = new ResMenuItem();
        ResMenuItem menuItem50 = new ResMenuItem();
        ResMenuItem menuItem51 = new ResMenuItem();
        if (mb != null) {
            menuItem12.setText(AdvancedBasicApplication.SAVE_ALL_CONTROL_ID);
            menuItem12.setMnemonic(KeyEvent.VK_S);
            menuItem12.setControlId(AdvancedBasicApplication.SAVE_ALL_CONTROL_ID);
            menuItem12.setOwner(this);
            menuItem12.setEnabled(true);
            menuItem12.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
            menuItem12.addActionListener(getActionListener());
            menuItem13.setText(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
            menuItem13.setMnemonic(KeyEvent.VK_C);
            menuItem13.setControlId(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
            menuItem13.setOwner(this);
            menuItem13.setEnabled(true);
            menuItem13.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_J, ActionEvent.CTRL_MASK));
            menuItem13.addActionListener(getActionListener());
            menuItem14.setText(AdvancedBasicApplication.OPEN_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
            menuItem14.setMnemonic(KeyEvent.VK_R);
            menuItem14.setControlId(AdvancedBasicApplication.OPEN_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
            menuItem14.setOwner(this);
            menuItem14.setEnabled(true);
            menuItem14.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
            menuItem14.addActionListener(getActionListener());
            menuItem15.setText(AdvancedBasicApplication.SQUIRREL_START_CONTROL_ID);
            menuItem15.setMnemonic(KeyEvent.VK_Y);
            menuItem15.setControlId(AdvancedBasicApplication.SQUIRREL_START_CONTROL_ID);
            menuItem15.setOwner(this);
            menuItem15.setEnabled(true);
            menuItem15.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y, ActionEvent.CTRL_MASK));
            menuItem15.addActionListener(getActionListener());
            menuItem16.setText(ReForm.PRINT_CONTROL_ID);
            menuItem16.setControlId(ReForm.PRINT_CONTROL_ID);
            menuItem16.setOwner(this);
            menuItem16.setEnabled(true);
            menuItem16.setMnemonic(KeyEvent.VK_P);
            menuItem16.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, ActionEvent.CTRL_MASK));
            menuItem16.addActionListener(getActionListener());
            menuItem17.setText(ReForm.PRINT_SETUP_CONTROL_ID);
            menuItem17.setControlId(ReForm.PRINT_SETUP_CONTROL_ID);
            menuItem17.setOwner(this);
            menuItem17.setEnabled(true);
            menuItem17.setMnemonic(KeyEvent.VK_R);
            menuItem17.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));
            menuItem17.addActionListener(getActionListener());
            menuItem19.setText(ReForm.EXIT_ID);
            menuItem19.setControlId(ReForm.EXIT_ID);
            menuItem19.setOwner(this);
            menuItem19.setEnabled(true);
            menuItem19.setMnemonic(KeyEvent.VK_X);
            menuItem19.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.ALT_MASK));
            menuItem19.addActionListener(getActionListener());
            menu1.setText("File");
            menu1.setMnemonic(KeyEvent.VK_F);
            menu1.add(menuItem12);
            menu1.add(menuItem13);
            menu1.add(menuItem14);
            menu1.add(menuItem15);
            menu1.add(menuItem16);
            menu1.add(menuItem17);
            menu1.add(menuItem19);
            menuItem20.setText(AdvancedBasicApplication.NEW_INDEX_CONTROL_ID);
            menuItem20.setControlId(AdvancedBasicApplication.NEW_INDEX_CONTROL_ID);
            menuItem20.setOwner(this);
            menuItem20.setEnabled(true);
            menuItem20.setMnemonic(KeyEvent.VK_N);
            menuItem20.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
            menuItem20.addActionListener(getActionListener());
            menuItem21.setText(AdvancedBasicApplication.OPEN_INDEX_CONTROL_ID);
            menuItem21.setControlId(AdvancedBasicApplication.OPEN_INDEX_CONTROL_ID);
            menuItem21.setOwner(this);
            menuItem21.setEnabled(true);
            menuItem21.setMnemonic(KeyEvent.VK_O);
            menuItem21.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
            menuItem21.addActionListener(getActionListener());
            menuItem22.setText(AdvancedBasicApplication.SAVE_INDEX_CONTROL_ID);
            menuItem22.setControlId(AdvancedBasicApplication.SAVE_INDEX_CONTROL_ID);
            menuItem22.setOwner(this);
            menuItem22.setEnabled(true);
            menuItem22.setMnemonic(KeyEvent.VK_S);
            menuItem22.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W, ActionEvent.CTRL_MASK));
            menuItem22.addActionListener(getActionListener());
            menuItem23.setText(AdvancedBasicApplication.SAVE_INDEX_AS_CONTROL_ID);
            menuItem23.setControlId(AdvancedBasicApplication.SAVE_INDEX_AS_CONTROL_ID);
            menuItem23.setOwner(this);
            menuItem23.setEnabled(true);
            menuItem23.setMnemonic(KeyEvent.VK_A);
            menuItem23.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.CTRL_MASK));
            menuItem23.addActionListener(getActionListener());
            menu2.setText("Card index");
            menu2.setMnemonic(KeyEvent.VK_C);
            menu2.add(menuItem20);
            menu2.add(menuItem21);
            menu2.add(menuItem22);
            menu2.add(menuItem23);
            menuItem30.setText(ReForm.NEW_HEALTHRECORD_CONTROL_ID);
            menuItem30.setControlId(ReForm.NEW_HEALTHRECORD_CONTROL_ID);
            menuItem30.setOwner(this);
            menuItem30.setEnabled(true);
            menuItem30.setMnemonic(KeyEvent.VK_N);
            menuItem30.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.CTRL_MASK));
            menuItem30.addActionListener(getActionListener());
            menuItem31.setText(ReForm.CHANGE_HEALTHRECORD_DATA_CONTROL_ID);
            menuItem31.setControlId(ReForm.CHANGE_HEALTHRECORD_DATA_CONTROL_ID);
            menuItem31.setOwner(this);
            menuItem31.setEnabled(true);
            menuItem31.setMnemonic(KeyEvent.VK_D);
            menuItem31.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, ActionEvent.CTRL_MASK));
            menuItem31.addActionListener(getActionListener());
            menuItem32.setText(ReForm.CHOOSE_HEALTHRECORD_CONTROL_ID);
            menuItem32.setControlId(ReForm.CHOOSE_HEALTHRECORD_CONTROL_ID);
            menuItem32.setOwner(this);
            menuItem32.setEnabled(true);
            menuItem32.setMnemonic(KeyEvent.VK_C);
            menuItem32.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
            menuItem32.addActionListener(getActionListener());
            menuItem33.setText(ReForm.SAVE_HEALTHRECORD_CONTROL_ID);
            menuItem33.setControlId(ReForm.SAVE_HEALTHRECORD_CONTROL_ID);
            menuItem33.setOwner(this);
            menuItem33.setEnabled(true);
            menuItem33.setMnemonic(KeyEvent.VK_S);
            menuItem33.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, ActionEvent.CTRL_MASK));
            menuItem33.addActionListener(getActionListener());
            menuItem34.setText(ReForm.IMPORT_HEALTHRECORD_CONTROL_ID);
            menuItem34.setControlId(ReForm.IMPORT_HEALTHRECORD_CONTROL_ID);
            menuItem34.setOwner(this);
            menuItem34.setEnabled(true);
            menuItem34.setMnemonic(KeyEvent.VK_I);
            menuItem34.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, ActionEvent.CTRL_MASK));
            menuItem34.addActionListener(getActionListener());
            menuItem35.setText(ReForm.IMPORT_HEALTHRECORD_DIRECTORY_CONTROL_ID);
            menuItem35.setControlId(ReForm.IMPORT_HEALTHRECORD_DIRECTORY_CONTROL_ID);
            menuItem35.setOwner(this);
            menuItem35.setEnabled(true);
            menuItem35.setMnemonic(KeyEvent.VK_Y);
            menuItem35.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, ActionEvent.CTRL_MASK));
            menuItem35.addActionListener(getActionListener());
            menu3.setText("HealthRecord");
            menu3.setMnemonic(KeyEvent.VK_P);
            menu3.add(menuItem30);
            menu3.add(menuItem31);
            menu3.add(menuItem32);
            menu3.add(menuItem33);
            menu3.add(menuItem34);
            menu3.add(menuItem35);
            menuItem40.setText(ReForm.SCRIPT_FORMULAR_CONTROL_ID);
            menuItem40.setControlId(ReForm.SCRIPT_FORMULAR_CONTROL_ID);
            menuItem40.setOwner(this);
            menuItem40.setEnabled(true);
            menuItem40.setMnemonic(KeyEvent.VK_R);
            menuItem40.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
            menuItem40.addActionListener(getActionListener());
            menu4.setText("Formular");
            menu4.setMnemonic(KeyEvent.VK_R);
            menu4.add(menuItem40);
            menu4.add(menuItem41);
            menu4.add(menuItem42);
            menuItem50.setText(ReForm.ABOUT_CONTROL_ID);
            menuItem50.setControlId(ReForm.ABOUT_CONTROL_ID);
            menuItem50.setOwner(this);
            menuItem50.setEnabled(true);
            menuItem50.setMnemonic(KeyEvent.VK_A);
            menuItem50.addActionListener(getActionListener());
            menuItem51.setText(ReForm.HELP_CONTROL_ID);
            menuItem51.setControlId(ReForm.HELP_CONTROL_ID);
            menuItem51.setOwner(this);
            menuItem51.setEnabled(true);
            menuItem51.setMnemonic(KeyEvent.VK_F1);
            menuItem51.addActionListener(getActionListener());
            menu5.setText("Help");
            menu5.setMnemonic(KeyEvent.VK_H);
            menu5.add(menuItem50);
            menu5.add(menuItem51);
            mb.add(menu1);
            mb.add(menu2);
            mb.add(menu3);
            mb.add(menu4);
            mb.add(menu5);
        }
        return mb;
    }

    /**
     * Creates the split pane.
     * @return the split pane
     */
    public ResPanel createPanel() {
        ResPanel rp = new ResPanel();
        try {
            rp.setSize(200, 200);
            //??            getLogger().log(Level.CONFIG, "Set split pane properties.");

/*
			sp.setOrientation(ResSplitPane.VERTICAL_SPLIT);
			sp.setTopComponent(createOverviewPanel());
			sp.setBottomComponent(createContentsPanel());
			sp.setOneTouchExpandable(true);
			sp.setContinuousLayout(true);
			sp.setDividerLocation(200);
*/
        } catch (Exception e) {
            //??            getLogger().log(Level.SEVERE, "Exception", e);
            System.out.println("Error: " + e);
        }
        return rp;
    }

    /**
     * Creates a menu bar.
     * @return the menu bar
     */
    public ResMenuBar createMenuBar() {
        //??        return new MenuBarView(this);
        return null;
    }

    /**
     * Creates a tool bar.
     * @return the tool bar
     */
    public ResToolBar createToolBar() {
        ResToolBar tb = new ResToolBar();
        if (tb != null) {
            tb.setPreferredSize(new Dimension(40, 20));
        }
        return tb;
    }

    public BasicController getActionListener() {
        return (BasicController) getController();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 265;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
}
