/*
 * $RCSfile: ReFormLauncher.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package reform.resmedicinae.reform;

import org.resmedicinae.application.common.main.*;
import org.resmedicinae.resmedlib.component.component.*;

import java.rmi.*;

/**
 * This class launches the Printer application.
 * @version $Revision: 1.1 $ $Date: 2003/03/11 12:53:46 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ReFormLauncher extends Component {
    /*
     * Launches the application.
     *
     * @param args the command line arguments for the application
     */

    public static void main(String[] args) {
        try {
            ApplicationRunner r = new ApplicationRunner();
            if (r != null) {
                r.createApplication("reform.resmedicinae.reform.ReForm", args, null);
            } else {
                throw new NullPointerException("Could not run component. The application runner is null.");
            }
        } catch (Exception e) {
            System.out.println("Could not launch application. Undiscovered exception:\n");
            e.printStackTrace();
        }
    }
}
