/*
 * $RCSfile: AbstractCellEditor.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.treetable;

import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

/**
 * A base class for CellEditors, providing default implementations for all
 * methods in the CellEditor interface and support for managing a series of listeners.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class AbstractCellEditor implements CellEditor {
    public static final String EVENT_LISTENER_LIST = "event_listener_list";

    /** Gets the cell editor value.
     * @return the cell editor value
     * */
    public Object getCellEditorValue() {
        return null;
    }

    /** Test whether the cell is editable. Returns always true.
     * @param e the eventObject
     * @return true
     * */
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    /** Test whether the cell can be selected. Returns always false.
     * @param e the eventObject
     * @return false
     * */
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    /** Test whether the cell editing should be stopped. Returns always true.
     * @return true
     * */
    public boolean stopCellEditing() {
        return true;
    }

    /** Cancels cell editing. Not implemented yet. */
    public void cancelCellEditing() {
    }

    /** Adds a cell editor listener to the listenerList.
     * @param l the cellEditorListener
     * */
    public void addCellEditorListener(CellEditorListener l) {
        listenerList.add(CellEditorListener.class, l);
    }

    /** Removes a cell editor listener from the listenerList.
     * @param l the cellEditorListener
     * */
    public void removeCellEditorListener(CellEditorListener l) {
        listenerList.remove(CellEditorListener.class, l);
    }

    /**
     * Notify all listeners that have registered interest for notification on this event type.
     * @see EventListenerList
     */
    protected void fireEditingStopped() {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == CellEditorListener.class) {
                ((CellEditorListener) listeners[i + 1]).editingStopped(new ChangeEvent(this));
            }
        }
    }

    /**
     * Notify all listeners that have registered interest for notification on this event type.
     * @see EventListenerList
     */
    protected void fireEditingCanceled() {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == CellEditorListener.class) {
                ((CellEditorListener) listeners[i + 1]).editingCanceled(new ChangeEvent(this));
            }
        }
    }
}
