/*
 * $RCSfile: RemoveOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/** View component. Dialog for removing overlays.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class RemoveOverlayDialog extends SwingView {
    /** Layout Manager of this frame */
    private GridBagLayout gridbag;

    /** GridBag constraints of this frame */
    private GridBagConstraints c;
    //labels and textfields

    /** Name label of image */
    private TopologyLabel nameLabel;

    /** Ok Button for confirmation of remove */
    private JButton okButton;

    /** Cancel Button for cancel */
    private JButton cancelButton;

    /** ComboBox for selecting the image to remove */
    public JComboBox nameComboBox;

    /** The model of MVC */
    public final String RECORD_MODEL = "record_model";

    /** Initialization of dialog */
    public void initialize() {
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        c = new GridBagConstraints();
        nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        if (((RecordModel) getModel()).getFileNames() != null) {
            nameComboBox = new JComboBox(((RecordModel) getModel()).getFileNames());
        } else
            nameComboBox = new JComboBox();
        nameComboBox.setToolTipText("Image auswhlen");
        nameComboBox.setPreferredSize(new Dimension(150, 25));
        okButton = new JButton("Ok");
        okButton.addActionListener((Record) getController());
        okButton.setToolTipText("Lschen besttigen");
        okButton.setActionCommand(Record.REMOVE_OVERLAY_DIALOG_OK_ID);
        cancelButton = new JButton("Abbruch");
        cancelButton.addActionListener((Record) getController());
        cancelButton.setToolTipText("Abbruch");
        cancelButton.setActionCommand(Record.REMOVE_OVERLAY_DIALOG_CANCEL_ID);
        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(nameLabel, c);
        add(nameLabel);
        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(nameComboBox, c);
        add(nameComboBox);
        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(cancelButton, c);
        add(cancelButton);
        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridx = 2;
        c.gridy = 1;
        gridbag.setConstraints(okButton, c);
        add(okButton);
    }
}
