/*
 * $RCSfile: PreviewRadioButton.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import javax.swing.*;
import java.awt.event.*;

import cybop.basic.String;

/**This class represents readioButton with special properties.
 * The radioButton controls the selection state itself by getting or losing the focus.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class PreviewRadioButton extends JRadioButton implements FocusListener {
    
    /**Constructor
     * @param text the caption of the button
     * */
    public PreviewRadioButton(String text) {
        super(text);
        addFocusListener(this);
    }

    /**Invoked when the object gained the focus. In this case the radioButton selects itself.*
     * @param evt the focusEvent
     */
    public void focusGained(FocusEvent evt) {
        System.out.println("RadioButton has focus gained");
        this.doClick();
        setSelected(true);
    }

    /**Invoked when the object lost the focus. In this case the radioButton unselects itself.*
     * @param evt the focusEvent
     */
    public void focusLost(FocusEvent evt) {
        setSelected(false);
    }
}
