/*
 * $RCSfile: OverlayTree.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.treetable.TreeIconCellRenderer;
import resmedicinae.record.RecordModel;

import javax.swing.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import java.awt.*;

/**This class reprsents a treeView for overlays.*/
public class OverlayTree extends JTree{
    public static final String OVERLAY_TREE_MODEL = "overlay_tree_model";

    /**Default constructor*/
    public OverlayTree(){
        //setSelectionModel(new DefaultTreeSelectionModel());
        setAlignmentY(JTree.TOP_ALIGNMENT);
        setCellRenderer(new TreeIconCellRenderer());
    }

    /**Constructor
     * @param model the treeModel
     */
    public OverlayTree(OverlayTreeModel model){
        super(model);
    }

    public void setModel(TreeModel model){
        System.out.println("Setting tree model for makeDiseaseDialog: "+model);
        if(model.getClass()!=javax.swing.tree.DefaultTreeModel.class){
            super.setModel(model);
        }
    }
}
