/*
 * $RCSfile: OverlayRegion.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;

import java.awt.*;

/** This class represents a sensible region of an image. Overlays constist of overlay regions. By clicking on those
 * regions a new overlay (corresponding overlay!!!)shows up and will be loaded.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class OverlayRegion extends Polygon {
    /** Indicates whether the overlayRegion is already painted */
    public static final String PAINTED = "painted";
    /** The name of overlayRegion */
    public static final String NAME = "name";
    /** The target of overlayRegion. The name of the overlay.*/
    public static final String TARGET = "target";
    /** The numberc of this overlayRegion within the overlay */
    public static final String NUMBER = "number";
    /** The top neighbour */
    public static final String TOP_NEIGHBOUR = "top_neighbour";
    /** The bottom neighbour */
    public static final String BOTTOM_NEIGHBOUR = "bottom_neighbour";
    /** The right neighbour */
    public static final String RIGHT_NEIGHBOUR = "right_neighbour";
    /** The left neighbour */
    public static final String LEFT_NEIGHBOUR = "left_neighbour";
    /** The model of MVC */
    public static final String RECORD_MODEL = "record_model";

    /** Default constructor */
    public OverlayRegion() {
    }

    /** The constructor. Initializes a overlayRegion with the specific values.
     * @param x array of x coordinates of the regiom
     * @param y array of y coordinates of the regiom
     * @param size number of points
     * */
    public OverlayRegion(int[] x, int[] y, int size) {
        super(x, y, size);
    }    
}
