/*
 * $RCSfile: Overlay.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import org.resmedicinae.resmedlib.Item;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.awt.*;
import cybop.basic.String;

/**This class represents an overlay. An overlay is the OO-representation of an anatomical image and all it properties.
 * Those are name, description, diseases (in reference on this overlay) and the overlay regions.
 * @author Jens Bohl <info@jens-bohl-professional.de>*
 * */

public class Overlay extends Item{
    /**Name of the overlay*/
    public static final String NAME = "name";
    /**Description of the overlay*/
    public static final String DESCRIPTION = "description";
    /**Image of the overlay*/
    public static final String IMAGE = "image";
    /**Hashtable of overlay regions*/
    public static final String OVERLAY_REGION_HASHTABLE = "overlay_region_hashtable";
    /**Vector of alternative overlays*/
    public static final String ALTERNATIVE_OVERLAYS_VECTOR = "alternative_overlays_vector";
    /**Vector of diseases*/
    public static final String DISESASES_HASHTABLE = "diseases_hashtable";
    /**Overlay is alternative or not*/
    public static final Boolean ALTERNATIVE = "alternative";

    /**DefaultConstructor*/
    public Overlay(){
        initialize();
    }

    /**Initialize this object
     * */
    public void initialize(){
        setDiseases(new Hashtable());
        setOverlayRegionHashtable(new Hashtable());
        setAlternativeOverlays(new Vector());
    }

    /**Return the String representation of this overlay
     * @return the string representation (name) of the overlay
     * */
    public String toString(){
        return getName();
    }

    /**Gets all diseases for this overlay
     * @return the diseases of this overlay
     * */
    public Vector getDiseases() {
        Object[] childrenArray = getChildren().values().toArray();
        Vector tempVector = new Vector();
        for (int i = 0; i < childrenArray.length; i++) {
            if (childrenArray[i].getClass().equals(Disease.class)) {
                tempVector.add(childrenArray[i]);
            }
        }
        return tempVector;
    }

    /**Sets all diseases for this overlay
     * @param diseases the diseases of this overlay
     * */
    public void setDiseases(Hashtable diseases) {
        Enumeration keys = diseases.keys();
        while(keys.hasMoreElements()){
            String key = (String)keys.nextElement();
            Disease disease = (Disease)diseases.get(key);
            set(new org.resmedicinae.resmedlib.term.String(key),disease);
        }
    }

    /**Test whether the overlay already has this disease
     * @return true if the overlay has the disease, false if not
     * */
    public boolean hasDisease(String diseaseName){
        return getDiseases().contains(diseaseName);
    }

    /**Adds a disease to an overlay
     * @param disease the disease
     * */
    public void addDisease(Disease disease){
        set(new org.resmedicinae.resmedlib.term.String(disease.getDiseaseName()),disease);
    }
}
