/*
 * $RCSfile: MakeReportOnOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 *This dialog is for creating a report with the help of topological reporting. After pressing F4 this dialog shows up
 * and the user can make e report on the current region.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeReportOnOverlayDialog extends SwingView {
    /** Layout Manager of this dialog */
    public static final String LAYOUT_MANAGER = new String("layout_manager");
    /** Textarea for report */
    public static final String REPORT_TEXTAREA_TEXTAREA = new String("report_text_area");
    /** ScrollPane for the report text area */
    public static final String REPORT_TEXTAREA_TEXTAREA_SCROLLPANE = new String("report_text_area_scrollpane");
    /** Ok button */
    public static final String OK_BUTTON = new String("ok_button");
    /** Cancel button */
    public static final String CANCEL_BUTTON = new String("cancel_button");

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 350;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 400;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /** Initialization of components */
    public void initialize() {
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        setTitle("New objective...");

        setReportTextArea(createReportTextArea());
        setReportTextAreaScrollPane(createReportTextAreaScrollPane());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridbag.setConstraints(getReportTextAreaScrollPane(), c);
        add(getReportTextAreaScrollPane());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());
    }
    

    /**Creates the reportTextArea
     * @return the reportTextArea
     */
    public TopologyTextArea createReportTextArea() {
        return new TopologyTextArea(new Dimension(300, 300));
    }


    /**Creates the reportTextAreaScrollPane
     * @return the reportTextAreaScrollPane
     */
    public TopologyScrollPane createReportTextAreaScrollPane(){
        return new TopologyScrollPane(getReportTextArea(), "Objective");
    }

    

    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton b = new JButton("Ok");
        b.setToolTipText("Create new objective");
        b.addActionListener((Record) getController());
        b.setActionCommand(Record.MAKE_REPORT_ON_OVERLAY_OK_ID);
        return b;
    }


    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton b = new JButton("Cancel");
        b.setToolTipText("Cancel");
        b.addActionListener((Record) getController());
        b.setActionCommand(Record.MAKE_REPORT_ON_OVERLAY_CANCEL_ID);
        return b;
    }

}
