/*
 * $RCSfile: MakeOverlayRegionDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** View Component. This dialog is for creating a new overlayRegion.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *  */
public class MakeOverlayRegionDialog extends SwingView {
    
    /** Layout Manager of this dialog */
    public static final String LAYOUT_MANAGER = new String("layout_manager");
    
    /** Layout constraints of this frame */
    public static final String GRIDBAG_CONSTRAINTS = new String("gridbag_constraints");
    
    /** Name label of this overlay region */
    public static final String OVERLAY_NAME_LABEL = new String("overlay_name_label");
    
    /** Number label of this overlay region */
    public static final String NUMBER_LABEL = new String("number_label");
    
    /** Number text field of this overlay region */
    public static final String NUMBER_TEXT_FIELD = new String("number_text_field");
    
    /** Name text field of this polygon */
    public static final String OVERLAY_NAME_TEXT_FIELD = new String("overlay_name_text_field");
    
    /** Target label of this polygon */
    public static final String OVERLAY_TARGET_LABEL = new String("overlay_target_label");
    
    /** Panel containing a preview of the target of this polygon */
    public static final String PREVIEW_PANEL = new String("preview_panel");
    
    /** Ok button for commitment */
    public static final String OK_BUTTON = new String("ok_button");
    
    /** Cancel button */
    public static final String CANCEL_BUTTON = new String("cancel_button");
    
    /** ComboBox for selecting a target */
    public static final String TARGET_COMBOBOX = new String("target_combobox");
    
    /** Right neighbour label */
    public static final String RIGHT_NEIGHBOUR_LABEL = new String("right_neighbour_label");
    
    /** Right neighbour combobox */
    public static final String RIGHT_NEIGHBOUR_COMBOBOX = new String("right_neighbour_combobox");
    
    /** Right neighbour checkbox */
    public static final String RIGHT_NEIGHBOUR_CHECKBOX = new String("right_neighbour_checkbox");
    
    /** Left neighbour label */
    public static final String LEFT_NEIGHBOUR_LABEL = new String("left_neighbour_label");
    
    /** Left neighbour combobox */
    public static final String LEFT_NEIGHBOUR_COMBOBOX = new String("left_neighbour_combobox");
    
    /** Right neighbour checkbox */
    public static final String RIGHT_NEIGHBOUR_CHECKBOX = new String("right_neighbour_checkbox");
    
    /** Top neighbour label */
    public static final String TOP_NEIGHBOUR_LABEL = new String("top_neighbour_label");
    
    /** Top neighbour combobox */
    public static final String TOP_NEIGHBOUR_COMBOBOX = new String("top_neighbour_combobox");
    
    /** Right neighbour checkbox */
    public static final String TOP_NEIGHBOUR_CHECKBOX = new String("top_neighbour_checkbox");
    
    /** Bottom neighbour label */
    public static final String BOTTOM_NEIGHBOUR_LABEL = new String("bottom_neighbour_label");
    
    /** Bottom neighbour combobox */
    public static final String BOTTOM_NEIGHBOUR_CHECKBOX = new String("bottom_neighbour_checkbox");
    
    /** Right neighbour checkbox */
    public static final String BOTTOM_NEIGHBOUR_COMBOBOX = new String("bottom_neighbour_combobox");
    
    /** The neighbour panel */
    public static final String NEIGHBOUR_PANEL = new String("neighbour_panel");
    
    /** The top neighbour panel */
    public static final String TOP_NEIGHBOUR_PANEL = new String("top_neighbour_panel");
    
    /** The bottom neighbour panel */
    public static final String BOTTOM_NEIGHBOUR_PANEL = new String("bottom_neighbour_panel");
    
    /** The left neighbour panel */
    public static final String LEFT_NEIGHBOUR_PANEL = new String("left_neighbour_panel");
    
    /** The right neighbour panel */
    public static final String RIGHT_NEIGHBOUR_PANEL = new String("right_neighbour_panel");
    
    /** Panel containing name and number of region */
    public static final String NAME_AND_NUMBER_PANEL = new String("region_panel");
    
    /** Panel containing the target of the region */
    public static final String TARGET_PANEL = new String("target_overlay_panel");
    
        
    /**The model of the MVC*/
    public static final String RECORD_MODEL = new String("record_model");
    
    
    
    

    /** Constructor setting location of frame */
    public MakeOverlayRegionDialog() {
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 600;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 600;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /** Initialization of components */
    public void initialize() {
        setTitle("Create new overlay region...");
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();

        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        setGeneralRegionInformationPanel(createGeneralRegionInformationPanel());
        setTargetOverlayPanel(createTargetOverlayPanel());
        setNeighbourPanel(createNeighbourPanel());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());


        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(getGeneralRegionInformationPanel(), c);
        add(getGeneralRegionInformationPanel());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 2;
        gridbag.setConstraints(getTargetOverlayPanel(), c);
        add(getTargetOverlayPanel());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 3;
        gridbag.setConstraints(getNeighbourPanel(), c);
        add(getNeighbourPanel());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 4;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 4;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());
    }

    /**ReInitializes the component. This is needed to reset the properties.*/
    public void reInitialize() {
        RecordModel model = (RecordModel) getModel();
        //first remove all items from all comboboxes
        topNeighbourComboBox.removeAllItems();
        bottomNeighbourComboBox.removeAllItems();
        leftNeighbourComboBox.removeAllItems();
        rightNeighbourComboBox.removeAllItems();
        int currentRegionCount = model.getCurrentOverlayRegionNames().length;
        for (int i = 0; i < currentRegionCount; i++) {
            topNeighbourComboBox.addItem(model.getCurrentOverlayRegionNames()[i]);
            bottomNeighbourComboBox.addItem(model.getCurrentOverlayRegionNames()[i]);
            leftNeighbourComboBox.addItem(model.getCurrentOverlayRegionNames()[i]);
            rightNeighbourComboBox.addItem(model.getCurrentOverlayRegionNames()[i]);
        }
        getOverlayRegionNumberTextField().setText(String.valueOf(currentRegionCount + 1));
    }

    /**Creates the targetImageLabel
     * @return the targetImageLabel
     */
    public TopologyLabel createTargetImageLabel(){
        return new TopologyLabel(false);
    }

     /**Creates the ok button
     * @return the ok button
     */
    public JButton createOkButton(){
        JButton b = new JButton("Ok");
        b.setActionCommand(Record.MAKE_OVERLAY_REGION_DIALOG_OK_ID);
        b.addActionListener((Record) getController());
        b.setToolTipText("Create new region");
        return b;
    }

    /**Creates the overlay region target image combobox
     * @return the overlay region target image combobox
     */
    public JComboBox createTargetImageComboBox(){
        JComboBox targetImageComboBox = new JComboBox();
        if (((RecordModel) getModel()).getFileNames() != null) {
            targetImageComboBox = new JComboBox(((RecordModel) getModel()).getFileNames());
        }
        targetImageComboBox.setToolTipText("Choose image");
        return targetImageComboBox;
    }

    /**Creates the left neighbour label
     * @return the left neighbour label
     */
    public TopologyLabel createRightNeighbourLabel() {
        TopologyLabel l = new TopologyLabel(false);
        l.setText("Right Neighbour");
        return l;
    }

    /**Creates the left neighbour label
     * @return the left neighbour label
     */
    public TopologyLabel createLeftNeighbourLabel() {
        TopologyLabel l = new TopologyLabel(false);
        l.setText("Left Neighbour");
        return l;
    }


    public TopologyLabel createTopNeighbourLabel(){
         TopologyLabel topNeighbourLabel= new TopologyLabel(false);
         topNeighbourLabel.setText("Top Neighbour ");
         return topNeighbourLabel;
    }


    /**Creates the bottom neighbour label
     * @return the bottom neighbour label
     */
    public TopologyLabel createBottomNeighbourLabel(){
        TopologyLabel bottomNeighbourLabel = new TopologyLabel(false);
        bottomNeighbourLabel.setText("Bottom neighbour");
        return bottomNeighbourLabel;
    }

    /**Creates the right neighbour comboBox
     * @return the right neighbour comboBox
     */
    public JComboBox createRightNeighbourComboBox(){
        JComboBox rightNeighbourComboBox = new JComboBox();
        rightNeighbourComboBox.setEnabled(false);
        return rightNeighbourComboBox;
    }

    /**Creates the right neighbour checkBox
     * @return the right neighbour checkBox
     */
    public JCheckBox createRightNeighbourCheckBox(){
        JCheckBox rightNeighbourCheckBox = new JCheckBox();
        rightNeighbourCheckBox.addItemListener((Record) getController());
        return rightNeighbourCheckBox;
    }

     /**Creates the left neighbour comboBox
     * @return the left neighbour comboBox
     */
    public JComboBox createLeftNeighbourComboBox(){
        JComboBox leftNeighbourComboBox = new JComboBox();
        leftNeighbourComboBox.setEnabled(false);
         return leftNeighbourComboBox;
    }

    /**Creates the left neighbour checkBox
     * @return the left neighbour checkBox
     */
    public JCheckBox createLeftNeighbourCheckBox(){
        JCheckBox leftNeighbourCheckBox = new JCheckBox();
        leftNeighbourCheckBox.addItemListener((Record) getController());
        return leftNeighbourCheckBox;
    }

    /**Creates the top neighbour comboBox
     * @return the top neighbour comboBox
     */
    public JComboBox createTopNeighbourComboBox(){
        JComboBox topNeighbourComboBox = new JComboBox();
        topNeighbourComboBox.setMinimumSize(new Dimension(100,50));
        topNeighbourComboBox.setEnabled(false);
        return topNeighbourComboBox;
    }

     /**Creates the top neighbour checkBox
     * @return the top neighbour checkBox
     */
    public JCheckBox createTopNeighbourCheckBox(){
        JCheckBox c = new JCheckBox();
        c.addItemListener((Record) getController());
        return c;
    }


    /**Creates the bottom neighbour comboBox
     * @return the bottom neighbour comboBox
     */
    public JComboBox createBottomNeighbourComboBox(){
        JComboBox c = bottomNeighbourComboBox = new JComboBox();
        c.setEnabled(false);
        return c;
    }

    /**Creates the bottom neighbour checkBox
     * @return the bottom neighbour checkBox
     */
    public JCheckBox createBottomNeighbourCheckBox(){
        JCheckBox bottomNeighbourCheckBox = new JCheckBox();
        bottomNeighbourCheckBox.addItemListener((Record) getController());
        return bottomNeighbourCheckBox;
    }


    /**Creates the neighbour panel.
     * @return the neighbour panel
     */
    public ResPanel createNeighbourPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            p.setBorder(BorderFactory.createTitledBorder("Neighbours"));
            GridBagLayout neighbourPanelLayout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p.setLayout(neighbourPanelLayout);
            setTopNeighbourPanel(createTopNeighbourPanel());
            setBottomNeighbourPanel(createBottomNeighbourPanel());
            setLeftNeighbourPanel(createLeftNeighbourPanel());
            setRightNeighbourPanel(createRightNeighbourPanel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            neighbourPanelLayout.setConstraints(getTopNeighbourPanel(), c);
            p.add(getTopNeighbourPanel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            neighbourPanelLayout.setConstraints(getBottomNeighbourPanel(), c);
            p.add(getBottomNeighbourPanel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 2;
            neighbourPanelLayout.setConstraints(getLeftNeighbourPanel(), c);
            p.add(getLeftNeighbourPanel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 3;
            neighbourPanelLayout.setConstraints(getRightNeighbourPanel(), c);
            p.add(getRightNeighbourPanel());
        } else {
            throw new NullPointerException("Could not create NeighbourPanel. The panel is null");
        }
        return p;
    }

     /**Creates the top neighbour panel
     * @return the top neighbour panel
     */
    public ResPanel createTopNeighbourPanel() {
        BorderLayout f = new BorderLayout();
        ResPanel tnp = new ResPanel();
        tnp.setPreferredSize(new Dimension(550,50));
        tnp.setLayout(f);
        if (tnp != null) {
            tnp.setBorder(BorderFactory.createTitledBorder("Top"));
            setTopNeighbourLabel(createTopNeighbourLabel());
            setTopNeighbourComboBox(createTopNeighbourComboBox());
            setTopNeighbourCheckBox(createTopNeighbourCheckBox());
            tnp.add(getTopNeighbourCheckBox(),BorderLayout.WEST);
            tnp.add(getTopNeighbourLabel(),BorderLayout.CENTER);
            tnp.add(getTopNeighbourComboBox(),BorderLayout.EAST);
        } else {
            throw new NullPointerException("Could not create topNeighbourPanel. The panel is null");
        }
        return tnp;
    }

     /**Creates the bottom neighbour panel
     * @return the bottom neighbour panel
     */
    public ResPanel createBottomNeighbourPanel() {
        BorderLayout f = new BorderLayout();
        ResPanel bnp = new ResPanel();
        bnp.setPreferredSize(new Dimension(550,50));
        bnp.setLayout(f);
        if (bnp != null) {
            bnp.setBorder(BorderFactory.createTitledBorder("Bottom"));
            setBottomNeighbourLabel(createBottomNeighbourLabel());
            setBottomNeighbourComboBox(createBottomNeighbourComboBox());
            setBottomNeighbourCheckBox(createBottomNeighbourCheckBox());
            bnp.add(getBottomNeighbourCheckBox(),BorderLayout.WEST);
            bnp.add(getBottomNeighbourLabel(),BorderLayout.CENTER);
            bnp.add(getBottomNeighbourComboBox(),BorderLayout.EAST);
        } else {
            throw new NullPointerException("Could not create bottomNeighbourPanel. The panel is null");
        }
        return bnp;
    }

    /**Creates the left neighbour panel
     * @return the left neighbour panel
     */
    public ResPanel createLeftNeighbourPanel() {
        BorderLayout f = new BorderLayout();
        ResPanel lnp = new ResPanel();
        lnp.setPreferredSize(new Dimension(550,50));
        lnp.setLayout(f);
        if (lnp != null) {
            lnp.setBorder(BorderFactory.createTitledBorder("Left"));
            setLeftNeighbourLabel(createLeftNeighbourLabel());
            setLeftNeighbourComboBox(createLeftNeighbourComboBox());
            setLeftNeighbourCheckBox(createLeftNeighbourCheckBox());
            lnp.add(getLeftNeighbourCheckBox(),BorderLayout.WEST);
            lnp.add(getLeftNeighbourLabel(),BorderLayout.CENTER);
            lnp.add(getLeftNeighbourComboBox(),BorderLayout.EAST);
        } else {
            throw new NullPointerException("Could not create leftNeighbourPanel. The panel is null");
        }
        return lnp;
    }

    /**Creates the right neighbour panel
     * @return the right neighbour panel
     */
    public ResPanel createRightNeighbourPanel() {
        BorderLayout f = new BorderLayout();
        ResPanel rnp = new ResPanel();
        rnp.setPreferredSize(new Dimension(550,50));
        rnp.setLayout(f);
        if (rnp != null) {
            rnp.setBorder(BorderFactory.createTitledBorder("Right"));
            setRightNeighbourLabel(createRightNeighbourLabel());
            setRightNeighbourComboBox(createRightNeighbourComboBox());
            setRightNeighbourCheckBox(createRightNeighbourCheckBox());
            rnp.add(getRightNeighbourCheckBox(),BorderLayout.WEST);
            rnp.add(getRightNeighbourLabel(),BorderLayout.CENTER);
            rnp.add(getRightNeighbourComboBox(),BorderLayout.EAST);
        } else {
            throw new NullPointerException("Could not create leftNeighbourPanel. The panel is null");
        }
        return rnp;
    }

    /**Creates the generaInformationPanel
     * @return the generalInformationPanel
     */
    public ResPanel createGeneralRegionInformationPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            p.setBorder(BorderFactory.createTitledBorder("General information"));
            GridBagLayout generalRegionInformationLayout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            setOverlayRegionNameLabel(new TopologyLabel(false));
            getOverlayRegionNameLabel().setText("Name");
            setOverlayRegionNameTextField(new JTextField(12));
            getOverlayRegionNameTextField().setEnabled(true);
            getOverlayRegionNameTextField().setPreferredSize(new Dimension(200, 20));
            getOverlayRegionNameTextField().setMinimumSize(new Dimension(200, 20));
            getOverlayRegionNameTextField().setMaximumSize(new Dimension(200, 20));
            setOverlayRegionNumberLabel(new TopologyLabel(false));
            getOverlayRegionNumberLabel().setText("Nr.");
            setOverlayRegionNumberTextField(new JTextField(6));
            getOverlayRegionNumberTextField().setEnabled(false);
            //getOverlayRegionNumberTextField().setPreferredSize(new Dimension(30, 20));
            c.anchor = GridBagConstraints.WEST;
            c.fill = GridBagConstraints.HORIZONTAL;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            generalRegionInformationLayout.setConstraints(getOverlayRegionNameLabel(), c);
            p.add(getOverlayRegionNameLabel());
            c.anchor = GridBagConstraints.EAST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.ipady = 30;
            c.gridx = 0;
            c.gridy = 1;
            generalRegionInformationLayout.setConstraints(getOverlayRegionNameTextField(), c);
            p.add(getOverlayRegionNameTextField());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 0;
            generalRegionInformationLayout.setConstraints(getOverlayRegionNumberLabel(), c);
            p.add(getOverlayRegionNumberLabel());
            c.anchor = GridBagConstraints.EAST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 1;
            generalRegionInformationLayout.setConstraints(getOverlayRegionNumberTextField(), c);
            p.add(getOverlayRegionNumberTextField());
        }
        return p;
    }

    /**Creates the targetOverlayPanel
     * @return the targetOverlayPanel
     */
    public ResPanel createTargetOverlayPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            p.setBorder(BorderFactory.createTitledBorder("Target Overlay"));
            GridBagLayout targetLayout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            setTargetImageLabel(createTargetImageLabel());
            getTargetImageLabel().setText("Name");
            getTargetImageLabel().setMinimumSize(new Dimension(100, 50));
            getTargetImageLabel().setPreferredSize(new Dimension(80, 50));
            if (((RecordModel) getModel()).getFileNames() != null) {
                setTargetImageComboBox(new JComboBox(((RecordModel) getModel()).getFileNames()));
            } else
                setTargetImageComboBox(new JComboBox());
            getTargetImageComboBox().setToolTipText("Target image auswhlen");
            getTargetImageComboBox().addActionListener((Record) getController());
            getTargetImageComboBox().setActionCommand(Record.MAKE_OVERLAY_REGION_DIALOG_CHANGE_PREVIEW_ID);
            setTargetPreviewPanel(createTargetPreviewPanel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            targetLayout.setConstraints(getTargetImageLabel(), c);
            p.add(getTargetImageLabel());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            targetLayout.setConstraints(getTargetImageComboBox(), c);
            p.add(getTargetImageComboBox());
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(2, 2, 2, 2);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 2;
            targetLayout.setConstraints(getTargetPreviewPanel(), c);
            p.add(getTargetPreviewPanel());
        }
        return p;
    }

    /**Creates the targetPreviewPanel
     * @return the targetPreviewPanel
     */
    public PreviewPanel createTargetPreviewPanel() {
        PreviewPanel p = new PreviewPanel(new Dimension(100, 100));
        if (p != null) {
            p.initialize();
        } else {
            throw new NullPointerException("Could not create PreviewPanel for MakeOverlayRegionDialog. The panel is null");
        }
        return p;
    }

    /**Creates the cancelButton
     * @returm the cancelButton
     * */
    public JButton createCancelButton(){
        JButton b = new JButton("Cancel");
        b.setActionCommand(Record.MAKE_OVERLAY_REGION_DIALOG_CANCEL_ID);
        b.addActionListener((Record) getController());
        b.setToolTipText("Cancel");
        return b;
    }
}
