/*
 * $RCSfile: MakeOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.ImageIcon;
import javax.swing.*;
import java.awt.*;

/**
 *View Component. Dialog for creating a new overlay. The user can choose an image file such as JPG or GIF
 * and give a name and decription to the overlay.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeOverlayDialog extends SwingView {
    
    /** Layout Manager of this dialog */    
    public static final String LAYOUT_MANAGER = new String("layout_manager");
    
    /** Name label of this overlay */
    public static final String OVERLAY_NAME_LABEL = new String("overlay_name_label");
    
    /** Name textField of this overlay */
    public static final String OVERLAY_NAME_TEXT_FIELD = new String("overlay_name_text_field");
    
    /** Name label of picture (JPG or GIF) to choose */
    public static final String PICTURE_NAME_LABEL = new String("picture_name_label");
    
    /** Name text field showing the name of choosed picture */
    public static final String PICTURE_NAME_TEXT_FIELD = new String("picture_name_text_field");
    
    /** Ok button for commitment */
    public static final String OK_BUTTON = new String("ok_button");
    
    /** Cancel button for cancelation */
    public static final String CANCEL_BUTTON = new String("cancel_button");
    
    /** Button for choosing files. A file chooser appears after clicking this button.*/
    public static final String CHOOSE_FILE_BUTTON = new String("choose_file_button");
    
    /** Textarea to give a description to the image. */
    public static final String IMAGE_DESCRIPTION_TEXT_AREA = new String("image_description_text_area");
    
    /** Directory where icons are at */
    public static final String ICON_DIRECTORY_NAME = new String("icon_directory_name");
    
    /** Icon for chooseFileButton */
    public static final String OPEN_ICON = new String("open_icon");
    
    /**Scrollpane for description textArea*/
    public static final String DESCRIPTION_TEXT_AREA_SCOLLPANE = new String("description_text_area_scrollpane");
    
    
    
    
    /**Default Constructor */
    public MakeOverlayDialog() {
    }

    /** Initialization of components */
    public void initialize() {
        setTitle("Create overlay...");
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        setLocation(500, 350);

        setNameLabel(createNameLabel());
        setNameTextField(createNameTextField());
        setPictureNameLabel(createPictureNameLabel());
        setPictureNameTextField(createPictureNameTextField());
        setDescriptionTextArea(createDescriptionTextArea());
        setDescriptionTextAreaScrollPane(createDescriptionTextAreaScrollPane());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());
        setChooseFileButton(createChooseFileButton());


        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridbag.setConstraints(getNameLabel(), c);
        add(getNameLabel());

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 3;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(nameTextField, c);
        add(getNameTextField());

        c.anchor = GridBagConstraints.EAST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(getPictureNameLabel(), c);
        add(getPictureNameLabel());

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(getPictureNameTextField(), c);
        add(getPictureNameTextField());

        c.gridx = 2;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getChooseFileButton(), c);
        add(getChooseFileButton());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.anchor = GridBagConstraints.WEST;
        gridbag.setConstraints(getDescriptionTextAreaScrollPane(), c);
        add(getDescriptionTextAreaScrollPane());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 1;
        c.gridwidth = 2;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());


    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 360;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 300;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }


    /**Creates the name label
     * @return the name label
     * */
    public TopologyLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }


    /**Creates the textField
     * @return the textField
     * */
    public JTextField createNameTextField(){
        JTextField nameTextField = new JTextField(15);
        nameTextField.setEditable(true);
        nameTextField.setEnabled(true);
        return nameTextField;
    }
    

    /**Creates the pictureNameLabel
     * @return the pictureNameLabel
     * */
    public TopologyLabel createPictureNameLabel(){
        TopologyLabel pictureNameLabel = new TopologyLabel(false);
        pictureNameLabel.setText("Dateiname");
        return pictureNameLabel;
    }


    /**Creates the pictureNameTextField
     * @return the pictureNameTextField
     * */
    public JTextField createPictureNameTextField(){
        JTextField pictureNameTextField = new JTextField(15);
        pictureNameTextField.setEditable(false);
        return pictureNameTextField;
    }
    

    /**Creates the okButton
     * @return the okButton
     * */
    public JButton createOkButton(){
        JButton okButton = new JButton("Ok");
        okButton.addActionListener((Record) getController());
        okButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_OK_ID);
        okButton.setToolTipText("Create new overlay");
        return okButton;
    }


    /**Creates the cancelButton
     * @return the cancelButton
     * */
    public JButton createCancelButton(){
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener((Record) getController());
        cancelButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_CANCEL_ID);
        cancelButton.setToolTipText("Cancel");
        return cancelButton;
    }

    /**Creates the chooseFileButton
     * @return the chooseFileButton
     * */
    public JButton createChooseFileButton(){
        ImageIcon openIcon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "open.gif");
        JButton chooseFileButton = new JButton(openIcon);
        chooseFileButton.addActionListener((Record) getController());
        chooseFileButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_CHOOSE_FILE_ID);
        chooseFileButton.setToolTipText("Choose image");
        return chooseFileButton;
    }
    

    /**Creates the descriptionTextArea
     * @return the descriptionTextArea
     * */
    public TopologyTextArea createDescriptionTextArea(){
        return new TopologyTextArea(new Dimension(280, 150));
    }


    /**Creates the descriptionTextAreaScrollPane
     * @return the descriptionTextAreaScrollPane
     * */
    public TopologyScrollPane createDescriptionTextAreaScrollPane(){
        return new TopologyScrollPane(getDescriptionTextArea(), "Description");
    }

}
