/*
 * Created by IntelliJ IDEA.
 * User: Jens Bohl
 * Date: 03.12.2002
 * Time: 20:50:42
 * To change template for new class use 
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package resmedicinae.record.topology;

import org.resmedicinae.resmedlib.component.view.swing.SwingView;
import org.resmedicinae.resmedlib.component.view.swing.DisplayFactory;
import org.resmedicinae.resmedlib.component.control.Control;
import org.resmedicinae.resmedlib.component.control.Controller;
import resmedicinae.record.RecordModel;
import resmedicinae.record.Record;

import javax.swing.*;
import javax.swing.event.TreeSelectionListener;
import java.awt.*;

import cybop.basic.String;

/**
 * This class represents dialog that can be used for creating new diseases as well as for editing and removing
 * diseases and overlays.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeDiseaseDialog extends SwingView {
    
    /** The Layout Manager */    
    public static final String LAYOUT_MANAGER = new String("layout_manager");
    
    /** GridBagConstraints that are used */
    public static final String GRID_BAG_CONSTRAINTS = new String("grid_bag_constraints");
    
    /**Name label of diseaseNameTextField*/
    public static final String DISEASE_NAME_LABEL = new String("name_label");
    
    /**TextField for the name of the disease*/
    public static final String DISEASE_NAME_TEXT_FIELD = new String("name_text_field");
    
    /** TextArea for the description of the disease*/
    public static final String DISEASE_DESCRIPTION_TEXT_AREA = new String("disease_description_text_area");
    
    /**The Model of the MVC*/
    public static final String RECORD_MODEL = "record_model";
    
    /**A treeview for displaying overlays and correspoding diseases*/
    public static final String OVERLAY_TREE = new String("overlay_tree");
    
    /**Ok Button. Clicking this button creates a new disease and hides the dialog.*/
    public static final String OK_BUTTON = new String("ok_button");
    
    /**Cancel Button. Clicking this button hides the dialog.*/    
    public static final String CANCEL_BUTTON = new String("cancel_button");
    
    /**Remove Button. Clicking this button removes a diesease or an overlay.*/
    public static final String REMOVE_BUTTON = new String("remove_button");
    
    /**Commit Button. Clicking this button saves modified properties such as names and description of overlays an
     * diseases.*/    
    public static final String COMMIT_BUTTON = new String("commit_button");
    
    /**Clear Button. Clears the textArea and textField of the dialog.*/    
    public static final String CLEAR_BUTTON = new String("clear_button");
    
    /**ScrollPane for diseaseTextArea*/    
    public static final String DISEASE_SCROLLPANE = new String("disease_scrollpane");
    
    /**ScrollPane for overlayTree*/    
    public static final String OVERLAY_TREE_SCROLLPANE = new String("overlay_tree_scrollpane");


    /**Default constructor*/
    public MakeDiseaseDialog() {
    }

    /** Initialization of components */
    public void initialize() {
        setTitle(new String("Create/Edit disease..."));
        set(MakeDiseaseDialog.LAYOUT_MANAGER, new GridBagLayout());
        setLayout((GridBagLayout)get(MakeDiseaseDialog.LAYOUT_MANAGER));
        set(MakeDiseaseDialog.GRID_BAG_CONSTRAINTS, new GridBagConstraints());
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());

        set(MakeDiseaseDialog.DISEASE_NAME_LABEL, createNameLabel());
        set(MakeDiseaseDialog.DISEASE_NAME_TEXT_FIELD,createDiseaseNameTextField());
        set(MakeDiseaseDialog.OK_BUTTON, createOkButton());
        set(MakeDiseaseDialog.DISEASE_SCROLLPANE, createDiseaseScrollPane());
        set(MakeDiseaseDialog.OVERLAY_TREE_SCROLLPANE, createOverlayTreeScrollPane());

        GridBagConstraints c = (GridBagConstraints)get(MakeDiseaseDialog.GRID_BAG_CONSTRAINTS);
        GridBagLayout gridbag = (GridBagLayout)get(MakeDiseaseDialog.LAYOUT_MANAGER);

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(getNameLabel(), c);
        add(getNameLabel());

        c.anchor = GridBagConstraints.CENTER;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 5;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(diseaseNameTextField, c);
        add(getDiseaseNameTextField());

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 6;
        c.ipady = 150;
        c.ipady = 150;
        c.ipadx = 100;
        gridbag.setConstraints(getDiseaseScrollPane(), c);
        add(getDiseaseScrollPane());

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 6;
        c.ipady = 150;
        c.ipadx = 100;
        gridbag.setConstraints(getOverlayTreeScrollPane(), c);
        add(getOverlayTreeScrollPane());

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.ipady = 5;
        c.ipadx = 5;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        setClearButton(createClearButton());
        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 4;
        c.gridy = 3;
        gridbag.setConstraints(getClearButton(), c);
        add(getClearButton());

        setCancelButton(createCancelButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 5;
        c.gridy = 3;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());

        setRemoveButton(createRemoveButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 3;
        c.gridy = 3;
        gridbag.setConstraints(getRemoveButton(), c);
        add(getRemoveButton());

        setCommitButton(createCommitButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 1;
        c.gridy = 3;
        gridbag.setConstraints(getCommitButton(), c);
        add(getCommitButton());
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 390;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Creates the diseaseTextField
     * @return the diseaseTextField
     */
    public JTextField createDiseaseNameTextField(){
        JTextField diseaseNameTextField = new JTextField(100);
        //diseaseNameTextField.setEditable(false);
        //diseaseNameTextField.setEnabled(false);
        diseaseNameTextField.addActionListener((Record) getController());
        return diseaseNameTextField;
    }

    /**Creates the nameLabel
     * @return the nameLabeld
     */
    public JLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }


    /**Creates the diseaseDescriptionTextArea
     * @return the diseaseDescriptionTextArea
     */
    public TopologyTextArea createDiseaseDescriptionTextArea(){
        TopologyTextArea dieseaseDescriptionTextArea = new TopologyTextArea(new Dimension(380, 200));
        //dieseaseDescriptionTextArea.setEnabled(false);
        //dieseaseDescriptionTextArea.setEditable(false);
        return dieseaseDescriptionTextArea;
    }

    /**Creates the overlayTree
     * @return the overlayTree
     */
    public OverlayTree createOverlayTree(){
                
        OverlayTree overlayTree = new OverlayTree();
        
        overlayTree.addTreeSelectionListener((TreeSelectionListener)getController());
        
        return overlayTree;
    }

    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton okBtn = new JButton("New");
        okBtn.addActionListener((Record) getController());
        okBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_OK_ID);
        return okBtn;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setToolTipText("Cancel");
        cancelBtn.addActionListener((Record) getController());
        cancelBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_CANCEL_ID);
        return cancelBtn;
    }


    /**Creates the removeButton
     * @return the removeButton
     */
    public JButton createRemoveButton(){
        JButton removeBtn = new JButton("Remove");
        removeBtn.setEnabled(false);
        removeBtn.setToolTipText("Remove disease");
        removeBtn.addActionListener((Record) getController());
        removeBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_REMOVE_DISEASE_ID);
        return removeBtn;
    }

    /**Creates the commitButton
     * @return the commitButton
     */
    public JButton createCommitButton(){
        JButton commitBtn = new JButton("Commit");
        commitBtn.setEnabled(false);
        commitBtn.setToolTipText("Commit changes");
        commitBtn.addActionListener((Record) getController());
        commitBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_COMMIT_CHANGES_IN_DISEASE_ID);
        return commitBtn;
    }


    /**Creates the clearButton
     * @return the clearButton
     */
    public JButton createClearButton(){
        JButton clearBtn = new JButton("Clear");
        clearBtn.setToolTipText("Clear textfields");
        clearBtn.addActionListener((Record) getController());
        clearBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_CLEAR_ID);
        return clearBtn;
    }


    public TopologyScrollPane createDiseaseScrollPane(){
        setDiseaseDescriptionTextArea(createDiseaseDescriptionTextArea());
        return new TopologyScrollPane(getDiseaseDescriptionTextArea(), "Description");
    }


    /**Creates the overlayTreeScrollPane
     * @return the overlayTreeScrollPane
     */
    public JScrollPane createOverlayTreeScrollPane(){
        setOverlayTree(createOverlayTree());
        JScrollPane overlayTreeScrollPane = new JScrollPane(getOverlayTree());
        overlayTreeScrollPane.setPreferredSize(new Dimension(380,180));
        overlayTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        overlayTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        return overlayTreeScrollPane;
    }

}
