/*
 * $RCSfile: MakeCAVEDialog.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

import cybop.basic.String;

/** View Component. This frame is for creating a new CAVE entry. A mask appears where all properties can be filled in.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *  */
public class MakeCAVEDialog extends SwingView {
    /**The cave name label.*/
    public static final String CAVE_NAME_LABEL = new String("cave_name_label");
    /**The cave name tectfield.*/
    public static final String CAVE_NAME_TEXT_FIELD = new String("cave_name_text_field");
    /**The cave description label.*/
    public static final String CAVE_DESCRIPTION_LABEL = new String("cave_description_label");
    /**The cave description textarea.*/
    public static final String CAVE_DESCRIPTION_TEXT_AREA = new String("cave_description_text_area");
    /**The cancel button.*/
    public static final String CANCEL_BUTTON = new String("cancel_button");
    /**The ok button.*/
    public static final String OK_BUTTON = new String("ok_button");
     /**The clear button.*/
    public static final String CLEAR_BUTTON = new String("clear_button");

    /**Default constructor.*/
    public MakeCAVEDialog() {
    }

    /**Initializes the component.*/
    public void initialize() {
        setTitle(new String("New CAVE! entry..."));
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gridBag);

        set(MakeCAVEDialog.CAVE_NAME_LABEL, createNameLabel());
        set(MakeCAVEDialog.CAVE_NAME_TEXT_FIELD, createCaveNameTextField());

        set(MakeCAVEDialog.CAVE_DESCRIPTION_TEXT_AREA, createCaveDescriptionTextArea());
        TopologyScrollPane caveDescriptionScrollPane = new TopologyScrollPane((JTextArea)get(MakeCAVEDialog.CAVE_DESCRIPTION_TEXT_AREA), "Description");

        set(MakeCAVEDialog.OK_BUTTON, createOkButton());
        set(MakeCAVEDialog.CANCEL_BUTTON, createCancelButton());
        set(MakeCAVEDialog.CLEAR_BUTTON, createClearButton());

        c.anchor = GridBagConstraints.WEST;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(0,7,0,0);
        c.gridx = 0;
        c.gridy = 0;
        gridBag.setConstraints((JLabel)get(MakeCAVEDialog.CAVE_NAME_LABEL), c);
        add((JLabel)get(MakeCAVEDialog.CAVE_NAME_LABEL));

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,0,0,0);
        c.gridx = 1;
        c.gridy = 0;
        gridBag.setConstraints((JTextField)get(MakeCAVEDialog.CAVE_NAME_TEXT_FIELD), c);
        add((JTextField)get(MakeCAVEDialog.CAVE_NAME_TEXT_FIELD));

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        gridBag.setConstraints(caveDescriptionScrollPane, c);
        add(caveDescriptionScrollPane);

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        gridBag.setConstraints((JButton)get(MakeCAVEDialog.OK_BUTTON), c);
        add((JButton)get(MakeCAVEDialog.OK_BUTTON));

        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 1;
        c.gridy = 3;
        gridBag.setConstraints((JButton)get(MakeCAVEDialog.CLEAR_BUTTON), c);
        add((JButton)get(MakeCAVEDialog.CLEAR_BUTTON));

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 2;
        c.gridy = 3;
        gridBag.setConstraints((JButton)get(MakeCAVEDialog.CANCEL_BUTTON), c);
        add((JButton)get(MakeCAVEDialog.CANCEL_BUTTON));
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 320;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Creates the caveDescriptionTextArea
     * @return the caveDescriptionTextArea
     */
    public TopologyTextArea createCaveDescriptionTextArea(){
        TopologyTextArea caveDescriptionTextArea = new TopologyTextArea(new Dimension(250, 240));
        return caveDescriptionTextArea;
    }


    /**Creates the caveNameLabel
     * @return the caveNameLabel
     */
    public TopologyLabel createNameLabel(){
        TopologyLabel caveNameLabel = new TopologyLabel(false);
        caveNameLabel.setText("Cave!");
        return caveNameLabel;
    }


    /**Creates the caveNameTextField
     * @return the caveNameTextField
     */
    public JTextField createCaveNameTextField(){
        JTextField caveNameTextField = new JTextField(15);
        return caveNameTextField;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener((Record) getController());
        cancelButton.setActionCommand(Record.MAKE_CAVE_DIALOG_CANCEL_ID);
        return cancelButton;
    }


    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton okButton = new JButton("Ok");
        okButton.setActionCommand(Record.MAKE_CAVE_DIALOG_OK_ID);
        okButton.addActionListener((Record) getController());
        return okButton;
    }


    /**Creates the clearButton
     * @return the clearButton
     * */
    public JButton createClearButton(){
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener((Record) getController());
        clearBtn.setActionCommand(Record.MAKE_CAVE_DIALOG_CLEAR_ID);
        return clearBtn;
    }

}
