/*
 * $RCSfile: LoadPatientFrameTableModel.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import javax.swing.table.*;
import java.util.*;

/** Model class of loadPatientDialogTable. This model represents the data of the table.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class LoadPatientFrameTableModel extends AbstractTableModel {
    
    /** The column names. */
    public static final String COLUMN_NAME_ARRAY = new String("column_name_array");
    /** Vector ontaining the whole data of rows and columns. */
    public static final String DATA_VECTOR = new String("data_vector");
    /** Gets number of columns
     * @return the column number
     * */
    public int getColumnCount() {
        return columnNames.length;
    }

    /** Gets number of rows
     * @return the row number
     * */
    public int getRowCount() {
        if (get(LoadPatientFrameTableModel.DATA_VECTOR) == null) {
            return 0;
        } else {
            return ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).size();
        }
    }

    /** Gets column name
     * @param col the number of the column
     * @return the name of the column
     * */
    public String getColumnName(int col) {
        return getColumnNames()[col];
    }

    /** Gets value of a particular cell
     * @param row the row index
     * @param col the column index
     * @return the object at the particular cell with index (row, col)
     * */
    public Object getValueAt(int row, int col) {
        Vector colum = ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).elementAt(row);
        return colum.elementAt(col);
    }

    /** Gets class of a column
     * @param c the column
     * @return the class of the column
     * */
    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    /** Tests wether a cell is editable or not
     * @param row the row index
     * @param col the column index
     * @return true, if the cell is editable, false if not
     * */
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    /** Sets the value of a particular cell.
     * @param row the row index
     * @param col the column index
     * @param value the value of the cell
     * */
    public void setValueAt(Object value, int row, int col) {
        Vector zeile = (Vector)(get(LoadPatientFrameTableModel.DATA_VECTOR)).elementAt(row);
        zeile.setElementAt(value, col);
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).setElementAt(zeile, row);
        //fireTableCellUpdated(row, col);
    }

    /** Sets a new row in table
     *  @param row the new row
     * */
    public void setNewLine(Vector row) {
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).add(row);
        fireTableStructureChanged();
    }

    /** Updates a new row of table at a particular index
     * @param row the new row
     * @param rownumber the number of row
     * */
    public void updateLine(Vector row, int rowNumber) {
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).setElementAt(row, rowNumber);
        fireTableStructureChanged();
    }

    /** Removes a line from table
     * @param zeilenNr row to remove
     * */
    public void removeLine(int zeilenNr) {
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).removeElementAt(zeilenNr);
        fireTableStructureChanged();
    }

    /**Fill the table with ehr information
     *@param ehrIndex the ehr
     */
    public void fillTableWithEHRIndex(Vector ehrIndex) {
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).clear();
        for (int i = 0; i < ehrIndex.size(); i++) {
            ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).add(ehrIndex.elementAt(i));
        }
        fireTableStructureChanged();
    }

    /** Clears all table cells */
    public void clearTable() {
        ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).clear();
        fireTableStructureChanged();
    }

    /** Gets row with number i
     * @param i the index of the row
     * @return the row as a vector
     * */
    public Vector getRow(int i) {
        return ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).elementAt(i);
    }

    /** Sets number of rows in table
     *  @param rowCount the number of rows
     * */
    public void setRowCount(int rowCount) {
        set(LoadPatientFrameTableModel.DATA_VECTOR, new Vector(rowCount));
        Vector emptyVector = new Vector();
        emptyVector.add(new String());
        emptyVector.add(new String());
        emptyVector.add(new String());
        for (int i = 0; i < rowCount; i++) {
            ((Vector)get(LoadPatientFrameTableModel.DATA_VECTOR)).add(emptyVector);
        }
    }
    
    /**Gets all column names
     * @return all column names in an array
     */
    public String[] getColumnNames() {
        return columnNames;
    }
}
