/*
 * $RCSfile: LoadPatientDialog.java,v $
 *
 * Copyright (c) 1999-2003. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
//??import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.table.TableModel;
import java.awt.*;
import java.util.*;

import cybop.basic.String;

/**
 * This class represents a load patient dialog.
 * @version $Revision: 1.3 $ $Date: 2003/02/27 14:26:52 $ $Author: tristan24 $
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class LoadPatientDialog extends SwingView {

    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final java.lang.String SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Select";
    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final java.lang.String REMOVE_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Remove";
    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final java.lang.String DESTROY_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Close";

    /** Layout Manager of this dialog.*/
    public static final String LAYOUT_MANAGER = new String("layout_manager");
    
    /** Name label of patient */
    public static final String NAME_LABEL = new String("name_label");
    
    /** Name textField of patient */
    public static final String NAME_TEXT_FIELD = new String("name_text_field");
    
    /** Caption suggested name */
    public static final String SUGGESTED_NAMES_LABEL = new String("suggested_names_label");
    
    /** Select button for commitment */    
    public static final String COMMIT_BUTTON = new String("commit_button");
    
    /** Close button for removining a health record */
    public static final String REMOVE_BUTTON = new String("remove_button");
    
    /** Close button for hiding the dialog */
    public static final String CLOSE_BUTTON = new String("close_button");
    
    /** Possible names table */
    public static final String POSSIBLE_NAMES_TABLE = new String("possible_names_table");
    
    /** The model of the possible names table */
    public static final String LOAD_PATIENT_DIALOG_TABLE_MODEL = new String("load_patient_dialog_table_model");
    
    /** The listSelectionmodel of the possible names table */
    public static final String LIST_SELECTION_MODEL = new String("list_selection_model");
    
    /** Vector containing table column names */
    public static final String COLUMN_NAMES_VECTOR = new String("column_names_vector");

    /** Gridbag Constraints*/
    public static final String GRIDBAG_CONSTRAINTS = new String("grid_bag_constraints");

    /** Table Model*/
    public static final String TABLE_MODEL = new String("table_model");

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 320;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Initializes this component. */
    public void initialize() throws Exception {
        super.initialize();
        setTitle(new String("Load patient..."));
        //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
        setDialogBounds(createDialogBounds());

        //setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        set(LoadPatientDialog.LAYOUT_MANAGER, new GridBagLayout());
        GridBagLayout gridbag = (GridBagLayout)get(LoadPatientDialog.LAYOUT_MANAGER);
        setLayout(gridbag);
        
        GridBagConstraints c = (GridBagConstraints)get(LoadPatientDialog.GRIDBAG_CONSTRAINTS);
        
        set(LoadPatientDialog.COLUMN_NAMES_VECTOR, createColumNames());
        set(LoadPatientDialog.TABLE_MODEL, createTableModel());
        set(LoadPatientDialog.NAME_LABEL, createNameLabel());
        set(LoadPatientDialog.NAME_TEXT_FIELD, createNameTextField());
        set(LoadPatientDialog.SUGGESTED_NAMES_LABEL, createSuggestedLabel());

        set(LoadPatientDialog.POSSIBLE_NAMES_TABLE, createPossibleNamesTable());
        TopologyScrollPane scrollPane = new TopologyScrollPane((JTable)get(LoadPatientDialog.POSSIBLE_NAMES_TABLE), "Suggestions");
        set(LoadPatientDialog.COMMIT_BUTTON, createSelectButton());
        set(LoadPatientDialog.REMOVE_BUTTON, createRemoveButton());
        set(LoadPatientDialog.CLOSE_BUTTON, createCloseButton());


        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,7,0,0);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints((JLabel)get(LoadPatientDialog.SUGGESTED_NAMES_LABEL), c);
        add((JLabel)get(LoadPatientDialog.SUGGESTED_NAMES_LABEL));

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,0,0,0);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints((JTextField)get(LoadPatientDialog.NAME_TEXT_FIELD), c);
        add((JTextField)get(LoadPatientDialog.NAME_TEXT_FIELD));

        c.anchor = GridBagConstraints.CENTER;
        c.ipady = 190;
        c.ipadx = 20;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        gridbag.setConstraints(scrollPane, c);
        add(scrollPane);

        c.gridwidth = 1;
        c.ipady = 0;

        c.gridx = 0;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints((JTextField)get(LoadPatientDialog.COMMIT_BUTTON), c);
        add((JButton)get(LoadPatientDialog.COMMIT_BUTTON));

        c.gridx = 1;
        c.gridy = 3;
        c.anchor = GridBagConstraints.CENTER;
        gridbag.setConstraints((JButton)get(LoadPatientDialog.REMOVE_BUTTON), c);
        add((JButton)get(LoadPatientDialog.REMOVE_BUTTON));

        c.gridx = 2;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints((JButton)get(LoadPatientDialog.CLOSE_BUTTON), c);
        add((JButton)get(LoadPatientDialog.CLOSE_BUTTON));
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Creates the name label.
     * @return the nameLabel
     * */
    public TopologyLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }


    /**Creates the name textfield.
     * @return the nameTextField
     * */
    public JTextField createNameTextField(){
        JTextField nameTextField = new JTextField(15);
        nameTextField.setEditable(true);
        nameTextField.setEnabled(true);
        nameTextField.getDocument().addDocumentListener((AdvancedBasicApplication) getController());
        nameTextField.addActionListener((AdvancedBasicApplication) getController());
        nameTextField.setActionCommand(LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        return nameTextField;
    }



    /**Creates the suggested label.
     * @return the suggestedLabel
     * */
    public TopologyLabel createSuggestedLabel(){
        TopologyLabel l = new TopologyLabel(false);
        l.setText("Name:");
        return l;
    }


    /**Creates the possibleNamesTable.
     * @return the possibleNamesTable
     * */
    public JTable createPossibleNamesTable(){
        JTable possibleNamesTable = new JTable((TableModel)get(LoadPatientDialog.TABLE_MODEL));
        possibleNamesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        possibleNamesTable.setPreferredSize(new Dimension(295, 250));
        possibleNamesTable.addMouseListener((AdvancedBasicApplication) getController());
        possibleNamesTable.getColumnModel().getSelectionModel().addListSelectionListener((AdvancedBasicApplication) getController());
        possibleNamesTable.setEnabled(false);
        return possibleNamesTable;
    }

    /**Creates the loadPatientFrameTableModel
     * @return the loadPatientFrameTableModel
     * */
    public LoadPatientFrameTableModel createTableModel(){
        LoadPatientFrameTableModel l = new LoadPatientFrameTableModel();
        return l;
    }

    /**Creates the listSelectionModel
     * @return the listSelectionModel
     * */
    public ListSelectionModel createListSelectionModel(){
        return new DefaultListSelectionModel();
    }


    /**Creates the column Names
     * @return the column Names
     * */
    public Vector createColumNames(){
        Vector columNames = new Vector();
        columNames.add("Id");
        columNames.add("Vorname");
        columNames.add("Name");
        return columNames;
    }


    /**Creates the selectButton
     * @return the selectButton
     * */
    public JButton createSelectButton(){
        JButton selectButton = new JButton("Load");
        selectButton.addActionListener((AdvancedBasicApplication) getController());
        selectButton.setActionCommand(LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        selectButton.setToolTipText("Select focused health record globaly");
        return selectButton;
    }


    /**Creates the removeButton
     * @return the removeButton
     * */
    public JButton createRemoveButton(){
        JButton removeButton = new JButton("Remove");
        removeButton.addActionListener((AdvancedBasicApplication) getController());
        removeButton.setActionCommand(LoadPatientDialog.REMOVE_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        removeButton.setToolTipText("Remove focused health record");
        return removeButton;
    }


    /**Creates the closeButton
     * @return the closeButton
     * */
    public JButton createCloseButton(){
        JButton closeButton = new JButton("Cancel");
        closeButton.addActionListener((AdvancedBasicApplication) getController());
        closeButton.setActionCommand(LoadPatientDialog.DESTROY_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        closeButton.setToolTipText("Close this dialog");
        return closeButton;
    }


}
