/*
 * $RCSfile: EditOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

import cybop.basic.String;

/** View Component. This dialog is for editing overlays. This means e.g. drawing new polygons in these overlays.
 * From this dialog the state of working can be managed. The system can be in working mode (normally) or in
 * overlayRegion drawing mode or in overlayRegion editing mode.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *  */
public class EditOverlayDialog extends SwingView {
    
    /** Button for showing a painted polygon */
    public static final String SHOW_OVERLAY_REGION_BUTTON = new String("show_overlay_region_button");
    
    /** Button for deleting a polygon that is only showed on the image */
    public static final String DELETE_OVERLAY_REGION_BUTTON = new String("delete_overlay_region_button");
    
    /** Button for saving a new polygon, the createOverlayRegionFrame is showed */
    public static final String SAVE_OVERLAY_REGION_BUTTON = new String("save_overlay_region_button");
    
    /** Button for deleting the last point drawn on the image panel */
    public static final String DELETE_LAST_POINT_BUTTON = new String("delete_point_button");
    
    /** Radiobutton for changing into the polygon edit modus */
    public static final String CHANGE_TO_POLYGON_EDIT_MODE_BUTTON = new String("change_to_polgygon_edit_mode");
        
    /** Radiobutton for changing into the point painting modus */
    public static final String CHANGE_TO_POLYGON_POINT_PAINTING_MODE_BUTTON = new String("change_to_point_painting_mode");
    
    /** Radiobutton for changing into the working modus */
    public static final String CHANGE_TO_WORKING_MODE_BUTTON = new String("change_to_working_mode");
    
    /** Panel consisting of buttons */
    public static final String BUTTON_PANEL = new String("button_panel");
    
    /** The model of MVC */
    public static final String RECORD_MODEL = new String("record_model");
    
    /** CombobBox for switching between images */
    public static final String FILE_CHOOSE_CHOMBOBOX = new String("file_choose_combobox");
    
    /** If this CheckBox is selected all existing polygons for the current image are shown */
    public static final String SHOW_OVERLAY_REGIONS_CHECKBOX = new String("show_overlay_regions_checkbox");
        
    /**The x position of the dialog. An Integer.*/    
    public static final String DIALOG_X_POSITION = new String("dialog_x_position");
    
    /**The y position of the dialog. An Integer.*/    
    public static final String DIALOG_Y_POSITION = new String("dialog_y_position");
    
    public EditOverlayDialog() {
    }

    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 180;
        if (w > screenWidth) {
            w = screenWidth;
        }
        int x = ((Integer)get(EditOverlayDialog.DIALOG_X_POSITION)).intValue();
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 250;
        if (h > screenHeight) {
            h = screenHeight;
        }
        int y = ((Integer)get(EditOverlayDialog.DIALOG_Y_POSITION)).intValue();
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /** Initialization of components */
    public void initialize() {
        //initialize the button panel, containing buttons, one checkbox and one combobox
        setLayout(new BorderLayout());
        
        set(EditOverlayDialog.DIALOG_X_POSITION,new Integer(100));
        set(EditOverlayDialog.DIALOG_Y_POSITION,new Integer(400));

        GridLayout gridLayout = new GridLayout(4, 1);
        ((JPanel)get(EditOverlayDialog.BUTTON_PANEL)).setLayout(gridLayout);
        gridLayout.setVgap(10);
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        
        //initialize all buttons in the button panel
                        

        GridLayout radioButtonLayout = new GridLayout(1,4);
        radioButtonLayout.setVgap(2);
        JPanel radioButtonPanel = new JPanel(radioButtonLayout);
        radioButtonPanel.add((JRadioButton)get(EditOverlayDialog.CHANGE_TO_POLYGON_EDIT_MODE_BUTTON));
        radioButtonPanel.add((JRadioButton)get(EditOverlayDialog.CHANGE_TO_POLYGON_POINT_PAINTING_MODE_BUTTON));
        radioButtonPanel.add((JRadioButton)get(EditOverlayDialog.CHANGE_TO_WORKING_MODE_BUTTON));
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Mode"));

        add((JPanel)get(EditOverlayDialog.BUTTON_PANEL),BorderLayout.NORTH);
        add(radioButtonPanel,BorderLayout.CENTER);
        add((JCheckBox)get(EditOverlayDialog.SHOW_OVERLAY_REGIONS_CHECKBOX),BorderLayout.SOUTH);
        
    }
    
    public JButton createShowOverlayRegionButton(){    
        JButton showOverlayRegionButton = new JButton("Preview");
        showOverlayRegionButton.addActionListener((Record) getController());
        showOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_NEW_POLYGON_ID);
        showOverlayRegionButton.setEnabled(false);
        showOverlayRegionButton.setToolTipText("Shows preview of the overlay region");
        return showOverlayRegionButton;
    }
    
    public JButton createDeleteOverlayRegionButton(){
        JButton deleteOverlayRegionButton = new JButton("Remove");
        deleteOverlayRegionButton.addActionListener((Record) getController());
        deleteOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_DELETE_POLYGON_ID);
        deleteOverlayRegionButton.setEnabled(false);
        deleteOverlayRegionButton.setToolTipText("Remove overlay region preview");
        return deleteOverlayRegionButton;
    }
    
    public JButton createSaveOverlayRegionButton(){
        JButton saveOverlayRegionButton = new JButton("Save");
        saveOverlayRegionButton.addActionListener((Record) getController());
        saveOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_SAVE_POLYGON_ID);
        saveOverlayRegionButton.setEnabled(false);
        saveOverlayRegionButton.setToolTipText("Save overlay region");
        return saveOverlayRegionButton;
    }
    
    public JButton createDeleteLastPointButton(){
        JButton deleteLastPointButton = new JButton("Remove last point");
        deleteLastPointButton.addActionListener((Record) getController());
        deleteLastPointButton.setActionCommand(Record.EDIT_OVERLAY_DELETE_LAST_POINT_ID);
        deleteLastPointButton.setEnabled(false);
        deleteLastPointButton.setToolTipText("remove last point of overlay region");
        return deleteLastPointButton;
    }
    
    public JRadioButton createEditOverlayRegionRadioButton(){
        JRadioButton editOverlayRegionRadioButton = new JRadioButton("Edit");
        editOverlayRegionRadioButton.setEnabled(true);
        editOverlayRegionRadioButton.setToolTipText("edit overlay region");
        return editOverlayRegionRadioButton;
    }
    
    public JRadioButton createPaintPointsRadioButton(){
        JRadioButton paintPointsRadioButton = new JRadioButton("Points");
        paintPointsRadioButton.setEnabled(true);
        paintPointsRadioButton.setToolTipText("draw points");
        return paintPointsRadioButton;
    }
    
    public JRadioButton createWorkingRadioButton(){
        JRadioButton workingRadioButton = new JRadioButton("Work");
        workingRadioButton.setEnabled(true);
        workingRadioButton.setToolTipText("sets working mode");
        workingRadioButton.setSelected(true);
        return workingRadioButton;
    }
    
    public JComboBox createFileChooseComboBox(){
        JComboBox fileChooseCombobox = new JComboBox();
        if (((RecordModel) getModel()).getFileNames() != null) {
            fileChooseCombobox = new JComboBox(((RecordModel) getModel()).getFileNames());
        } else{
            fileChooseCombobox = new JComboBox();
        }
        fileChooseCombobox.addActionListener((Record) getController());
        fileChooseCombobox.setActionCommand(Record.EDIT_OVERLAY_CHOOSE_FILE_ID);
        fileChooseCombobox.setToolTipText("Image Auswahl");
    }
    
    public JCheckBox createShowOverlayRegionsCheckBox(){
        JCheckBox showOverlayRegionsCheckBox = new JCheckBox("Show all overlay regions");
        showOverlayRegionsCheckBox.addItemListener((Record) getController());
        return showOverlayRegionsCheckBox;
    }
    
    public JPanel createButtonPanel(){
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((JButton)get(EditOverlayDialog.SHOW_OVERLAY_REGION_BUTTON));
        buttonPanel.add((JButton)get(EditOverlayDialog.DELETE_OVERLAY_REGION_BUTTON));
        buttonPanel.add((JButton)get(EditOverlayDialog.SAVE_OVERLAY_REGION_BUTTON));
        buttonPanel.add((JButton)get(EditOverlayDialog.DELETE_LAST_POINT_BUTTON));
        
        buttonPanel.add((JButton)get(EditOverlayDialog.CHANGE_TO_POLYGON_EDIT_MODE_BUTTON));
        buttonPanel.add((JButton)get(EditOverlayDialog.CHANGE_TO_POLYGON_POINT_PAINTING_MODE_BUTTON));
        buttonPanel.add((JButton)get(EditOverlayDialog.CHANGE_TO_WORKING_MODE_BUTTON));
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Overlay Regions"));
        
        return buttonPanel;
    }


}
