/*
 * $RCSfile: EditAlternativeOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record.topology;

import resmedicinae.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.tree.DefaultTreeModel;
import java.awt.*;

import cybop.basic.String;

/**View component. With the help of this dialog editing of alternative overlays can be done.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class EditAlternativeOverlayDialog extends SwingView {
    /** List containing all overlays */
    public static final String ALL_OVERLAY_LIST = new String("all_overlay_list");

    /** Listmodel for allOverlaysList */
    public static final String ALL_OVERLAY_LISTMODEL = new String("all_overlay_listmodel");

    /** List containing all alternative overlays */
    public static final String ALTERNATIVE_OVERLAY_LIST = new String("alternative_overlay_list");

    /** Listmodel for alternativeOverlaysList */
    public static final String ALTERNATIVE_OVERLAY_LISTMODEL = new String("alternative_overlay_listmodel");
    
    /** Scrollpane for all overlay list*/
    public static final String ALL_OVERLAYS_LIST_SCROLLPANE = new String("all_overlays_tree_scrollpane");

    /** Add button */
    public static final String ADD_BUTTON = new String("add_button");

    /** Ok button */
    public static final String OK_BUTTON = new String("ok_button");

    /** Cancel button */
    public static final String CANCEL_BUTTON = new String("cancel_button");

    /** Remove button */
    public static final String REMOVE_BUTTON = new String("remove_button");

    /** The layout manager */
    public static final String LAYOUT_MANAGER = new String("layout_manager");

    /** The constraints of the dialog */
    public static final String GRIDBAG_CONSTRAINTS = new String("gridbag_constraints");
    
    /** The controller */
    public static final String CONTROLLER = new String("controller");


    /**The scrollPane of the alternative overlays list
     *
     */
    public static final String ALTERNATIVE_OVERLAY_LIST_SCROLLPANE = new String("alternative_overlay_list_scrollpane");

    public EditAlternativeOverlayDialog() {
    }

    public void initialize() {
        set(EditAlternativeOverlayDialog.LAYOUT_MANAGER,new GridBagLayout());
        set(EditAlternativeOverlayDialog.GRIDBAG_CONSTRAINTS,new GridBagConstraints());

        //local variables
        GridBagLayout gridBag = (GridBagLayout)get(EditAlternativeOverlayDialog.LAYOUT_MANAGER);        
        GridBagConstraints c = (GridBagConstraints)get(EditAlternativeOverlayDialog.GRIDBAG_CONSTRAINTS);        
        
        //setting the layout manager
        setLayout(gridBag);
        
        //setting the title
        setTitle(new String("Edit alternative overlays..."));
        
        addKeyListener((Record) get(EditAlternativeOverlayDialog.CONTROLLER));
        //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
        setDialogBounds(createDialogBounds());
        
        //setting all GUI widgets
        set(EditAlternativeOverlayDialog.ALL_OVERLAY_LIST, createAllOverlaysList());
        set(EditAlternativeOverlayDialog.ALTERNATIVE_OVERLAY_LIST, createAternativeOverlaysList());
        set(EditAlternativeOverlayDialog.OK_BUTTON, createOkButton());
        set(EditAlternativeOverlayDialog.ADD_BUTTON, createAddButton());
        set(EditAlternativeOverlayDialog.REMOVE_BUTTON, createRemoveButton());
        set(EditAlternativeOverlayDialog.CANCEL_BUTTON, createCancelButton());      
        set(EditAlternativeOverlayDialog.ALL_OVERLAYS_LIST_SCROLLPANE, createAllOverlaysListScrollPane());
        set(EditAlternativeOverlayDialog.ALTERNATIVE_OVERLAY_LIST_SCROLLPANE, createAlternativeOverlaysListScrollPane());
        
        //placing widgets in container
        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridBag.setConstraints((JScrollPane)get(EditAlternativeOverlayDialog.ALL_OVERLAYS_LIST_SCROLLPANE),c);
        add((JScrollPane)get(EditAlternativeOverlayDialog.ALL_OVERLAYS_LIST_SCROLLPANE));

        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        gridBag.setConstraints((JButton)get(EditAlternativeOverlayDialog.ADD_BUTTON),c);
        add((JButton)get(EditAlternativeOverlayDialog.ADD_BUTTON));                

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 2;
        c.gridx = 2;
        c.gridy = 0;
        gridBag.setConstraints((JScrollPane)get(EditAlternativeOverlayDialog.ALL_OVERLAYS_LIST_SCROLLPANE),c);
        add((JScrollPane)get(EditAlternativeOverlayDialog.ALL_OVERLAYS_LIST_SCROLLPANE));

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 2;
        gridBag.setConstraints((JButton)get(EditAlternativeOverlayDialog.OK_BUTTON),c);
        add((JButton)get(EditAlternativeOverlayDialog.OK_BUTTON));

        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 2;
        gridBag.setConstraints((JButton)get(EditAlternativeOverlayDialog.REMOVE_BUTTON),c);
        add((JButton)get(EditAlternativeOverlayDialog.REMOVE_BUTTON));

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 2;
        gridBag.setConstraints((JButton)get(EditAlternativeOverlayDialog.CANCEL_BUTTON),c);
        add((JButton)get(EditAlternativeOverlayDialog.CANCEL_BUTTON));

    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 650;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 300;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    public JList createAllOverlaysList() {
        RecordModel model = (RecordModel) getModel();
        JList l = new JList();
        if (l != null) {
            //l.setVisibleRowCount(500);
            set(EditAlternativeOverlayDialog.ALL_OVERLAY_LISTMODEL,(new DefaultListModel()));
            //getAllOverlaysListModel().ensureCapacity(50);
            l.setModel((DefaultListModel)get(EditAlternativeOverlayDialog.ALL_OVERLAY_LISTMODEL));
            //l.setPreferredSize(new Dimension(250, 200));
        } else {
            throw new NullPointerException("Could not create all overlays list. The list is null.");
        }
        return l;
    }


    public JList createAternativeOverlaysList() {
        JList l = new JList();
        if (l != null) {
            set(EditAlternativeOverlayDialog.ALTERNATIVE_OVERLAY_LISTMODEL, (new DefaultListModel());
            l.setModel((DefaultListModel)get(EditAlternativeOverlayDialog.ALTERNATIVE_OVERLAY_LISTMODEL));
            l.setPreferredSize(new Dimension(250, 200));
        } else {
            throw new NullPointerException("Could not create alternative overlays list. The list is null.");
        }
        return l;
    }


    public JButton createAddButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText(">>");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_ADD_ID);
        } else {
            throw new NullPointerException("Could not create cancel button. The button is null.");
        }
        return b;
    }


    public JButton createOkButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Ok");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_OK_ID);
        } else {
            throw new NullPointerException("Could not create ok button. The button is null.");
        }
        return b;
    }    

    public JButton createCancelButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Cancel");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_CANCEL_ID);
        } else {
            throw new NullPointerException("Could not create cancel button. The button is null.");
        }
        return b;
    }
    

    public JButton createRemoveButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Remove");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_REMOVE_ID);
        } else {
            throw new NullPointerException("Could not create remove button. The button is null.");
        }
        return b;
    }
    
    public JScrollPane createAlternativeOverlaysListScrollPane(){
        JList list = (JList)get(EditAlternativeOverlayDialog.ALTERNATIVE_OVERLAY_LIST);
        JScrollPane altOverlaysTreeScrollPane = new JScrollPane(list);
        altOverlaysTreeScrollPane.setBorder(BorderFactory.createTitledBorder("Alternative Overlays"));
        altOverlaysTreeScrollPane.setPreferredSize(new Dimension(250, 200));
        altOverlaysTreeScrollPane.setPreferredSize(new Dimension(250, 200));
        altOverlaysTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        altOverlaysTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        altOverlaysTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        altOverlaysTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        return altOverlaysTreeScrollPane;
    }
    
    public JScrollPane createAllOverlaysListScrollPane(){
        JScrollPane allOverlaysTreeScrollPane = new JScrollPane((JList)get(EditAlternativeOverlayDialog.ALL_OVERLAY_LIST));
        allOverlaysTreeScrollPane.setBorder(BorderFactory.createTitledBorder("All Overlays"));                
        return allOverlaysTreeScrollPane;
    }
    
       
}
