/*
 * $RCSfile: Disease.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
 
package resmedicinae.record.topology;

import org.resmedicinae.domain.healthcare.Heading;
import cybop.basic.String;

/**This class represents a disease. A disease can be use for documentation of objectives with the help of the
 * topological part of Record.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class Disease extends Heading{
    
    /**The Name of the disease. Has to be unique because no primary key is used. */    
    public static final String DISEASE_NAME = new String("disease_name");   
    /**The Description of the disease.*/    
    public static final String DISEASE_DESCRIPTION = new String("disease_description");

    /**String representation of the disease: the disease name (is needed for presentation of the disease in the
     * overlay treeTable.
     * @return the name of the disease
     */
    public String toString(){
        return (String)get(Disease.DISEASE_NAME);
    }
}
