/*
 * $RCSfile: RecordView.java,v $
 *
 * Copyright (c) 1999-2003. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record;

import com.jrefinery.chart.*;
import com.jrefinery.data.*;
import resmedicinae.record.topology.*;
import resmedicinae.record.treetable.*;
//??import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.TreeSelectionListener;
import javax.swing.border.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class represents the Record view.
 * @version $Revision: 1.2 $ $Date: 2003/02/19 16:03:21 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class RecordView extends SwingView {
    //
    // Attributes.
    //

    /** The split pane. */
    public static final String SPLIT_PANE = "spit_pane";

    /** Button for moving one step back to the last image */
    public static final String HISTORY_BACK_BUTTON = "history_back_button";

    /** Label showing the status */
    public static final String STATUS_LABEL = "status_label";

    /** name label, static */
    public static final String OVERLAY_REGION_NAME_LABEL = "overlay_region_name_label";

    /** Label showing dynmamically the name of the overlayRegion the mouse is over */
    public static final String OVERLAY_REGION_NAME_ENTRY_LABEL = "overlay_region_name_entry_label";

    /** target label, static */
    public static final String OVERLAY_REGION_TARGET_LABEL = "overlay_region_target_label";

    /** Label showing dynmamically the target of the overlayRegion the mouse is over */
    public static final String OVERLAY_REGION_TARGET_ENTRY_LABEL = "overlay_region_target_entry_label";

    /** Panel showing the topology chart */
    public static final String TOPOLOGY_CHART = "topology_chart";

    /** Panel displaying the currentImage */
    public static final String IMAGE_PANEL = "image_panel";
    
    /** Panel showing patient information*/
    public static final String PATIENT_INFO_PANEL = "patient_info_panel";
    
    /** Panel showing overlay region information*/
    public static final String REGION_INFO_PANEL = "region_info_panel";
    
    /** Checkbox for grabbing the focus.*/
    public static final String GRAB_FOCUS_CHECKBOX = "grab_focus_checkbox";
    
    /**Text area for reporting*/
    public static final String REPORT_TEXT_AREA = "report_text_area";
    
    /**Panel containing information about the overlay region*/
    public static final String OVERLAY_REGION_INFO_PANEL = "overlay_region_info_panel";
    
    /**Panel showing a preview of the overlay region*/
    public static final String PREVIEW_PANEL = "preview_panel";
    
    /**Panel containing the treetable*/
    public static final String TREE_TABLE_PANEL = "tree_table_panel";

    /** The menu bar */
    public static final String MENU_BAR = "menu_bar";

    /** Menu for system operations */
    public static final String SYSTEMS_MENU = "systems_menu";

    /** Menu item for exit */
    public static final String EXIT_MENU_ITEM = "exit_menu_item";

    /** Menu for dealing with patients */
    public static final String PATIENT_MENU = "patient_menu";

    /** Menu item for creating an new patient. */
    public static final String NEW_PATIENT_MENU_ITEM = "new_patient_menu_item";

    /** Menu item for loading an existing patient */
    public static final String LOAD_PATIENT_MENU_ITEM = "load_patient_menu_item";

    /** Menu item for saving the current ehr */
    public static final String SAVE_PATIENT_MENU_ITEM = "save_patient_menu_item";

    /** Menu item for creating a new CAVE entry */
    public static final String NEW_CAVE_ENTRY_MENU_ITEM = "new_cave_entry_menu_item";

    /** Menu item for removing a new CAVE entry */
    public static final String REMOVE_CAVE_ENTRY_MENU_ITEM = "remove_cave_entry_menu_item";

    /** Menu for handling image action e.g. creating or deleting an image */
    public static final String IMAGE_MENU = "image_menu";

    /** Menu item for creating a new image. */
    public static final String NEW_IMAGE_MENU_ITEM = "new_image_menu_item";

    /** Menu item for deleting an image. */
    public static final String DEL_IMAGE_MENU_ITEM = "del_image_menu_item";

    /** Menu item for editing an image. */
    public static final String EDIT_IMAGE_MENU_ITEM = "edit_image_menu_item";

    /** Menu item for editing alternative overlays. */
    public static final String EDIT_ALTERNATIVE_MENU_ITEM = "edit_alternative_menu_item";

    /** Menu item for showing alternative overlays. */
    public static final String SHOW_ALTERNATIVE_MENU_ITEM = "show_alternative_menu_item";

    /**Menu for managing diseases*/
    public static final String DISEASE_MENU = "disease_menu";

    /** Menu item for creating an new disease */
    public static final String NEW_DISEASE_MENU_ITEM = "new_disease_menu_item";

    /** Menu for markers */
    public static final String MARKERS_MENU = "markers_menu";

    /** Menu item for saving markers. */
    public static final String SAVE_MARKERS_MENU_ITEM = "save_markers_menu_item";

    /** Menu for dealing with settings */
    public static final String SETTINGS_MENU = "settings_menu";

    /** Menu item for changing overlayRegion settings. */
    public static final String OVERLAY_REGIONS_SETTINGS_MENU_ITEM = "overlay_regions_settings_menu_item";

    /** Menu item for changing into not filled overlayRegion drawing. */
    public static final String NOT_FILLED_RADIO_BUTTON_MENU_ITEM = "not_filled_radio_button_menu_item";

    /** Menu item for changing into red filled overlayRegion drawing. */
    public static final String FILLED_RADIO_BUTTON_MENU_ITEM = "filled_radio_button_menu_item";

    /** Menu item for changing into alpha red filled overlayRegion drawing. */
    public static final String ALPHA_FILLED_RADIO_BUTTON_MENU_ITEM = "alpha_filled_radio_button_menu_item";

    /** Menu item for changing communication. */
    public static final String COMMUNICATION_SELECTION_MENU_ITEM = "communication_selection_menu_item";

    /** Menu item for changing patientInfoPanel settings. */
    public static final String PATIENT_INFO_PANEL_SETTINGS_MENU_ITEM = "patient_info_panel_settings_menu_item";
    
    /** Menu for dealing with episodes */
    public static final String EPISODES_MENU = "episodes_menu";

    /** Menu item for creating a new episode. */
    public static final String NEW_EPISODE_MENU_ITEM = "new_episode_menu_item";

    /** Menu item for deleting an episode. */
    public static final String DEL_EPISODE_MENU_ITEM = "del_episode_menu_item";

    /** Menu for dealing with problems */
    public static final String PROBLEMS_MENU = "problems_menu";

    /** Menu item for creating a new problem. */
    public static final String NEW_PROBLEM_MENU_ITEM = "new_problem_menu_item";

    /** Menu item for deleting a problem. */
    public static final String DEL_PROBLEM_MENU_ITEM = "del_problem_menu_item";
    

    /** Menu for help */
    public static final String HELP_MENU = "help_menu";

    /** Menu item for monitoring and changing the keyboard configuration.. */
    public static final String KEYBOARD_SETTINGS_MENU_ITEM = "keyboard-settings_menu_item";

    /** Menu item for showing the manual. */
    public static final String HELP_MANUAL_MENU_ITEM = "help_manual_menu_item";

    /** A toolbar. */
    public static final String TOOL_BAR = "tool_bar";

        
    /*Text area with information about the current image. This means
    *for example the latin description of the region shown in the image.
    */
    public static final String IMAGE_INFO_TEXT_AREA = "image_info_text_area";
    
    /**The model of the tree table*/
    public static final String OBJECT_MODEL = "object_model";

    /** Panel containing a textArea for showing status and hints */
    public static final String STATUS_AND_INFORMATION_PANEL = "status_and_information_panel";

    /*Label for presenting status and hints*/

    public static final String STATUS_AND_INFORMATION_LABEL = "status_and_information_label";

    /** Panel for containing the report */
    public static final String MONITOR_REPORT_PANEL = "monitor_report_panel";

    /** Checkbox for showing markers or not */
    public static final String SHOW_MARKERS_CHECKBOX = "show_markers_checkbox";

    /** Panel containing buttons for managing overlays */
    public static final String MANAGE_PANEL = "manage_panel";

    /** Button for changing to start overlay */
    public static final String BACK_TO_START_OVERLAY_BUTTON = "back_to_start_overlay_button";

    /** Button for changing to alternative overlays */
    public static final String ALTERNATIVE_OVERLAY_BUTTON = "alternative_overlay_button";

    /** Button for saving markers */
    public static final String SAVE_MARKERS_BUTTON = "save_markers_button";

    /** Button for deleting markers */
    public static final String REMOVE_ALL_MARKERS_BUTTON = "remove_all_markers_button";

    /** Marker label */
    public static final String MARKER_LABEL = "marker_label";

    /** Overlay label */
    public static final String OVERLAY_LABEL = "overlay_label";

    /** Control label */
    public static final String CONTROL_LABEL = "control_label";

    /** An empty label */
    public static final String EMPTY_LABEL = "empty_label";

    /** An object label */
    public static final String OBJECTIVE_LABEL = "objective_label";

    /** Button for changing the current objective */
    public static final String CHANGE_CURRENT_OBJECTIVE_BUTTON = "change_current_objective_button";

    /** Button for removing the current objective */
    public static final String REMOVE_CURRENT_OBJECTIVE_BUTTON = "remove_current_objective_button";

    /**Tree for displaying overlays in hierarchical order*/
    public static final String OVERLAY_TREE = "overlay_tree";

    /**Tree model for overlay tree*/
    public static final String OVERLAY_TREE_MODEL = "overlay_tree_model";



    //
    // Menu bar.
    //

    /**
     * Returns the menu bar. ??Todo: Replace return type with ResMenuBar
     * @return the menu bar
     */
    public ResMenuBar createMenuBar() {
        ResMenuBar mb = new ResMenuBar();
        systemMenu = new JMenu("System");
        mb.add(systemMenu);
        communicationSelectorMenuItem = new ResMenuItem();
        communicationSelectorMenuItem.setText(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
        communicationSelectorMenuItem.setMnemonic(KeyEvent.VK_C);
        communicationSelectorMenuItem.setControlId(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
        communicationSelectorMenuItem.setOwner(this);
        communicationSelectorMenuItem.setEnabled(true);
        communicationSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_J, ActionEvent.CTRL_MASK));
        communicationSelectorMenuItem.addActionListener((Record) getController());
        systemMenu.add(communicationSelectorMenuItem);
        exit = new JMenuItem("Exit");
        exit.addActionListener((Record) getController());
        exit.setActionCommand(Record.SYSTEM_EXIT_ID);
        systemMenu.add(exit);
        //initializing the Patient menu
        patientMenu = new JMenu("Patient");
        mb.add(patientMenu);
        newPatient = new JMenuItem("New Patient...");
        newPatient.addActionListener((Record) getController());
        newPatient.setActionCommand(AdvancedBasicApplication.NEW_HEALTHRECORD_CONTROL_ID);
        newPatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3, 0));
        loadPatient = new JMenuItem("Load patient...");
        loadPatient.addActionListener((Record) getController());
        loadPatient.setActionCommand(AdvancedBasicApplication.OPEN_INDEX_CONTROL_ID);
        loadPatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
        savePatient = new JMenuItem("Save patient");
        savePatient.addActionListener((Record) getController());
        savePatient.setActionCommand(AdvancedBasicApplication.SAVE_HEALTHRECORD_CONTROL_ID);
        savePatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F6, 0));
        newCAVEEntry = new JMenuItem("New CAVE!-Entry...");
        newCAVEEntry.addActionListener((Record) getController());
        newCAVEEntry.setActionCommand(Record.NEW_CAVE_ENTRY_ID);
        removeCAVEEntry = new JMenuItem("Remove CAVE!-Entry");
        removeCAVEEntry.addActionListener((Record) getController());
        removeCAVEEntry.setActionCommand(Record.REMOVE_CAVE_ENTRY_ID);
        patientMenu.add(newPatient);
        patientMenu.add(loadPatient);
        patientMenu.add(savePatient);
        patientMenu.addSeparator();
        patientMenu.add(newCAVEEntry);
        patientMenu.add(removeCAVEEntry);
        //initializing the Problems menu
        problemsMenu = new JMenu("Problem");
        mb.add(problemsMenu);
        newProblem = new JMenuItem("New problem...");
        newProblem.setEnabled(false);
        newProblem.addActionListener((Record) getController());
        newProblem.setActionCommand(Record.NEW_PROBLEM_ID);
        problemsMenu.add(newProblem);
        delProblem = new JMenuItem("Remove problem");
        setDelProblem(delProblem);
        delProblem.setEnabled(false);
        delProblem.addActionListener((Record) getController());
        delProblem.setActionCommand(Record.REMOVE_PROBLEM_ID);
        problemsMenu.add(delProblem);
        diseaseMenu = new JMenu("Disease");
        newDisease = new JMenuItem("New disease");
        newDisease.addActionListener((Record) getController());
        newDisease.setActionCommand(Record.NEW_DISEASE_ID);
        //mb.add(diseaseMenu);
        //mb.add(windowsMenu);

        diseaseMenu.add(newDisease);
        //initializing the Episodes menu
        episodesMenu = new JMenu("Episode");
        mb.add(episodesMenu);
        newEpisode = new JMenuItem("New Objective...");
        newEpisode.setEnabled(true);
        newEpisode.addActionListener((Record) getController());
        newEpisode.setActionCommand(Record.NEW_REPORT_ID);
        newEpisode.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, 0));
        episodesMenu.add(newEpisode);
        delEpisode = new JMenuItem("Remove episode");
        delEpisode.setEnabled(false);
        delEpisode.addActionListener((Record) getController());
        delEpisode.setActionCommand(Record.REMOVE_EPISODE_ID);
        episodesMenu.add(delEpisode);
        //initializing the Image menu
        imageMenu = new JMenu("Overlay");
        mb.add(imageMenu);
        newImage = new JMenuItem("New overlay...");
        newImage.addActionListener((Record) getController());
        newImage.setActionCommand(Record.NEW_FILE_ID);
        delImage = new JMenuItem("Remove overlay...");
        delImage.addActionListener((Record) getController());
        delImage.setActionCommand(Record.DEL_FILE_ID);
        editImage = new JMenuItem("Edit overlay regions...");
        editImage.addActionListener((Record) getController());
        editImage.setActionCommand(Record.EDIT_FILE_ID);
        editAlternativeOverlay = new JMenuItem("Edit alternative overlays...");
        editAlternativeOverlay.addActionListener((Record) getController());
        editAlternativeOverlay.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAYS_ID);
        showAlternativeOverlay = new JMenuItem("Show alternative overlays...");
        showAlternativeOverlay.addActionListener((Record) getController());
        showAlternativeOverlay.setActionCommand(Record.SHOW_ALTERNATIVE_OVERLAY_ID);
        showAlternativeOverlay.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0));
        newDisease = new JMenuItem("Edit diseases...");
        newDisease.addActionListener((Record) getController());
        newDisease.setActionCommand(Record.NEW_DISEASE_ID);
        //mb.add(diseaseMenu);
        //mb.add(windowsMenu);

        imageMenu.add(newImage);
        imageMenu.addSeparator();
        imageMenu.add(editImage);
        imageMenu.addSeparator();
        imageMenu.add(editAlternativeOverlay);
        imageMenu.add(showAlternativeOverlay);
        imageMenu.addSeparator();
        imageMenu.add(newDisease);
        //initializing the Marker menu
        markerMenu = new JMenu("Marker");
        mb.add(markerMenu);
        saveMarkers = new JMenuItem("Save markers");
        markerMenu.add(saveMarkers);
        saveMarkers.addActionListener((Record) getController());
        saveMarkers.setActionCommand(Record.SAVE_MARKER_ID);
        //initializing the Settings menu
        settingsMenu = new JMenu("Preferences");
        mb.add(settingsMenu);
        overlayRegionSettings = new JMenu("Regions Filling");
        drawOverlayRegion = new JRadioButtonMenuItem("none");
        drawOverlayRegion.setSelected(RecordModel.DRAW_POLYGON);
        fillOverlayRegion = new JRadioButtonMenuItem("solid");
        fillOverlayRegion.setSelected(RecordModel.FILL_POLYGON);
        fillOverlayRegionAlpha = new JRadioButtonMenuItem("solid with alpha blending");
        fillOverlayRegionAlpha.setSelected(RecordModel.FILL_POLYGON_ALPHA);
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(drawOverlayRegion);
        radioButtonGroup.add(fillOverlayRegion);
        radioButtonGroup.add(fillOverlayRegionAlpha);
        overlayRegionSettings.add(drawOverlayRegion);
        overlayRegionSettings.add(fillOverlayRegion);
        overlayRegionSettings.add(fillOverlayRegionAlpha);
        drawOverlayRegion.addActionListener((Record) getController());
        drawOverlayRegion.setActionCommand(Record.DRAW_POLYGON_SELECTED_ID);
        fillOverlayRegion.addActionListener((Record) getController());
        fillOverlayRegion.setActionCommand(Record.FILL_POLYGON_SELECTED_ID);
        fillOverlayRegionAlpha.addActionListener((Record) getController());
        fillOverlayRegionAlpha.setActionCommand(Record.FILL_POLYGON_ALPHA_SELECTED_ID);
        patientInfoPanelSettings = new JMenuItem("Zeige");
        showMedicamentList = new JCheckBoxMenuItem("Medikamente");
        showMedicamentList.addActionListener((Record) getController());
        showMedicamentList.setActionCommand(Record.SHOW_MEDICAMENT_LIST_ID);
        showProblemList = new JCheckBoxMenuItem("Probleme");
        showProblemList.addActionListener((Record) getController());
        showProblemList.setActionCommand(Record.SHOW_PROBLEM_LIST_ID);
        showCaveList = new JCheckBoxMenuItem("CAVE");
        showCaveList.addActionListener((Record) getController());
        showCaveList.setActionCommand(Record.SHOW_CAVE_LIST_ID);
        settingsMenu.add(overlayRegionSettings);
        //settingsMenu.add(showCaveList);
        //settingsMenu.add(showProblemList);
        //settingsMenu.add(showMedicamentList);
        //initializing the Help menu
        helpMenu = new JMenu("Help");
        mb.add(helpMenu);
        keyBoardConfiguration = new JMenuItem("Keyboard...");
        keyBoardConfiguration.setEnabled(false);
        helpManual = new JMenuItem("Handbuch");
        helpMenu.add(keyBoardConfiguration);
        //helpMenu.add(helpManual);
        return mb;
    }
    //
    // Tool bar.
    //

    /**
     * Creates the tool bar.
     * @return the tool bar
     * @exception NullPointerException if the tool bar is null
     */
    public ResToolBar createToolBar() throws NullPointerException {
        ResToolBar tb = new ResToolBar();
        if (tb != null) {
            tb.add(new JButton("Back"));
        } else {
            throw new NullPointerException("Could not create tool bar. The tool bar is null.");
        }
        return tb;
    }
    //
    // Split pane.
    //

    /**
     * Returns the split pane.
     * @return the split pane
     */
    protected ResSplitPane getSplitPane() {
        return this.splitPane;
    }

    /**
     * Sets the split pane.
     * @param splitPane the split pane
     */
    protected void setSplitPane(ResSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    /**
     * Creates the split pane.
     * @return the split pane
     * @exception NullPointerException if the split pane is null
     */
    protected ResSplitPane createSplitPane() throws NullPointerException {
        ResSplitPane sp = new ResSplitPane();
        if (sp != null) {
            sp.setOrientation(ResSplitPane.VERTICAL_SPLIT);
            sp.setTopComponent(createGeneralInformationPanel());
            sp.setBottomComponent(createContentsPanel());
            sp.setOneTouchExpandable(true);
            sp.setContinuousLayout(true);
            sp.setDividerLocation(200);
        } else {
            throw new NullPointerException("Could not create split pane. The split pane is null.");
        }
        return sp;
    }

    /**
     * Destroys the split pane.
     * @param splitPane the split pane
     */
    protected void destroySplitPane(ResSplitPane splitPane) {
    }
    //
    // Overview panel.
    //

    /**
     * Creates the overview panel.
     * @return the overview panel
     * @exception NullPointerException if the overview panel or the grid bag layout or the grid bag constraints is null
     * @exception NullPointerException if the overview tree is null
     */
    protected ResPanel createOverviewPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        if ((p != null) && (l != null) && (c != null)) {
            // Set panel properties.
            p.setLayout(l);
            // Relative cell width compared to all other cells in this row.
            c.gridwidth = 1;
            c.gridheight = 1;
            // The size of the panel will change when the form is resized.
            c.weighty = 1.0;
            // Expand panels in x- and y-direction for that they all have the same size/are ordered properly in one line.
            c.fill = GridBagConstraints.BOTH;
            TreeNode infoPanelTreeNode = null;
            ResPanel infoPanel = null;
            //?? Temporary dirty solution.
            RecordViewConfiguration conf = new RecordViewConfiguration();
            TreeNode n = conf.getOverviewTree();
            if (n != null) {
                int count = n.getChildCount();
                for (int i = 0; i < count; i++) {
                    // Determine child node and hand over to create panel.
                    infoPanelTreeNode = n.getChildAt(i);
                    if (!((DefaultMutableTreeNode) infoPanelTreeNode).getUserObject().equals("Photo")) {
                        // The size of the panel will change when the form is resized.
                        c.weightx = 1.0;
                        infoPanel = createInfoPanel(infoPanelTreeNode);
                    } else {
                        infoPanel = createPhotoPanel(infoPanelTreeNode);
                    }
                    if ((i + 1) == count) {
                        // Indicates the last component in a row.
                        c.gridwidth = GridBagConstraints.REMAINDER;
                    }
                    try {
                        // Set layout constraints and add panel.
                        l.setConstraints(infoPanel, c);
                        p.add(infoPanel);
                    } catch (NullPointerException e) {
                        // This exception has to be catched here!
                        // Otherwise, no info panel will be created if at least one of the panels is null.
                        // The NullPointerException is thrown from setConstraints which tries to
                        // add infoPanel to a Hashtable.
                        //?? getLogger().log(Level.WARNING, "Could not add info panel. The info panel is null.", e);
                        System.out.println("Could not add info panel. The info panel is null." + e);
                    }
                }
            } else {
                throw new NullPointerException("Could not create overview panel. The overview tree is null.");
            }
        } else {
            throw new NullPointerException("Could not create overview panel. The overview panel or the grid bag layout or the grid bag constraints is null.");
        }
        return p;
    }
    //
    // Photo panel.
    //

    /**
     * Creates the photo panel.
     * @param n the tree node specifying the image resource location
     * @return the photo panel
     * @exception NullPointerException if the photo panel or the configuration tree node is null
     */
    protected ResPanel createPhotoPanel(TreeNode n) throws NullPointerException {
        ResPanel p = new ResPanel();
        if ((p != null) && (n != null)) {
            String resource = (String) ((DefaultMutableTreeNode) ((DefaultMutableTreeNode) n).getFirstChild()).getUserObject();
            //?? Image Resource must be available. For testing, copy into /build (class) directory!!
            //?? java.net.URL url = c.getResource("/org/resmedicinae/application/healthcare/record/image.gif");
            java.net.URL url = getClass().getResource(resource);
            try {
                javax.swing.ImageIcon ii = new javax.swing.ImageIcon(url);
                JLabel l = new JLabel(ii);
                p.setLayout(new BorderLayout());
                p.add(l, BorderLayout.NORTH);
                p.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), ""));
            } catch (NullPointerException e) {
                // This exception has to be catched here!
                // Otherwise, the whole view will not be created.
                // The NullPointerException is thrown from ImageIcon()
                // which can't use a null parameter.
                //?? log(Level.WARNING, "Could not create image icon. The image icon is null.", e);
                System.out.println("Could not create image icon. The image icon is null." + e);
            }
        } else {
            throw new NullPointerException("Could not create photo panel. The photo panel or the configuration tree node is null.");
        }
        return p;
    }
    //
    // Info panel.
    //

    /**
     * Creates an info panel.
     * @param n the tree node containing the information to be displayed by the panel
     * @return the info panel
     * @exception NullPointerException if the info panel or the configuration tree node is null
     */
    protected ResPanel createInfoPanel(TreeNode n) throws NullPointerException {
        ResPanel p = new ResPanel();
        if ((p != null) && (n != null)) {
            // Set panel properties.
            String title = (String) ((DefaultMutableTreeNode) n).getUserObject();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), title));
            p.setMinimumSize(new Dimension(80, 60));
            JTree t = new JTree(n);
            ResScrollPane sp = new ResScrollPane();
            if ((t != null) && (sp != null)) {
                t.setRootVisible(false);
                t.setShowsRootHandles(false);
                sp.setViewportView(t);
            }
            p.add(sp, BorderLayout.CENTER);
        } else {
            throw new NullPointerException("Could not create info panel. The info panel or the configuration tree node is null.");
        }
        return p;
    }
    //
    // Contents panel.
    //

    /**
     * Creates the contents panel.
     * @return the contents panel
     * @exception NullPointerException if the contents panel is null
     */
    protected ResPanel createContentsPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        if (p != null) {
            ResPanel f = createFilterPanel();
            ResTabbedPane d = createDocumentationPanel();
            // Set panel properties and add child components.
            p.setLayout(new BorderLayout());
            //p.add(f, BorderLayout.NORTH);
            p.add(d, BorderLayout.CENTER);
            p.add(getStatusAndInformationPanel(), BorderLayout.SOUTH);
        } else {
            throw new NullPointerException("Could not create contents panel. The contents panel is null.");
        }
        return p;
    }
    //
    // Filter panel.
    //

    /**
     * Creates the filter panel.
     * @return the filter panel
     * @exception NullPointerException if the filter panel is null
     */
    protected ResPanel createFilterPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        if (p != null) {
            Object[] episodeNames = {"Episode 1", "Episode 2", "Episode 3"};
            Object[] entryNames = {"Diagnose", "Therapie", "Medikamente", "Befunde"};
            ResPanel episodePanel = new ResPanel();
            JLabel episodeLabel = new JLabel("Episode");
            JComboBox episodeComboBox = new JComboBox(episodeNames);
            episodePanel.setLayout(new BorderLayout());
            episodePanel.add(episodeLabel, BorderLayout.NORTH);
            episodePanel.add(episodeComboBox, BorderLayout.SOUTH);
            ResPanel entryPanel = new ResPanel();
            JLabel entryLabel = new JLabel("Entry");
            JComboBox entryComboBox = new JComboBox(entryNames);
            entryPanel.setLayout(new BorderLayout());
            entryPanel.add(entryLabel, BorderLayout.NORTH);
            entryPanel.add(entryComboBox, BorderLayout.SOUTH);
            //?? test
            ResTextField tf = new ResTextField();
            ResButton b = new ResButton();
            ResLabel l = new ResLabel();
            tf.setColumns(20);
            b.setControlId(Record.CREATE_LOAD_PATIENT_DIALOG_CONTROL_ID);
            //??            l.setSelectorString("patient_diagnose");
            // Set panel properties and add child components.
            p.setLayout(new BorderLayout());
            p.add(episodePanel, BorderLayout.WEST);
            p.add(entryPanel, BorderLayout.EAST);
            p.add(tf, BorderLayout.NORTH);
            p.add(b, BorderLayout.CENTER);
            p.add(l, BorderLayout.SOUTH);
            p.setBorder(
                    new CompoundBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), "Filter Settings"), new EmptyBorder(5, 5, 5, 5)));
        } else {
            throw new NullPointerException("Could not create filter panel. The filter panel is null.");
        }
        return p;
    }
    //
    // Documentation panel.
    //

    /**
     * Creates the contents panel.
     * @return the contents panel
     * @exception NullPointerException if the tabbed pane is null
     */
    protected ResTabbedPane createDocumentationPanel() throws NullPointerException {
        ResTabbedPane tp = new ResTabbedPane();
        if (tp != null) {
            this.topologyChart = createTopologyChart();
            tp.addTab("TreeTable", null, createTreeTable());
            tp.addTab("TextEditor", null, createTextEditor());
            tp.addTab("GraphChart", null, createGraphChart());
            tp.addTab("Topology", null, this.topologyChart);
            tp.setSelectedIndex(3);
            System.out.println("Assure proper visualization.");
            tp.setTabPlacement(ResTabbedPane.TOP);
        } else {
            throw new NullPointerException("Could not create documentation panel. The tabbed pane is null.");
        }
        return tp;
    }
    //
    // Tree table.
    //

    /**
     * Creates the tree table to display data entries sorted in a table.
     * @return the tree table
     * @exception NullPointerException if the tree table is null
     */
    protected TreeTablePanel createTreeTable() throws NullPointerException {
        setTreeTablePanel(new TreeTablePanel());
        getTreeTablePanel().setController(getController());
        // this.objectModel = new ObjectModel(dummyPatient, (RecordModel)getModel());
        this.objectModel = new ObjectModel((RecordModel) getModel());
        //t.setTreeTableModel(this.objectModel);

        /*this.xmlModel = new XMLModel();
        t.setTreeTableModel(this.xmlModel);*/

        treeTablePanel.initialize();
        //treeTablePanel.add(getStatusAndInformationPanel());
        //??        TreeNode n = ((RecordModel) getModel()).getEntriesTree();
        //??        TreeModel m = new DefaultTreeModel(n);
        //??        FilesystemDataSource d = new FilesystemDataSource(new java.io.File("/home/christian/tmp"), false);
        //??        ITreeModel m = new DynamicTreeModel(d);
        if (treeTablePanel != null) {
            //??            t.setTreeModel(m);
            //??            t.setSelectorString("open_entry");
            //??            t.setControlId(Record.OPEN_ENTRY);
        }
        return treeTablePanel;
    }
    //
    // Text editor.
    //

    /**
     * Creates the text editor to display data textually using markup commands.
     * @return the text editor
     * @exception NullPointerException if the text editor is null
     */
    protected ResTextPane createTextEditor() throws NullPointerException {
        ResTextPane p = new ResTextPane();
        return p;
    }
    //
    // Graph chart.
    //

    /**
     * Creates the graph chart to display episode data along a time axis.
     * @return the graph chart
     * @exception NullPointerException if the graph chart is null
     */
    protected JFreeChartPanel createGraphChart() throws NullPointerException {
        JFreeChartPanel p = null;
        JFreeChart c = null;
        DefaultPieDataset d = new DefaultPieDataset();
        if (d != null) {
            d.setValue("Category 1", new Double(43.2));
            d.setValue("Category 2", new Double(27.9));
            d.setValue("Category 3", new Double(79.5));
            c = ChartFactory.createPieChart("Episode History (will be a horizontal Bar Chart later!)", d, true);
            p = new JFreeChartPanel(c);
        } else {
            throw new NullPointerException("Could not create graph chart. The dataset is null.");
        }
        return p;
    }
    //
    // Topology chart.
    //

    /**
     * Creates the topology chart to help create a diagnose.
     * @return the topology chart
     * @exception NullPointerException if the topology chart is null
     */
    protected JPanel createTopologyChart() throws NullPointerException {
        JPanel p = new JPanel();
        if (p != null) {
            setRegionInfoPanel(createRegionInfoPanel());
            setImagePanel(createImagePanel());
            setMonitorReportPanel(createMonitorReportPanel());
            setStatusAndInformationPanel(createStatusAndInformationPanel());
            setManagePanel(createManagePanel());
            p.setLayout(new FlowLayout());
            p.add(getMonitorReportPanel());
            p.add(getManagePanel());
            p.add(getImagePanel());
            p.add(getRegionInfoPanel());
            p.add(getStatusAndInformationPanel());
        } else {
            throw new NullPointerException("Could not create topology chart. The panel is null.");
        }
        return p;
    }

    /**
     * Creates the region info panel.
     * @return the region info panel
     */
    public JPanel createRegionInfoPanel() throws NullPointerException {
        JPanel p = new JPanel();
        BorderLayout regionInfoPanelLayout = new BorderLayout();
        if (p != null) {
            // Add lifecycle here:
            // constructor, configure, compose, initialize
            //initializing the overlayRegion info panel
            //info panel contains overlayRegionInfoPanel as well as preview panel
            p.setPreferredSize(new Dimension(165, 380));
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            //here are the components of the overlayRegionInfoPanel
            overlayRegionInfoPanel = new JPanel();
            overlayRegionInfoPanel.setLayout(new GridLayout(2, 1));
            overlayRegionNameEntryLabel = new TopologyLabel("Name");
            overlayRegionNameEntryLabel.setPreferredSize(new Dimension(100, 20));
            overlayRegionNameEntryLabel.setFont(new Font("title", Font.BOLD, 10));
            overlayRegionTargetEntryLabel = new TopologyLabel("Target");
            overlayRegionTargetEntryLabel.setFont(new Font("title", Font.BOLD, 10));
            overlayRegionTargetEntryLabel.setVerticalAlignment(SwingConstants.NORTH);
            overlayRegionInfoPanel.add(overlayRegionNameEntryLabel);
            overlayRegionInfoPanel.add(overlayRegionTargetEntryLabel);
            overlayRegionInfoPanel.setBorder(BorderFactory.createTitledBorder("Current Region"));
            overlayRegionInfoPanel.setPreferredSize(new Dimension(145, 100));
            overlayRegionInfoPanel.setToolTipText("Information about current region");
            imageInfoTextArea = new TopologyTextArea(new Dimension(145, 110));
            TopologyScrollPane imageInfoTextAreaScrollPane = new TopologyScrollPane(imageInfoTextArea, "Explanation");
            imageInfoTextAreaScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
            imageInfoTextAreaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
            //here are the components of the previewPanel
            previewPanel = new PreviewPanel();
            previewPanel.setModel((RecordModel) getModel());
            previewPanel.setController(getController());
            previewPanel.initialize();
            //adding grabFocusCheckBox and both panels to infoPanel
            p.add(imageInfoTextAreaScrollPane);
            p.add(overlayRegionInfoPanel);
            p.add(previewPanel);
            //infoPanel.add(editCheckBox);
        } else {
            throw new NullPointerException("Could not create region info panel. The panel is null.");
        }
        return p;
    }

    /**
     * Creates the image info panel.
     * @return the image info panel
     * @exception NullPointerException if the panel is null
     */
    public ImagePanel createImagePanel() throws NullPointerException {
        ImagePanel p = new ImagePanel();
        if (p != null) {
            p.setModel((RecordModel) getModel());
            // Add lifecycle here:
            // constructor, configure, compose, initialize
            //initializing the image panel
            p.setModel((RecordModel) getModel());
            p.setController(getController());
            p.initialize();
            p.setBorder(new LineBorder(Color.BLACK));
        } else {
            throw new NullPointerException("Could not create image panel. The panel is null.");
        }
        return p;
    }
    //
    // Close control.
    //

    /**
     * Returns the close control for closing the window. ??Todo: Replace return type with Control of ResMedLib.
     * @return the close control
     * @exception NullPointerException if the control is null
     */
    public Control getCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_APPLICATION_CONTROL_ID);
            c.setSender(getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }
    //
    // Initializable.
    //

    /** Initializes this component. */
    public void initialize() throws Exception {
        super.initialize();
        setSplitPane(createSplitPane());
        //?? Put the following methods to an extra lifecycle method "assemble"?
        setFocusable(true);
        add(getSplitPane(), BorderLayout.CENTER);
        addFocusListener((FocusListener) getController());
        setModel(((Record) getController()).getModel());
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            //?? Put the following methods to an extra lifecycle method "disassemble"?
            remove(getSplitPane());
            destroySplitPane(getSplitPane());
            setSplitPane(null);
        } finally {
            super.finalizz();
        }
    }

    /** Overrides paint from class JComponent */
    public void paint(Graphics g) {
        super.paint(g);
    }

    /** Overrides update from class JComponent */
    public void update(Graphics g) {
        super.update(g);
    }    

    public TopologyTextArea createReportTextArea(Dimension d) {
        TopologyTextArea t = new TopologyTextArea(d);
        if (t != null) {
            t.setBorder(BorderFactory.createTitledBorder("Objective"));
        } else {
            throw new NullPointerException("Could not create report text area. The text area is null.");
        }
        return t;
    }

    public ResPanel createGeneralInformationPanel() {
        ResPanel g = new ResPanel();
        g.setLayout(new FlowLayout());
        setPatientInfoPanel(createPatientInfoPanel());
        g.add(getPatientInfoPanel());
        return g;
    }

    /**
     * Creates the patient info panel.
     * @return the patient info panel
     * @exception NullPointerException if the panel is null
     */
    public PatientInfoPanel createPatientInfoPanel() {
        PatientInfoPanel pip = new PatientInfoPanel();
        pip.setController(getController());
        pip.initialize();
        setPatientInfoPanel(pip);
        return pip;
    }

    public JButton createHistoryBackButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"back.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"backOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.HISTORY_BACK_ID);
            b.setEnabled(false);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Show previous overlay");
        } else {
            throw new NullPointerException("Could not create history back button. The button is null.");
        }
        return b;
    }

    public ResPanel createStatusAndInformationPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            FlowLayout statusAndInformationPanelLayout = new FlowLayout();
            statusAndInformationPanelLayout.setAlignment(FlowLayout.LEFT);
            p.setLayout(statusAndInformationPanelLayout);
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            p.setPreferredSize(new Dimension(1000, 30));
            setStatusAndInformationLabel(createStatusAndInformationLabel());
            p.add(getStatusAndInformationLabel());
        } else {
            throw new NullPointerException("Could not create Status and Information panel. The panel is null.");
        }
        return p;
    }

    public JLabel createStatusAndInformationLabel() {
        JLabel l = new JLabel("Ready.");
        if (l != null) {
            l.setText(RecordMessages.READY_MESSAGE);
        } else {
            throw new NullPointerException("Could not create Status and Information Text area. The text area is null");
        }
        return l;
    }

    public JCheckBox createGrabFocusCheckBox() {
        JCheckBox g = new JCheckBox("Keyboard");
        if (g != null) {
            /*g.setIcon(new CheckBoxIcon("K",false, false));
            g.setSelectedIcon(new CheckBoxIcon("K", false, true));*/

            g.setToolTipText("Keyboardstreuerung");
            g.addItemListener((Record) getController());
        } else {
            throw new NullPointerException("Could not create grab focus checkbox. The checkbox is null.");
        }
        return g;
    }

    public ResPanel createMonitorReportPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            p.setPreferredSize(new Dimension(390, 380));
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            setReportTextArea(createReportTextArea(new Dimension(385,80)));
            setOverlayTree(createOverlayTree());
            //p.add(getReportTextArea());
            JScrollPane overlayTreeScrollPane = new JScrollPane(getOverlayTree());
            overlayTreeScrollPane.setPreferredSize(new Dimension(380,360));
            overlayTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
            overlayTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
            p.add(overlayTreeScrollPane);
        } else {
            throw new NullPointerException("Could not create monitor report panel. The panel is null");
        }
        return p;
    }

    public JCheckBox createShowMarkersCheckBox() {
        JCheckBox c = new JCheckBox();
        c.setSelectedIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"showmarker.gif"));
        c.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"notshowmarker.gif"));
        if (c != null) {
            /*c.setIcon(new CheckBoxIcon("M",false,false));
            c.setSelectedIcon(new CheckBoxIcon("M",false,true));*/

            c.setToolTipText("Show all markers");
            c.addItemListener((Record) getController());
            c.setPreferredSize(new Dimension(35, 35));
            c.setEnabled(false);
        } else {
            throw new NullPointerException("Could not create show markers checkbox. The checkbox is null.");
        }
        return c;
    }

    public ResPanel createManagePanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p.setLayout(gridBag);
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            p.setPreferredSize(new Dimension(44, 380));
            setOverlayLabel(createOverlayLabel());
            setHistoryBackButton(createHistoryBackButton());
            setBackToStartOverlayButton(createBackToStartOverlayButton());
            setAlternativeOverlayButton(createAlternativeOverlayButton());
            setMarkerLabel(createMarkerLabel());
            setSaveMarkersButton(createSaveMarkersButton());
            setRemoveAllMarkersButton(createRemoveAllMarkersButton());
            setShowMarkersCheckBox(createShowMarkersCheckBox());
            setControlLabel(createControlLabel());
            setGrabFocusCheckBox(createGrabFocusCheckBox());
            setEmptyLabel(createEmptyLabel());
            setObjectLabel(createObjectLabel());
            setChangeObjectButton(createChangeObjectButton());
            setRemoveCurrentObjectButton(createRemoveCurrentObjectButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 1;
            c.weighty = 2;
            gridBag.setConstraints(getBackToStartOverlayButton(), c);
            p.add(getBackToStartOverlayButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 2;
            gridBag.setConstraints(getHistoryBackButton(), c);
            p.add(getHistoryBackButton());
            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 3;

            gridBag.setConstraints(getAlternativeOverlayButton(), c);
            p.add(getAlternativeOverlayButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 6;
            gridBag.setConstraints(getSaveMarkersButton(), c);
            p.add(getSaveMarkersButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 7;
            gridBag.setConstraints(getRemoveAllMarkersButton(), c);
            p.add(getRemoveAllMarkersButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 8;
            gridBag.setConstraints(getShowMarkersCheckBox(), c);
            p.add(getShowMarkersCheckBox());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 14;
            gridBag.setConstraints(getChangeObjectButton(), c);
            p.add(getChangeObjectButton());
            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 15;
            gridBag.setConstraints(getRemoveCurrentObjectButton(), c);
            p.add(getRemoveCurrentObjectButton());
        }
        return p;
    }

    public JButton createBackToStartOverlayButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"home.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"homeOver.gif"));
        if (b != null) {
            b.setToolTipText("Back to start");
            b.setActionCommand(Record.BACK_TO_START_OVERLAY_ID);
            b.addActionListener((Record) getController());
            b.setPreferredSize(new Dimension(35, 35));
        } else {
            throw new NullPointerException("Could not create back to start overlay button. The button is null.");
        }
        return b;
    }

    public JButton createAlternativeOverlayButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"alt.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"altOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.SHOW_ALTERNATIVE_OVERLAY_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Show alternative overlays");
        } else {
            throw new NullPointerException("Could not create alternative overlay button. The button is null.");
        }
        return b;
    }

    public JButton createRemoveAllMarkersButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delmarker.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delmarkerOver.gif"));
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.REMOVE_MARKER_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Remove all markers");
        } else {
            throw new NullPointerException("Could not create remove markers button. The button is null.");
        }
        return b;
    }

    public JButton createSaveMarkersButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"savemarker.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"savemarkerOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.SAVE_MARKER_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Save markers");
        } else {
            throw new NullPointerException("Could not create save markers button. The button is null.");
        }
        return b;
    }

    public TopologyLabel createMarkerLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Marker");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create marker label. The label is null.");
        }
        return l;
    }

    public TopologyLabel createOverlayLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Overlay");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create overlay label. The label is null.");
        }
        return l;
    }

    public TopologyLabel createControlLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Kontrolle");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create control label. The label is null.");
        }
        return l;
    }

    public TopologyLabel createEmptyLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Empty");
            l.setForeground(RecordModel.BackgroundColor);
        } else {
            throw new NullPointerException("Could not create empty label. The label is null.");
        }
        return l;
    }

    public TopologyLabel createObjectLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Befund");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create object label. The label is null.");
        }
        return l;
    }

    public JButton createChangeObjectButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"prevobjective.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"prevobjectiveOver.gif"));
            b.setToolTipText("Next objective");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.NEXT_OBJECT_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setEnabled(true);
        } else {
            throw new NullPointerException("Could not create change object button. The button is null.");
        }
        return b;
    }

    public JButton createRemoveCurrentObjectButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setToolTipText("Remove current objective");
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delobjective.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delobjectiveOver.gif"));
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.REMOVE_CURRENT_OBJECT_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setEnabled(true);
        } else {
            throw new NullPointerException("Could not create remove object button. The button is null.");
        }
        return b;
    }

    public OverlayTree createOverlayTree(){
        RecordModel model = (RecordModel)getModel();
        OverlayTree overlayTree = new OverlayTree();
        overlayTree.addTreeSelectionListener((Record)getController());
        overlayTree.addMouseListener((Record)getController());
        //overlayTree.setPreferredSize(new Dimension(390,200));
        return overlayTree;
    }


    public OverlayTreeModel createOverlayTreeModel(RecordModel model){
        //Overlay rootOverlay = (Overlay)model.getOverlayHashtable().get(RecordModel.StartDocumentName);
        OverlayTreeModel overlayTreeModel = new OverlayTreeModel();
        return overlayTreeModel;
    }

}
