/*
 * $RCSfile: CheckBoxIcon.java,v $
 *
 * Copyright (c) 1999-2003. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.record;

import javax.swing.*;
import java.awt.*;

public class CheckBoxIcon implements Icon {
    /** The title of the checkbox. */
    public static final String TITLE = "title";
    /** The height of the icon. */
    public static final String HEIGHT = "height";
    /** The width of the icon. */
    public static final String WIDTH = "width";
    /** Indicates whether the icon is selected or not */
    public static final String SELECTED = "selected";
    /** Indicates whether the icon is focused or not */
    public static final String FOCUSED = "focused";
    /** The outer rectangle height. */
    public static final String OUTER_HEIGHT = "outer_height";
    /** The outer rectangle width. */
    public static final String OUTER_WIDTH = "outer_width";
    /** The inner rectangle height. */
    public static final String INNER_HEIGHT = "inner_height";
    /** The inner rectangle width. */
    public static final String INNER_WIDTH = "inner_width";
    
    
    public CheckBoxIcon(String title, boolean focused, boolean selected) {
        set(CheckBoxIcon.TITLE, new String(title));
        set(CheckBoxIcon.FOCUSED, new Boolean(focused));
        set(CheckBoxIcon.SELECTED, new Boolean(selected));
        set(CheckBoxIcon.HEIGHT, new Integer(27));
        set(CheckBoxIcon.WIDTH, new Integer(17));
    }

    

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if ((Boolean)get(CheckBoxIcon.FOCUSED)) {
            g.drawRect(x, y, getOuterRectangleHeight(), getOuterRectangleWidth());
            Color color3 = new Color(95, 115, 127);
            g.setColor(color3);
            g.fillRect(x, y, getOuterRectangleHeight(), getOuterRectangleWidth());
            g.setColor(Color.BLACK);
            g.drawRect(x + 2, y + 2, getInnerRectangleHeight(), getInnerRectangleWidth());
            g.setColor(Color.RED);
            g.fillRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.drawString(getTitle(), x, y);
        } else {
            g.drawRect(x, y, outerRectangleHeight, outerRectangleWidth);
            g.setColor(Color.GRAY);
            g.fillRect(x, y, outerRectangleHeight, outerRectangleWidth);
            g.drawRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.setColor(RecordModel.BackgroundColor);
            g.fillRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.setColor(Color.BLACK);
            g.drawString(getTitle(), x + 4, y + 13);
        }
        if ((Boolean)get(CheckBoxIcon.SELECTED)) {
            g.setColor(Color.RED);
            g.drawString(getTitle(), x + 4, y + 13);

            /*g.drawLine(x+4,y+4,x+12,y+12);
            g.drawLine(x+4,y+12,x+12,y+4);

            g.drawLine(x+5,y+4,x+12,y+11);
            g.drawLine(x+4,y+11,x+11,y+4);*/
        }
    }
    
}
