/*
 * $RCSfile: StoringOption.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */


package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;


/**
 * This class represents a StoringOption Window.
 *
 * @version $Revision: 1.3 $ $Date: 2003/01/07 16:20:51 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 */

public class StoringOption extends SwingView {


    private JPanel storingOptionPanel;
    private JTextField storingPathTextField;

    /**
     * Initializes this view.
     */
    public void initialize() throws Exception {


        try {
            super.initialize();
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);

            this.setDialogBounds(this.createDialogBounds());
            this.setTitle("Storing Option");
            this.setStoringOptionPanel(this.createStoringOptionPanel());
            this.add(this.getStoringOptionPanel(), BorderLayout.WEST);
            this.setResizable(true);

        } catch (Exception e) {
            System.out.println("Fehler: " + e);
        }

    }

    /**
     * Create the MenuBar.
     *
     *@return the MenuBar
     */

    public ResMenuBar createMenuBar() {


        ResMenuBar mb = new ResMenuBar();
        ResMenu menu1 = new ResMenu(); // Window

        ResMenuItem menuItem11 = new ResMenuItem();

        try {

            menuItem11.setText("Close");
            menuItem11.setActionCommand(Restore.STORING_OPTION_WINDOW_CLOSE_WINDOW_ID);
            menuItem11.setEnabled(true);
            menuItem11.addActionListener((Restore) getController());

            menu1.setText("Window");
            menu1.add(menuItem11);
            mb.add(menu1);

        } catch (Exception e) {
            System.out.println("There was an error in the class StoringOption: " + e);
        }
        ;

        return mb;

    }

    /**
     * Create the Panel.
     *
     *@return the Panel
     */
    public JPanel createStoringOptionPanel() throws Exception {

        // create panels
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        JPanel p5 = new JPanel();
        JPanel p6 = new JPanel();

        // create buttons
        ResButton b1 = new ResButton();
        ResButton b2 = new ResButton();
        ResButton b3 = new ResButton();
        ResButton b4 = new ResButton();

        // create labels
        ResLabel l2 = new ResLabel();
        ResLabel l3 = new ResLabel();

        // create a TextField
        this.storingPathTextField = new JTextField();


        try {

            p1.setLayout(new FlowLayout(FlowLayout.LEFT));
            p2.setLayout(new GridLayout(2, 1));
            p3.setLayout(new FlowLayout(FlowLayout.LEFT));
            p4.setLayout(new FlowLayout(FlowLayout.LEFT));
            p5.setLayout(new GridLayout(2, 1));

            l2.setText("Storing Path");
            l3.setText("");

            this.getStoringPathTextField().setColumns(39);

            b1.setText("Select Path");
            b1.addActionListener((Restore) getController());
            b1.setActionCommand(Restore.STORING_OPTION_WINDOW_SELECT_PATH_ID);
            b1.setToolTipText("Please select a place, where the information files can be stored.");

            b2.setText("Save");
            b2.addActionListener((Restore) getController());
            b2.setActionCommand(Restore.STORING_OPTION_WINDOW_SAVE_ID);

            b3.setText("Cancel");
            b3.addActionListener((Restore) getController());
            b3.setActionCommand(Restore.STORING_OPTION_WINDOW_CANCEL_ID);

            p2.add(l2);
            p2.add(this.getStoringPathTextField());

            p3.add(p2);

            p4.add(b1);
            p4.add(b2);
            p4.add(b3);

            p5.add(p3);
            p5.add(p4);

        } catch (Exception e) {
            System.out.println("There was an error in the class BackupOption: " + e);
        }
        ;

        return p5;
    }


    public void setStoringOptionPanel(JPanel storingOptionPanel) {

        this.storingOptionPanel = storingOptionPanel;

    }


    public JPanel getStoringOptionPanel() {

        return this.storingOptionPanel;

    }


    public void setStoringPathTextField(JTextField jtf) {

        this.storingPathTextField = jtf;

    }


    public JTextField getStoringPathTextField() {

        return this.storingPathTextField;

    }


    /**
     * Update the Storing Path TextField.
     *
     *
     */
    public void updateStoringPathTextField() throws Exception {
        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getStoringPathTextField().setText(model.getStoringPathString());

        } catch (Exception e) {

            throw new Exception("Couldn't show data! \n" + e);

        }
    }

    /**
     * Determine the size of the window.
     *
     *@return the window with its special size
     */
    public Rectangle createDialogBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 460;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 180;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new Rectangle(x, y, w, h);
    }


    /**
     * Finalizes this view.
     */
    public void finalizz() throws Exception {

        try {


        } finally {

            super.finalizz();
        }

    }


}
