/*
 * $RCSfile: RestoreView.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;

/**
 * This class represents the main view.
 *
 * @version $Revision: 1.9 $ $Date: 2003/01/07 16:20:49 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class RestoreView extends SwingView {

    private BackupOption backupOption = null;     // the Backup Option Window
    private RestoreOption restoreOption = null;   // the Restore Option Window
    private StoringOption storingOption = null;   // the Storing Option Window

    // some FileChooser Dialogs
    private FileChooser openFileChooser = null;
    private FileChooser openFolderChooser = null;
    private FileChooser openFolderRecursiveChooser = null;
    private FileChooser openBackupPathChooser = null;
    private FileChooser openRestorePathChooser = null;
    private FileChooser openStoringPathChooser = null;
    private FileChooser openInformationFileChooser = null;

    private int selectedRepositoryIndex = -1;
    private int oldSelectedRepositoryIndex = -1;

    private JList repositoryList;
    private JList choiceList;
    private JList restoreChoiceList;

    private JTextArea backupTextArea;
    private JTextArea restoreTextArea;
    private JTextArea errorTextArea;
    private JTextArea infoTextArea;

    private String str;

    /** The directory panel. */
    private JPanel directoryPanel;


    protected JPanel getDirectoryPanel() {

        return this.directoryPanel;
    }


    protected void setDirectoryPanel(JPanel directoryPanel) {

        this.directoryPanel = directoryPanel;
    }

    /**
     * Creates the MenuBar.
     *
     * @return the MenuBar
     */
    public ResMenuBar createMenuBar() {

        ResMenuBar mb = new ResMenuBar();
        ResMenu menu1 = new ResMenu(); // System
        ResMenu menu2 = new ResMenu(); // Options
        ResMenu menu3 = new ResMenu(); // Help

        // Menu System
        ResMenuItem menuItem11 = new ResMenuItem();
        ResMenuItem menuItem12 = new ResMenuItem();
        ResMenuItem menuItem13 = new ResMenuItem();
        ResMenuItem menuItem14 = new ResMenuItem();

        //Menu Options
        ResMenuItem menuItem21 = new ResMenuItem();
        ResMenuItem menuItem22 = new ResMenuItem();
        ResMenuItem menuItem23 = new ResMenuItem();

        //Menu Help
        ResMenuItem menuItem31 = new ResMenuItem();

        try {

            //
            // Menu System
            //
            menuItem11.setText(Restore.BACKUP_SYSTEM_ID);
            menuItem11.setEnabled(true);
            menuItem11.addActionListener((Restore) getController());

            menuItem12.setText(Restore.RESTORE_SYSTEM_ID);
            menuItem12.setEnabled(true);
            menuItem12.addActionListener((Restore) getController());

            menuItem14.setText(Restore.EXIT_SYSTEM_ID);
            menuItem14.setEnabled(true);
            menuItem14.addActionListener((Restore) getController());

            menu1.setText("System");
            menu1.add(menuItem11);
            menu1.add(menuItem12);
            menu1.add(menuItem14);
            mb.add(menu1);

            //
            // Menu Options
            //
            menuItem21.setText(Restore.BACKUP_OPTION_ID);
            menuItem21.setEnabled(true);
            menuItem21.addActionListener((Restore) getController());

            menuItem22.setText(Restore.RESTORE_OPTION_ID);
            menuItem22.setEnabled(true);
            menuItem22.addActionListener((Restore) getController());

            menuItem23.setText(Restore.STORING_OPTION_ID);
            menuItem23.setEnabled(true);
            menuItem23.addActionListener((Restore) getController());

            menu2.setText("Options");
            menu2.add(menuItem21);
            menu2.add(menuItem22);
            menu2.add(menuItem23);
            mb.add(menu2);

            //
            // Menu Help
            //
            menuItem31.setText(Restore.ABOUT_HELP_ID);
            menuItem31.setEnabled(true);
            menuItem31.addActionListener((Restore) getController());

            menu3.setText("Help");
            menu3.add(menuItem31);
            mb.add(menu3);

        } catch (Exception e) {
            System.out.println("There was an error in the class RestoreView: " + e);
        }
        ;

        return mb;

    }

    /**
     * Creates the DirectoryPanel.
     *
     * @return the DirectoryPanel
     */
    protected JPanel createDirectoryPanel() throws NullPointerException {

        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        JPanel p5 = new JPanel();
        JPanel p6 = new JPanel();
        JPanel p7 = new JPanel();

        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        // create JLists and ScrollPanes
        repositoryList = new JList();
        choiceList = new JList();
        restoreChoiceList = new JList();
        backupTextArea = new JTextArea();
        restoreTextArea = new JTextArea();
        errorTextArea = new JTextArea();
        infoTextArea = new JTextArea();

        JList list3 = new JList();
        JScrollPane scroll1;
        JScrollPane scroll2;
        JScrollPane scroll3;
        JScrollPane scroll4;
        JScrollPane scroll5;
        JScrollPane scroll6;
        JScrollPane scroll7;

        // create buttons
        JButton b1 = new JButton();
        JButton b2 = new JButton();
        JButton b3 = new JButton();

        // create a TabbedPane
        JTabbedPane choiceTabbedPane = new JTabbedPane();
        JTabbedPane reportTabbedPane = new JTabbedPane();

        try {
            p1.setLayout(new FlowLayout());
            p2.setLayout(new GridLayout(3, 1));
            p3.setLayout(new FlowLayout());
            p4.setLayout(new FlowLayout());
            p5.setLayout(new FlowLayout());
            p6.setLayout(new GridLayout(2, 1));
            p7.setLayout(new FlowLayout());

            p1.setBorder(BorderFactory.createTitledBorder("Repository"));
            p3.setBorder(BorderFactory.createTitledBorder("Choice"));
            p4.setBorder(BorderFactory.createTitledBorder("Report"));

            b1.setText("     BACKUP     ");
            b1.addActionListener((Restore) getController());
            b1.setActionCommand(Restore.BACKUP_ID);

            b2.setText("     RESTORE    ");
            b2.setActionCommand(Restore.RESTORE_ID);
            b2.addActionListener((Restore) getController());

            b3.setText("LOAD REPOSITORY");
            b3.addActionListener((Restore) getController());
            b3.setActionCommand(Restore.LOAD_REPOSITORY_ID);
            b3.setToolTipText("Load an existing repository...");


            this.getRepositoryList().setBackground(this.getBackground());
            this.getRepositoryList().addListSelectionListener((ListSelectionListener) getController());
            this.getChoiceList().setBackground(this.getBackground());
            restoreChoiceList.setBackground(this.getBackground());
            this.getBackupTextArea().setBackground(this.getBackground());
            this.getRestoreTextArea().setBackground(this.getBackground());
            this.getErrorTextArea().setBackground(this.getBackground());
            this.getInfoTextArea().setBackground(this.getBackground());
            list3.setBackground(this.getBackground());

            scroll1 = new JScrollPane(this.getRepositoryList());
            scroll1.setPreferredSize(new Dimension(225, 190));
            scroll1.setMinimumSize(new Dimension(45, 30));

            scroll2 = new JScrollPane(this.getChoiceList());
            scroll3 = new JScrollPane(this.getRestoreChoiceList());
            scroll4 = new JScrollPane(this.getBackupTextArea());
            scroll5 = new JScrollPane(this.getRestoreTextArea());
            scroll6 = new JScrollPane(this.getErrorTextArea());
            scroll7 = new JScrollPane(this.getInfoTextArea());

            choiceTabbedPane.addTab("Choice", scroll2);
            choiceTabbedPane.addTab("RestoreChoice", scroll3);
            choiceTabbedPane.setPreferredSize(new Dimension(300, 200));
            choiceTabbedPane.setMinimumSize(new Dimension(75, 40));

            reportTabbedPane.addTab("Backup", scroll4);
            reportTabbedPane.addTab("Restore", scroll5);
            reportTabbedPane.addTab("Errors", scroll6);
            reportTabbedPane.addTab("Info", scroll7);
            reportTabbedPane.setPreferredSize(new Dimension(300, 200));
            reportTabbedPane.setMinimumSize(new Dimension(75, 40));

            p1.add(scroll1);

            p2.add(b1);
            p2.add(b2);
            p2.add(b3);

            p1.setPreferredSize(new Dimension(235, 235));

            p3.add(choiceTabbedPane);

            p4.add(reportTabbedPane);

            p5.add(p1);
            p5.add(p3);
            p5.add(p4);
            p5.setMinimumSize(new Dimension(600, 200));
            p6.add(p5);
            p6.add(p2);

            p7.add(p6);

        } catch (Exception e) {
            System.out.println("There was an error in the class RestoreView: " + e);
        }
        ;

        return p7;
    }


    /**
     * Destroys the directory panel.
     *
     * @param directoryPanel the directory panel
     */
    protected void destroyDirectoryPanel(JPanel directoryPanel) {
    }

    //
    // Initializable.
    //

    /**
     * Initializes this view.
     */
    public void initialize() throws Exception {

        super.initialize();

        setLayout(new BorderLayout());
        setTitle("Backup Tool");
        this.setResizable(true);
        setDirectoryPanel(createDirectoryPanel());

        this.add(getDirectoryPanel(), BorderLayout.WEST);

    }

    /**
     * Finalizes this view.
     */
    public void finalizz() throws Exception {

        try {

            remove(getDirectoryPanel());
            destroyDirectoryPanel(getDirectoryPanel());
            setDirectoryPanel(null);

        } finally {

            super.finalizz();
        }
    }


    public BackupOption getBackupOption() {

        return this.backupOption;
    }

    /**
     * Create the Backup Option Window
     * @return the Backup Option Window
     */
    public BackupOption createBackupOption() {

        BackupOption bo = new BackupOption();
        bo.setModel(getModel());
        bo.setController(getController());

        try {
            bo.initialize();

        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return bo;

    }


    public void setBackupOption(BackupOption backupOption) {

        this.backupOption = backupOption;

    }

    /**
     * Create the Restore Option Window
     * @return the Restore Option Window
     */
    public RestoreOption createRestoreOption() {

        RestoreOption ro = new RestoreOption();
        ro.setModel(getModel());
        ro.setController(getController());

        try {
            ro.initialize();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return ro;

    }


    public RestoreOption getRestoreOption() {

        return this.restoreOption;

    }


    public void setRestoreOption(RestoreOption restoreOption) {

        this.restoreOption = restoreOption;

    }

    /**
     * Create the  Storing Option Window
     * @return the Storing Option Window
     */
    public StoringOption createStoringOption() {

        StoringOption so = new StoringOption();
        so.setModel(getModel());
        so.setController(getController());

        try {
            so.initialize();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return so;

    }


    public StoringOption getStoringOption() {

        return this.storingOption;

    }


    public void setStoringOption(StoringOption storingOption) {

        this.storingOption = storingOption;

    }

    /**
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenFileDialog() {

        FileChooser fileDialog = new FileChooser();
        fileDialog.setModel(getModel());
        fileDialog.setController(getController());

        try {
            fileDialog.createSelectFileDialog();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return fileDialog;

    }


    public FileChooser getOpenFileDialog() {

        return this.openFileChooser;

    }


    public void setOpenFileDialog(FileChooser fc) {

        this.openFileChooser = fc;

    }

    /**
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenFolderDialog() {

        FileChooser folderDialog = new FileChooser();
        folderDialog.setModel(getModel());

        folderDialog.setController(getController());

        try {
            folderDialog.createSelectFolderDialog();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return folderDialog;

    }


    public FileChooser getOpenFolderDialog() {

        return this.openFolderChooser;

    }


    public void setOpenFolderDialog(FileChooser fc) {

        this.openFolderChooser = fc;

    }

    /**
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenFolderRecursiveDialog() {

        FileChooser folderRecursiveDialog = new FileChooser();
        folderRecursiveDialog.setModel(getModel());
        folderRecursiveDialog.setController(getController());

        try {
            folderRecursiveDialog.createSelectFolderRecursiveDialog();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return folderRecursiveDialog;
    }

    public FileChooser getOpenFolderRecursiveDialog() {

        return this.openFolderRecursiveChooser;

    }


    public void setOpenFolderRecursive(FileChooser fc) {

        this.openFolderRecursiveChooser = fc;

    }

    /**
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenBackupPathDialog() {

        FileChooser backupPathDialog = new FileChooser();
        backupPathDialog.setModel(getModel());
        backupPathDialog.setController(getController());

        try {
            backupPathDialog.createBackupPathDialog();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return backupPathDialog;

    }


    public FileChooser getOpenBackupPathDialog() {

        return this.openBackupPathChooser;

    }


    public void setOpenBackupPathDialog(FileChooser fc) {

        this.openBackupPathChooser = fc;

    }

    /**
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenRestorePathDialog() {

        FileChooser restorePathDialog = new FileChooser();
        restorePathDialog.setModel(getModel());
        restorePathDialog.setController(getController());

        try {
            restorePathDialog.createRestorePathDialog();
        } catch (Exception e) {
            System.out.println("Fehler:" + e);
        }

        return restorePathDialog;

    }


    public FileChooser getOpenRestorePathDialog() {

        return this.openRestorePathChooser;

    }


    public void setOpenRestorePathDialog(FileChooser fc) {

        this.openRestorePathChooser = fc;

    }

    /**
     * Create the Storing Option Window
     * @return the Storing Option Window
     */
    public FileChooser createOpenStoringPathDialog() {

        FileChooser storingPathDialog = new FileChooser();
        storingPathDialog.setModel(getModel());
        storingPathDialog.setController(getController());

        try {

            storingPathDialog.createStoringPathDialog();

        } catch (Exception e) {
            System.out.println("Fehler:" + e);

        }

        return storingPathDialog;

    }


    public FileChooser getOpenStoringPathDialog() {

        return this.openStoringPathChooser;

    }

    public void setOpenStoringPathDialog(FileChooser fc) {

        this.openStoringPathChooser = fc;

    }

    /**
     * Load the file RestoreInfo.res
     * Create a FileChooser Dialog
     * @return a FileChooser Dialog
     */
    public FileChooser createOpenInformationFileDialog() {

        FileChooser informationFileDialog = new FileChooser();
        informationFileDialog.setModel(getModel());
        informationFileDialog.setController(getController());

        try {

            informationFileDialog.createSelectInformationFileDialog();

        } catch (Exception e) {
            System.out.println("Fehler:" + e);

        }

        return informationFileDialog;

    }


    public FileChooser getOpenInformationFileDialog() {

        return this.openInformationFileChooser;

    }


    public void setOpenInformationFileDialog(FileChooser fc) {

        this.openInformationFileChooser = fc;

    }


    public JList getRepositoryList() {
        return this.repositoryList;
    }


    public void setRepositoryList(JList list1) {
        this.repositoryList = list1;
    }

    /**
     * Update the RepositoryList
     *
     */
    public void updateRepositoryList() throws Exception {
        try {

            RestoreModel model = (RestoreModel) getModel();

            getRepositoryList().setEnabled(true);
            getRepositoryList().setListData(model.getRepositoryVector());
            getRepositoryList().setSelectedIndex(this.getSelectedRepositoryIndex());

        } catch (Exception e) {
            throw new Exception("Couldn't show JList data! \n" + e);
        }
    }


    public JList getChoiceList() {

        return this.choiceList;

    }


    public void setChoiceList(JList list1) {

        this.choiceList = list1;

    }

    /**
     * Update the ChoiceList
     *
     */
    public void updateChoiceList() throws Exception {
        try {
            RestoreModel model = (RestoreModel) getModel();


            getChoiceList().setEnabled(true);
            getChoiceList().setListData(model.getChoiceVector());

        } catch (Exception e) {
            throw new Exception("Couldn't show JList data! \n" + e);
        }
    }


    public JList getRestoreChoiceList() {

        return this.restoreChoiceList;

    }


    public void setRestoreChoiceList(JList list1) {

        this.restoreChoiceList = list1;

    }

    /**
     * Update the RestoreChoiceList
     *
     */
    public void updateRestoreChoiceList() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();
            getRestoreChoiceList().setListData(model.getRestoreChoiceVector());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }

    }


    public JTextArea getBackupTextArea() {

        return this.backupTextArea;

    }


    public void setBackupTextArea(JTextArea area) {

        this.backupTextArea = area;

    }

    /**
     * Update the BackupPathArea
     *
     */
    public void updateBackupTextArea() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getBackupTextArea().append(model.getReportAreaString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }

    }


    public JTextArea getRestoreTextArea() {

        return this.restoreTextArea;

    }


    public void setRestoreTextArea(JTextArea area) {

        this.restoreTextArea = area;

    }

    /**
     * Update the RestoreTextArea
     *
     */
    public void updateRestoreTextArea() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getRestoreTextArea().append(model.getReportAreaString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }

    }


    public JTextArea getErrorTextArea() {

        return this.errorTextArea;

    }


    public void setErrorTextArea(JTextArea area) {

        this.errorTextArea = area;

    }

    /**
     * Update the ErrorTextArea
     *
     */
    public void updateErrorTextArea() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getErrorTextArea().append(model.getReportAreaString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }

    }


    public JTextArea getInfoTextArea() {

        return this.infoTextArea;

    }


    public void setInfoTextArea(JTextArea area) {

        this.infoTextArea = area;

    }

    /**
     * Update the InfoTextArea
     */
    public void updateInfoTextArea() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getInfoTextArea().append(model.getReportAreaString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }

    }


    public void setSelectedRepositoryIndex(int index) {

        this.selectedRepositoryIndex = index;

    }


    public void updateSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = this.selectedRepositoryIndex;
        this.selectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getSelectedRepositoryIndex() {

        return this.selectedRepositoryIndex;

    }


    public void setOldSelectedRepositoryIndex(int index) {

        this.oldSelectedRepositoryIndex = index;

    }


    public void updateOldSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getOldSelectedRepositoryIndex() {

        return this.oldSelectedRepositoryIndex;

    }

}

