/*
* $RCSfile: RestoreOption.java,v $
*
* Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
*
* This software is published under the GPL GNU General Public License.
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
* http://www.resmedicinae.org
* - Information in Medicine -
*/

package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;


/**
 * This class represents a RestoreOption Window
 *
 * @version $Revision: 1.4 $ $Date: 2003/01/07 16:20:48 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 */


public class RestoreOption extends SwingView {

    private JList repositoryList;
    private JList choiceList;
    private JList restoreChoiceList;
    public static ButtonGroup group;
    private JPanel restoreOptionPanel;
    private JTextField restorePathTextField;

    private JTabbedPane tabbedPane;

    private int selectedRepositoryIndex = -1;
    private int oldSelectedRepositoryIndex = -1;
    private int selectedChoiceIndex = -1;
    private int selectedRestoreChoiceIndex = -1;

    private int selectedTabbedPaneIndex;


    /**
     * Initializes this view.
     */
    public void initialize() throws Exception {


        try {
            super.initialize();
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);

            this.setDialogBounds(this.createDialogBounds());
            this.setRestoreOptionPanel(this.createRestoreOptionPanel());
            this.setLayout(new BorderLayout());
            this.add(this.getRestoreOptionPanel(), BorderLayout.WEST);
            this.setTitle("Restore Options");
            this.setResizable(false);

        } catch (Exception e) {

            System.out.println("Fehler: " + e);

        }

    }

    /**
     * Create the MenuBar
     * @return the MenuBar
     */
    public ResMenuBar createMenuBar() {

        ResMenuBar mb = new ResMenuBar();
        ResMenu menu1 = new ResMenu(); // Window

        ResMenuItem menuItem11 = new ResMenuItem();

        try {

            menuItem11.setText("Close");
            menuItem11.setActionCommand(Restore.RESTORE_OPTION_WINDOW_CLOSE_WINDOW_ID);
            menuItem11.setEnabled(true);
            menuItem11.addActionListener((Restore) getController());

            menu1.setText("Window");
            menu1.add(menuItem11);
            mb.add(menu1);

        } catch (Exception e) {

            System.out.println("There was an error in the class BackupOption: " + e);

        }
        ;

        return mb;

    }

    /**
     * Create the Panel
     * @return the Panel
     */
    public JPanel createRestoreOptionPanel() {

        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        JPanel p5 = new JPanel();
        JPanel p6 = new JPanel();
        JPanel p7 = new JPanel();
        JPanel p8 = new JPanel();
        JPanel p9 = new JPanel();
        JPanel p10 = new JPanel();

        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        // create JLists and ScrollPanes
        repositoryList = new JList();
        choiceList = new JList();
        restoreChoiceList = new JList();
        JScrollPane scroll1;
        JScrollPane scroll2;
        JScrollPane scroll3;

        // create a JTabbedPane
        this.setRestoreOptionTabbedPane(new JTabbedPane());

        // create labels
        ResLabel l = new ResLabel();
        ResLabel l2 = new ResLabel();
        ResLabel l3 = new ResLabel();
        ResLabel l4 = new ResLabel();

        // create a TextField
        restorePathTextField = new JTextField();

        // create buttons
        ResButton b1 = new ResButton();
        ResButton b2 = new ResButton();
        ResButton b3 = new ResButton();
        ResButton b4 = new ResButton();
        ResButton b5 = new ResButton();

        // create RadioButtons
        JRadioButton rb1 = new JRadioButton("Take all");
        JRadioButton rb2 = new JRadioButton("Take selected");
        JRadioButton rb3 = new JRadioButton("Remove all");
        JRadioButton rb4 = new JRadioButton("Remove selected");

        try {

            p1.setLayout(new FlowLayout(FlowLayout.LEFT));
            p2.setLayout(new BorderLayout());
            p3.setLayout(new GridLayout(3, 1));
            p4.setLayout(new FlowLayout(FlowLayout.LEFT));
            p5.setLayout(new GridLayout(2, 1));
            p6.setLayout(new BorderLayout());
            p8.setLayout(new GridLayout(8, 1));
            p9.setLayout(new BorderLayout());

            p2.setBorder(BorderFactory.createTitledBorder("Repository"));
            p8.setBorder(BorderFactory.createTitledBorder("Edit"));
            p9.setBorder(BorderFactory.createTitledBorder("Choice"));
            p7.setLayout(gbl);
            p10.setLayout(gbl);

            l.setText("Restore path");
            l2.setText(" ");
            l3.setText(" ");
            l4.setText(" ");

            this.getRestorePathTextField().setColumns(36);

            b1.setText("Save");
            b1.addActionListener((Restore) getController());
            b1.setActionCommand(Restore.RESTORE_OPTION_WINDOW_SAVE_ID);

            b2.setText("Load repository");
            b2.addActionListener((Restore) getController());
            b2.setActionCommand(Restore.RESTORE_OPTION_WINDOW_LOAD_REPOSITORY_ID);
            b2.setToolTipText("Load an existing repository...");

            b3.setText("Execute");
            b3.addActionListener((Restore) getController());
            b3.setActionCommand(Restore.RESTORE_OPTION_WINDOW_EXECUTE_ID);

            b4.setText("Select path");
            b4.addActionListener((Restore) getController());
            b4.setActionCommand(Restore.RESTORE_OPTION_WINDOW_SELECT_PATH_ID);
            b4.setToolTipText("Select a restore path if necessary...");

            b5.setText("Set default");
            b5.addActionListener((Restore) getController());
            b5.setActionCommand(Restore.RESTORE_OPTION_WINDOW_SET_DEFAULT_ID);
            b5.setToolTipText("Set the restore path to <default>...");

            rb1.setActionCommand(Restore.RESTORE_OPTION_WINDOW_TAKE_ALL_ID);
            rb2.setActionCommand(Restore.RESTORE_OPTION_WINDOW_TAKE_SELECTED_ID);
            rb3.setActionCommand(Restore.RESTORE_OPTION_WINDOW_REMOVE_ALL_ID);
            rb4.setActionCommand(Restore.RESTORE_OPTION_WINDOW_REMOVE_SELECTED_ID);
            rb1.setToolTipText("Take over the Choice to the RestoreChoice...");
            rb2.setToolTipText("Take over a selected file or folder to the RestoreChoice...");
            rb3.setToolTipText("Remove all files or folders from the RestoreChoice...");
            rb4.setToolTipText("Remove a selected file or a folder from the RestoreChoice...");

            group = new ButtonGroup();
            group.add(rb1);
            group.add(rb2);
            group.add(rb3);
            group.add(rb4);

            getRepositoryList().setBackground(getBackground());
            getChoiceList().setBackground(getBackground());
            getChoiceList().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            getRestoreChoiceList().setBackground(getBackground());
            getRepositoryList().addListSelectionListener((ListSelectionListener) getController());
            getChoiceList().addListSelectionListener((ListSelectionListener) getController());
            getRestoreChoiceList().addListSelectionListener((ListSelectionListener) getController());

            scroll1 = new JScrollPane(repositoryList);
            scroll1.setPreferredSize(new Dimension(150, 120));

            scroll2 = new JScrollPane(choiceList);
            scroll2.setPreferredSize(new Dimension(375, 181));

            scroll3 = new JScrollPane(restoreChoiceList);
            scroll3.setPreferredSize(new Dimension(375, 181));

            p2.add(scroll1, BorderLayout.CENTER);
            p2.setPreferredSize(new Dimension(170, 156));

            p3.add(b2);
            p3.add(b5);

            p1.add(p2);
            p1.add(p3);

            p5.add(l);
            p5.add(this.getRestorePathTextField());

            p6.add(b4, BorderLayout.CENTER);
            p6.add(l2, BorderLayout.NORTH);

            p4.add(p5);
            p4.add(p6);

            p8.add(l3);
            p8.add(rb2);
            p8.add(rb1);
            p8.add(rb4);
            p8.add(rb3);
            p8.add(l4);
            p8.add(b3);
            p8.add(b1);

            getRestoreOptionTabbedPane().addTab("Choice", scroll2);
            getRestoreOptionTabbedPane().addTab("RestoreChoice", scroll3);

            p9.add(getRestoreOptionTabbedPane());

            gbc = makegbc(0, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p8, gbc);

            p7.add(p8);

            gbc = makegbc(1, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p9, gbc);

            p7.add(p9);

            gbc = makegbc(0, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p1, gbc);

            p10.add(p1);

            gbc = makegbc(0, 1, 1, 1);
            gbc.anchor = GridBagConstraints.WEST;
            gbc.weightx = 1;
            gbl.setConstraints(p4, gbc);

            p10.add(p4);

            gbc = makegbc(0, 2, 1, 1);
            gbc.anchor = GridBagConstraints.WEST;
            gbc.weightx = 1;
            gbl.setConstraints(p7, gbc);

            p10.add(p7);

        } catch (Exception e) {

            System.out.println("There was an error in the class RestoreOption: " + e);

        }
        ;

        return p10;

    }


    public void setRestoreOptionTabbedPane(JTabbedPane tabbedPane) {

        this.tabbedPane = tabbedPane;

    }

    public JTabbedPane getRestoreOptionTabbedPane() {

        return this.tabbedPane;

    }


    public void setSelectedRepositoryIndex(int index) {

        this.selectedRepositoryIndex = index;

    }


    public void updateSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = this.selectedRepositoryIndex;
        this.selectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getSelectedRepositoryIndex() {

        return this.selectedRepositoryIndex;

    }


    public void setOldSelectedRepositoryIndex(int index) {

        this.oldSelectedRepositoryIndex = index;

    }


    public void updateOldSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getOldSelectedRepositoryIndex() {

        return this.oldSelectedRepositoryIndex;

    }


    public void setSelectedChoiceIndex(int index) {

        this.selectedChoiceIndex = index;

    }


    public void updateSelectedChoiceIndex() {

        this.selectedChoiceIndex = getChoiceList().getSelectedIndex();

    }


    public int getSelectedChoiceIndex() {

        return this.selectedChoiceIndex;

    }


    public void setSelectedRestoreChoiceIndex(int index) {

        this.selectedRestoreChoiceIndex = index;

    }


    public void updateSelectedRestoreChoiceIndex() {

        this.selectedRestoreChoiceIndex = getRestoreChoiceList().getSelectedIndex();

    }


    public int getSelectedTabbedPaneIndex() {

        return this.selectedTabbedPaneIndex;

    }


    public void setSelectedTabbedPaneIndex(int index) {

        this.selectedTabbedPaneIndex = index;

    }


    public void updateSelectedTabbedPaneIndex() {

        this.selectedTabbedPaneIndex = this.getRestoreOptionTabbedPane().getSelectedIndex();

    }


    public int getSelectedRestoreChoiceIndex() {

        return this.selectedRestoreChoiceIndex;

    }


    public void setRestoreOptionPanel(JPanel restoreOptionPanel) {

        this.restoreOptionPanel = restoreOptionPanel;

    }


    public JPanel getRestoreOptionPanel() {


        return this.restoreOptionPanel;
    }

    /**
     * Determine the position of an graphical element.
     * @return the determined object
     */
    private GridBagConstraints makegbc(int x, int y, int width, int height) {

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(1, 1, 1, 1);
        return gbc;

    }

    /**
     * Determine the size of the window.
     * @return the window with its special size.
     */
    public Rectangle createDialogBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 580;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 560;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new Rectangle(x, y, w, h);
    }


    public JList getRepositoryList() {

        return this.repositoryList;

    }


    public void setRepositoryList(JList list1) {

        this.repositoryList = list1;

    }

    /**
     * Update the Repository List.
     *
     */
    public void updateRepositoryList() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();
            getRepositoryList().setEnabled(true);
            getRepositoryList().setListData(model.getRepositoryVector());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }

    /**
     * Update the Restore Path TextField.
     *
     */
    public void updateRestorePathTextField() throws Exception {
        try {

            RestoreModel model = (RestoreModel) getModel();

            this.getRestorePathTextField().setText(model.getRestorePathString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    public void setRestorePathTextField(JTextField jtf) {

        this.restorePathTextField = jtf;

    }


    public JTextField getRestorePathTextField() {

        return this.restorePathTextField;

    }


    public JList getChoiceList() {

        return this.choiceList;

    }


    public void setChoiceList(JList list1) {

        this.choiceList = list1;

    }

    /**
     * Update the Choice List.
     *
     */
    public void updateChoiceList() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            getChoiceList().setEnabled(true);
            getChoiceList().setListData(model.getChoiceVector());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    public JList getRestoreChoiceList() {

        return this.restoreChoiceList;

    }


    public void setRestoreChoiceList(JList list1) {

        this.restoreChoiceList = list1;

    }

    /**
     * Update the RestoreChoice List.
     *
     */
    public void updateRestoreChoiceList() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            getRestoreChoiceList().setListData(model.getRestoreChoiceVector());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    /**
     * Finalizes this view.
     */

    public void finalizz() throws Exception {

        try {

        } finally {

            super.finalizz();
        }
    }

}
