/*
 * $RCSfile: RestoreLauncher.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.application.common.main.*;

/**
 * This class represents the restore application launcher.
 *
 * @version $Revision: 1.2 $ $Date: 2003/01/07 16:20:44 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class RestoreLauncher extends Object {

    /**
     * The static method launches the application.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        try {

            ApplicationRunner r = new ApplicationRunner();

            if (r != null) {

                r.createApplication("org.resmedicinae.application.healthcare.restore.Restore", args, null);

            } else {

                throw new NullPointerException("Could not create application. The application runner is null.");
            }

        } catch (Exception e) {

            System.out.println("Could not launch application. Undiscovered exception:\n");
            e.printStackTrace();
        }
    }
}

