/*
 * $RCSfile: Restore.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.application.common.basic.*;
import org.resmedicinae.resmedlib.component.view.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.io.*;

/**
 * This class represents a restore application. The class Restore is the Controller
 * of the Backup Tool. The controller handles all events. For example button events
 * or list events.
 *
 * @version $Revision: 1.12 $ $Date: 2003/01/07 16:20:42 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

public class Restore extends BasicApplication implements ActionListener {

    //
    // Constants.
    //

    /* The RestoreView */
    // The RestoreView represents the window, wich occurs first after launching

    // Menu System
    public static final String BACKUP_SYSTEM_ID = "Start Backup";
    public static final String RESTORE_SYSTEM_ID = "Start Restore";
    public static final String EXIT_SYSTEM_ID = "Exit";

    // Menu Options
    public static final String BACKUP_OPTION_ID = "Backup";
    public static final String RESTORE_OPTION_ID = "Restore";
    public static final String STORING_OPTION_ID = "Storing";

    // Menu Help
    public static final String ABOUT_HELP_ID = "About";

    // The Buttons
    public static final String BACKUP_ID = "BACKUP";
    public static final String LOAD_REPOSITORY_ID = "LOAD REPOSITORY";
    public static final String RESTORE_ID = "RESTORE";

    /* The Backup Option Window */
    // The Buttons
    public static final String BACKUP_OPTION_WINDOW_NEW_ID = "New";
    public static final String BACKUP_OPTION_WINDOW_SAVE_ID = "Save";
    public static final String BACKUP_OPTION_WINDOW_DELETE_ID = "Delete";
    public static final String BACKUP_OPTION_WINDOW_SELECT_PATH_ID = "Select path";
    public static final String BACKUP_OPTION_WINDOW_EXECUTE_ID = "Execute";
    public static final String BACKUP_OPTION_WINDOW_LOAD_REPOSITORY_ID = "Load repository";

    // The RadioButtons
    public static final String BACKUP_OPTION_WINDOW_ADD_FILE_ID = "Add file";
    public static final String BACKUP_OPTION_WINDOW_ADD_FOLDER_ID = "Add folder";
    public static final String BACKUP_OPTION_WINDOW_ADD_FOLDER_RECURSIVE_ID = "Add folder recursive";
    public static final String BACKUP_OPTION_WINDOW_REMOVE_SELECTED_ID = "Remove slected";
    public static final String BACKUP_OPTION_WINDOW_REMOVE_ALL_ID = "Remove all";

    // The menu Window
    public static final String BACKUP_OPTION_WINDOW_CLOSE_WINDOW_ID = "Close";

    /* The Restore Option Window */
    // The Buttons
    public static String RESTORE_OPTION_WINDOW_SAVE_ID = "_Save";
    public static final String RESTORE_OPTION_WINDOW_LOAD_REPOSITORY_ID = "_Load repository";
    public static final String RESTORE_OPTION_WINDOW_SELECT_PATH_ID = "_Select path";
    public static final String RESTORE_OPTION_WINDOW_EXECUTE_ID = "_Execute";
    public static final String RESTORE_OPTION_WINDOW_SET_DEFAULT_ID = "Set default";

    // The RadioButtons
    public static final String RESTORE_OPTION_WINDOW_TAKE_ALL_ID = "Take all";
    public static final String RESTORE_OPTION_WINDOW_TAKE_SELECTED_ID = "Take selected";
    public static final String RESTORE_OPTION_WINDOW_REMOVE_ALL_ID = "_Remove all";
    public static final String RESTORE_OPTION_WINDOW_REMOVE_SELECTED_ID = "_Remove selected";

    // The menu Window
    public static final String RESTORE_OPTION_WINDOW_CLOSE_WINDOW_ID = "_Close";

    /* The Storing Option Window */
    // The Buttons
    public static final String STORING_OPTION_WINDOW_SAVE_ID = "__Save";
    public static final String STORING_OPTION_WINDOW_CANCEL_ID = "Cancel";
    public static final String STORING_OPTION_WINDOW_SELECT_PATH_ID = "__Select path";

    // The menu Window
    public static final String STORING_OPTION_WINDOW_CLOSE_WINDOW_ID = "__Close";

    public static String inputValue;

    /**
     * Creates a model.
     *
     * @return the model
     * @exception NullPointerException if the model is null
     */
    public Object createModel() throws Exception {

        RestoreModel m = new RestoreModel();
        if (m != null) {

            m.initialize();

        } else {

            throw new NullPointerException("Could not create model. The model is null.");
        }

        return (Object) m;
    }


    /**
     * Creates a view.
     *
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception, NullPointerException {

        RestoreView v = new RestoreView();

        if (v != null) {

            v.setController(this);
            v.configure(getConfigurationManager());
            v.initialize();

        } else {

            throw new NullPointerException("Could not create view. The view is null.");
        }

        return v;
    }


    /**
     * Initialize the view.
     */
    public void initialize() throws Exception {

        super.initialize();

        RestoreModel model = (RestoreModel) getModel();

        if (model != null) {

            model.setView((RestoreView) getView());

        } else {

            System.out.println("NO MODEL FOUND!");
        }

        RestoreView view = (RestoreView) getView();

        // set other windows
        view.setBackupOption(view.createBackupOption());
        view.setRestoreOption(view.createRestoreOption());
        view.setStoringOption(view.createStoringOption());

    }

    /**
     * Handles the action event.
     *
     * @param evt the action event
     */
    public void actionPerformed(ActionEvent evt) {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if (evt.getActionCommand() == Restore.BACKUP_SYSTEM_ID) {

            System.out.println("Menu SYSTEM-Backup was chosen...");

            if (this.checkSelectedRepositoryIndexAtMainView() == false) {

                model.backupCopy();

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_SYSTEM_ID) {

            System.out.println("Menu SYSTEM-Restore was chosen...");

            if (this.checkSelectedRepositoryIndexAtMainView() == false) {

                model.restoreCopy();

            }

        } else if (evt.getActionCommand() == Restore.EXIT_SYSTEM_ID) {

            System.out.println("Menu SYSTEM-Exit was chosen...");
            System.exit(0);

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_ID) {

            try {

                show(((RestoreView) view).getBackupOption());

            } catch (Exception e) {

                System.out.println("Fehler" + e);

            }

            System.out.println("Menu OPTIONS-Backup was chosen...");

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_ID) {

            try {

                show(view.getRestoreOption());

            } catch (Exception e) {

                System.out.println("Fehler" + e);

            }

            System.out.println("Menu OPTIONS-Restore was chosen...");

        } else if (evt.getActionCommand() == Restore.STORING_OPTION_ID) {

            try {

                show(view.getStoringOption());

            } catch (Exception e) {

                System.out.println("Fehler" + e);

            }

            System.out.println("Menu OPTIONS-Storing was chosen...");

        } else if (evt.getActionCommand() == Restore.ABOUT_HELP_ID) {

            System.out.println("Menu HELP-About was chosen...");

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_CLOSE_WINDOW_ID) {

            System.out.println("Menu WINDOW-Close at the Backup option window was chosen...");

            try {

                if (view.getBackupOption().getSelectedRepositoryIndex() != -1) {

                    if (this.createSaveMessage() == 0) {

                        String write = model.getRepositoryVector().elementAt(view.getBackupOption().getSelectedRepositoryIndex()).toString();
                        model.writeToRepositoryFile(write);

                        System.out.println("The file " + write + " was stored.");

                    }

                }

                hide(view.getBackupOption());

            } catch (Exception e) {

                e.printStackTrace();

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_CLOSE_WINDOW_ID) {

            System.out.println("Menu WINDOW-Close at the Restore option window was chosen...");

            try {

                if (view.getRestoreOption().getSelectedRepositoryIndex() != -1) {

                    if (this.createSaveMessage() == 0) {

                        String write = model.getRepositoryVector().elementAt(view.getRestoreOption().getSelectedRepositoryIndex()).toString();
                        model.writeToRepositoryFile(write);

                        System.out.println("The file " + write + " was stored.");

                    }

                }

                hide(view.getRestoreOption());

            } catch (Exception e) {

                e.printStackTrace();

            }

        } else if (evt.getActionCommand() == Restore.STORING_OPTION_WINDOW_CLOSE_WINDOW_ID) {

            System.out.println("Menu WINDOW-Close at the Storing option window was chosen...");

            try {

                hide(view.getStoringOption());

            } catch (Exception e) {

                e.printStackTrace();

            }

        } else if (evt.getActionCommand() == Restore.BACKUP_ID) {

            System.out.println("Button BACKUP was clicked...");

            if (this.checkSelectedRepositoryIndexAtMainView() == false) {

                model.backupCopy();

            }


        } else if (evt.getActionCommand() == Restore.RESTORE_ID) {

            System.out.println("Button RESTORE was clicked...");

            if (this.checkSelectedRepositoryIndexAtMainView() == false) {

                model.restoreCopy();

            }

        } else if (evt.getActionCommand() == Restore.LOAD_REPOSITORY_ID) {

            try {

                this.loadRepository();

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

            System.out.println("Button LOAD REPOSITORY was clicked....");

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_NEW_ID) {

            System.out.println("Button NEW at the Backup option window was clicked...");

            try {

                if (model.getStoringPathString().length() == 0) {

                    model.setRepositoryVectorLoadedFromFile(true);
                    System.out.println("Please input a vaild Storing Path!");
                    JFrame frame3 = new JFrame();
                    JOptionPane.showMessageDialog(frame3, "Please input a vaild Storing Path!", "Message", JOptionPane.INFORMATION_MESSAGE);

                } else {

                    String st;
                    JFrame frame = new JFrame();
                    if (frame != null) {

                        st = JOptionPane.showInputDialog(frame, "Please input a new repository file", "Message", JOptionPane.INFORMATION_MESSAGE);

                        if (st != null) {

                            if (st.length() == 0) {

                                System.out.println("Please insert a meaningful value!");
                                JFrame frame1 = new JFrame();

                                if (frame1 != null) {

                                    JOptionPane.showMessageDialog(frame1, "Please insert a meaningful value!", "Message", JOptionPane.ERROR_MESSAGE);

                                } else {

                                    throw new NullPointerException("Could not create frame. The frame is null.");
                                }

                            } else {

                                model.addToRepositoryVector(st);

                            }

                        } else {

                            System.out.println("No value was added to the repository.");
                        }

                    } else {

                        System.out.println("Could not create frame. The frame is null.");

                    }
                }


            } catch (Exception e) {

                e.printStackTrace();

            }


        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_SAVE_ID) {

            System.out.println("Button SAVE at the Backup option window was clicked...");


            if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                try {

                    String write = model.getRepositoryVector().elementAt(view.getBackupOption().getSelectedRepositoryIndex()).toString();
                    model.writeToRepositoryFile(write);

                    System.out.println("The file " + write + " was stored.");

                } catch (Exception e) {

                    System.out.println("Fehler" + e);

                }

            }

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_DELETE_ID) {

            System.out.println("Button DELETE at the Backup option window was clicked...");
            try {

                model.removeFromRepositoryVector();

            } catch (Exception e) {

                e.printStackTrace();

            }

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_LOAD_REPOSITORY_ID) {

            System.out.println("Button LOAD REPOSITORY at the Backup option window was clicked...");

            try {

                this.loadRepository();

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_SELECT_PATH_ID) {

            System.out.println("Button SELECT PATH at the Backup option window was clicked...");

            if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                try {

                    view.setOpenBackupPathDialog(view.createOpenBackupPathDialog());

                } catch (Exception e) {

                    System.out.println("Fehler" + e);

                }

            }


        } else if (evt.getActionCommand() == Restore.BACKUP_OPTION_WINDOW_EXECUTE_ID) {

            System.out.println("Button EXECUTE at the Backup option window was clicked...");
            String str = this.getRadioButton(BackupOption.group);

            if (str == Restore.BACKUP_OPTION_WINDOW_ADD_FILE_ID) {

                if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                    try {

                        view.setOpenFileDialog(view.createOpenFileDialog());
                        System.out.println("A file was added to the Repository.");

                    } catch (Exception e) {

                        System.out.println("Fehler" + e);

                    }

                }

            }

            if (str == Restore.BACKUP_OPTION_WINDOW_ADD_FOLDER_ID) {

                if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                    try {

                        view.setOpenFolderDialog(view.createOpenFolderDialog());
                        System.out.println("A folder was added to the Repository.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }

            }


            if (str == Restore.BACKUP_OPTION_WINDOW_ADD_FOLDER_RECURSIVE_ID) {

                if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                    try {

                        view.setOpenFolderRecursive(view.createOpenFolderRecursiveDialog());
                        System.out.println("A folder (recursive) was added to the Repository.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }

            }


            if (str == Restore.BACKUP_OPTION_WINDOW_REMOVE_SELECTED_ID) {

                if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                    try {

                        model.removeSelectedFromChoiceVector();
                        System.out.println("The slected file or folder was removed from the Repository.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }

            }

            if (str == Restore.BACKUP_OPTION_WINDOW_REMOVE_ALL_ID) {

                if (this.checkSelectedRepositoryIndexAtBackupOption() == false) {

                    try {

                        model.removeAllFromChoiceVector();
                        System.out.println("All files and folders were removed from the Repository.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_SAVE_ID) {

            System.out.println("Button SAVE at the Restore option window was clicked...");

            if (this.checkSelectedRepositoryIndexAtRestoreOption() == false) {

                try {

                    String write = model.getRepositoryVector().elementAt(view.getRestoreOption().getRepositoryList().getSelectedIndex()).toString();
                    model.writeToRepositoryFile(write);

                    System.out.println("The file " + write + " was stored.");

                } catch (Exception e) {

                    System.out.println("Fehler" + e);

                }

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_LOAD_REPOSITORY_ID) {

            System.out.println("Button LOAD REPOSITORY at the Restore option window was clicked...");

            try {

                this.loadRepository();

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_SELECT_PATH_ID) {

            System.out.println("Button SELECT PATH at the Restore option window was clicked...");

            if (this.checkSelectedRepositoryIndexAtRestoreOption() == false) {

                view.setOpenRestorePathDialog(view.createOpenRestorePathDialog());
            }


        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_SET_DEFAULT_ID) {

            System.out.println("Button SET DEFAULT at the Restore option window was clicked...");

            if (this.checkSelectedRepositoryIndexAtRestoreOption() == false) {

                model.setRestorePathToDefault();

            }

        } else if (evt.getActionCommand() == Restore.RESTORE_OPTION_WINDOW_EXECUTE_ID) {

            System.out.println("Button EXECUTE at the Restore option window was clicked...");
            String str = getRadioButton(RestoreOption.group);

            if (this.checkSelectedRepositoryIndexAtRestoreOption() == false) {

                if (str == Restore.RESTORE_OPTION_WINDOW_TAKE_SELECTED_ID) {

                    if (model.getBackupPathString().length() > 0) {

                        if (model.getRestorePathString().length() > 0) {

                            try {

                                if (view.getRestoreOption().getRestoreOptionTabbedPane().getSelectedIndex() == 1) {

                                    model.notPossibleRestoreOptionRestoreChoiceTabbedPane();

                                } else {

                                    model.addToRestoreChoiceVector();
                                    System.out.println("The selected entry in the Choice was added to the RestoreChoice.");

                                }

                            } catch (Exception e) {

                                e.printStackTrace();

                            }

                        } else {

                            System.out.println("Please chose a Restore Path first!");
                            JFrame frame = new JFrame();
                            JOptionPane.showMessageDialog(frame, "Please chose a Restore Path first!", "Message", JOptionPane.ERROR_MESSAGE);

                        }

                    } else {

                        System.out.println("Please chose a Backup Path first!");
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, "Please chose a Backup Path first!", "Message", JOptionPane.ERROR_MESSAGE);

                    }

                }

                if (str == Restore.RESTORE_OPTION_WINDOW_TAKE_ALL_ID) {

                    if (model.getBackupPathString().length() > 0) {

                        if (model.getRestorePathString().length() > 0) {

                            try {

                                if (view.getRestoreOption().getRestoreOptionTabbedPane().getSelectedIndex() == 1) {

                                    model.notPossibleRestoreOptionRestoreChoiceTabbedPane();
                                    System.out.println("All entries in the Choice were added to the RestoreChoice.");

                                } else {

                                    model.takeAllToRestoreChoiceVector();
                                }

                            } catch (Exception e) {

                                e.printStackTrace();

                            }

                        } else {

                            System.out.println("Please chose a Restore Path first!");
                            JFrame frame = new JFrame();
                            JOptionPane.showMessageDialog(frame, "Please chose a Restore Path first!", "Message", JOptionPane.ERROR_MESSAGE);

                        }

                    } else {

                        System.out.println("Please chose a Backup Path first!");
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, "Please chose a Backup Path first!", "Message", JOptionPane.ERROR_MESSAGE);

                    }

                }

                if (str == Restore.RESTORE_OPTION_WINDOW_REMOVE_SELECTED_ID) {

                    try {

                        model.removeSelectedFromRestoreChoiceVector();
                        System.out.println("The selected entry in the RestoreChoice was removed.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }


                if (str == Restore.RESTORE_OPTION_WINDOW_REMOVE_ALL_ID) {

                    try {

                        model.removeAllFromRestoreChoiceVector();
                        System.out.println("All entries in the RestoreChoice were removed.");

                    } catch (Exception e) {

                        e.printStackTrace();

                    }

                }

            }

        } else if (evt.getActionCommand() == Restore.STORING_OPTION_WINDOW_SELECT_PATH_ID) {

            try {

                view.setOpenStoringPathDialog(view.createOpenStoringPathDialog());
                System.out.println("A place, where the Restore Information can be stored was chosen.");

            } catch (Exception e) {

                e.printStackTrace();

            }

            System.out.println("Button SELECT PATH at the Storing option window was clicked...");

        } else if (evt.getActionCommand() == Restore.STORING_OPTION_WINDOW_SAVE_ID) {

            System.out.println("Button SAVE at the Storing option window was clicked...");

            File file = new File(model.getStoringPathString());

            if ((model.getStoringPathString().length() != 0) && (file.isDirectory())) {

                model.writeRepositoryVectorToFile();

            } else {

                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "Please select a valid Storing Path.", "Message", JOptionPane.ERROR_MESSAGE);
                System.out.println("Please select a valid Storing Path.");

            }

        } else if (evt.getActionCommand() == Restore.STORING_OPTION_WINDOW_CANCEL_ID) {

            try {

                hide(view.getStoringOption());

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

            System.out.println("Button CANCEL at the Storing option window was clicked...");

        }

    }


    /**
     * Handles the list event.
     *
     * @param e the list event
     */
    public void valueChanged(ListSelectionEvent e) {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if (e.getValueIsAdjusting() == false) {

            System.out.println("A ListEvent happened...");

            ((RestoreView) getView()).getBackupOption().updateSelectedRepositoryIndex();
            ((RestoreView) getView()).getBackupOption().updateSelectedChoiceIndex();
            ((RestoreView) getView()).getRestoreOption().updateSelectedRepositoryIndex();
            ((RestoreView) getView()).getRestoreOption().updateSelectedChoiceIndex();
            ((RestoreView) getView()).getRestoreOption().updateSelectedRestoreChoiceIndex();
            ((RestoreView) getView()).updateSelectedRepositoryIndex();

            if (view.getBackupOption().getOldRepositoryVectorSize() <= view.getBackupOption().getRepositoryVectorSize()) {

                if (view.getBackupOption().getOldSelectedRepositoryIndex() != view.getBackupOption().getSelectedRepositoryIndex()) {

                    System.out.println("Another entry at the Backup Option Window was selected...");

                    try {

                        int oldSelectedRepositoryIndex = view.getBackupOption().getOldSelectedRepositoryIndex();
                        int selectedRepositoryIndex = view.getBackupOption().getSelectedRepositoryIndex();


                        if ((oldSelectedRepositoryIndex == -1) && (selectedRepositoryIndex > -1)) {

                            // No item was selected before (after adding a new repository file). The user selected another item.
                            String read = model.getRepositoryVector().elementAt(view.getBackupOption().getSelectedRepositoryIndex()).toString();
                            model.readFromRepositoryFile(read);

                        }

                        if ((oldSelectedRepositoryIndex > -1) && (selectedRepositoryIndex > -1)) {

                            // A item is selected and the user selected another item.
                            String write = model.getRepositoryVector().elementAt(oldSelectedRepositoryIndex).toString();
                            model.writeToRepositoryFile(write);

                            String read = model.getRepositoryVector().elementAt(view.getBackupOption().getSelectedRepositoryIndex()).toString();
                            model.readFromRepositoryFile(read);

                        }


                        if ((oldSelectedRepositoryIndex > -1) && (selectedRepositoryIndex == -1)) {

                            // A item is selected and the user added a new repository file.
                            String write = model.getRepositoryVector().elementAt(oldSelectedRepositoryIndex).toString();

                            int index = model.getRepositoryVector().size() - 1;

                            String read = model.getRepositoryVector().elementAt(index).toString();

                            model.writeToRepositoryFile(write);
                            model.readFromRepositoryFile(read);

                        }


                    } catch (Exception ex) {

                        ex.printStackTrace();

                    }

                }

            }

            if (view.getRestoreOption().getOldSelectedRepositoryIndex() != view.getRestoreOption().getSelectedRepositoryIndex()) {

                System.out.println("Another entry at the Restore Option Window was selected...");

                try {

                    int oldSelectedRepositoryIndex = view.getRestoreOption().getOldSelectedRepositoryIndex();
                    int selectedRepositoryIndex = view.getRestoreOption().getSelectedRepositoryIndex();

                    System.out.println("old: " + view.getRestoreOption().getOldSelectedRepositoryIndex());
                    System.out.println("new: " + view.getRestoreOption().getSelectedRepositoryIndex());

                    if ((oldSelectedRepositoryIndex == -1) && (selectedRepositoryIndex > -1)) {

                        String read = model.getRepositoryVector().elementAt(view.getRestoreOption().getSelectedRepositoryIndex()).toString();
                        model.readFromRepositoryFile(read);

                    }

                    if ((oldSelectedRepositoryIndex > -1) && (selectedRepositoryIndex > -1)) {

                        String write = model.getRepositoryVector().elementAt(oldSelectedRepositoryIndex).toString();
                        String read = model.getRepositoryVector().elementAt(view.getRestoreOption().getSelectedRepositoryIndex()).toString();

                        model.writeToRepositoryFile(write);
                        model.readFromRepositoryFile(read);
                    }


                } catch (Exception ex) {

                    ex.printStackTrace();

                }

            }

            if (view.getOldSelectedRepositoryIndex() != view.getSelectedRepositoryIndex()) {

                System.out.println("Another entry at the Main View was selected...");

                try {

                    String read = model.getRepositoryVector().elementAt(view.getSelectedRepositoryIndex()).toString();
                    model.readFromRepositoryFile(read);

                } catch (Exception ex) {

                    ex.printStackTrace();

                }


            }

        }

    }


    /**
     * This method checks, if a repository was created and a repository file was selected before the user starts to modify a choice. (At the Backup Option Window).
     *
     * @return true: if there are no selected repository file or no repository. Returns false, if the user created a repoitory an selected a repository file.
     *
     */
    public boolean checkSelectedRepositoryIndexAtBackupOption() {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if ((model.getRepositoryVector().isEmpty() == true) || (view.getBackupOption().getSelectedRepositoryIndex() == -1)) {

            System.out.println("Please select or create a repository file first!");

            JFrame frame = new JFrame();

            if (frame != null) {

                JOptionPane.showMessageDialog(frame, "Please select or create a repository file first!", "Message", JOptionPane.ERROR_MESSAGE);

                return true;

            } else {

                throw new NullPointerException("Could not create frame. The frame is null.");

            }
        }

        return false;
    }


    /**
     * This method checks, if a repository was created and a repository file was selected before the user starts to modify a RestoreChoice. (At the Restore Option Window).
     *
     * @return true: if there are no selected repository file or no repository. Returns false, if the user created a repoitory an selected a repository file.
     *
     */
    public boolean checkSelectedRepositoryIndexAtRestoreOption() {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if ((model.getRepositoryVector().isEmpty() == true) || (view.getRestoreOption().getSelectedRepositoryIndex() == -1)) {

            System.out.println("Please select or create a repository file first!");

            JFrame frame = new JFrame();

            if (frame != null) {

                JOptionPane.showMessageDialog(frame, "Please select or create a repository file first!", "Message", JOptionPane.ERROR_MESSAGE);

                return true;

            } else {

                throw new NullPointerException("Could not create frame. The frame is null.");

            }

        }

        return false;

    }


    /**
     * This method checks, if a repoitory was created and a repository file was selected before the user starts the backup or restore process (At the Main View).
     *
     * @return true: if there are no selected repository file or no repository. Returns false, if the user created a repoitory an selected a repository file.
     *
     */
    public boolean checkSelectedRepositoryIndexAtMainView() {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if (model.getRepositoryVector().isEmpty() == true) {

            System.out.println("Please load or create a repository first!");

            JFrame frame = new JFrame();

            if (frame != null) {

                JOptionPane.showMessageDialog(frame, "Please load or create a repository first!", "Message", JOptionPane.ERROR_MESSAGE);
                return true;
            } else {

                throw new NullPointerException("Could not create frame. The frame is null.");
            }
        }

        if (view.getSelectedRepositoryIndex() == -1) {

            System.out.println("Please select a repository file first!");

            JFrame frame = new JFrame();

            if (frame != null) {

                JOptionPane.showMessageDialog(frame, "Please select a repository file first!", "Message", JOptionPane.ERROR_MESSAGE);

                return true;

            } else {

                throw new NullPointerException("Could not create frame. The frame is null.");

            }

        }

        return false;
    }


    /**
     * In this method a new repository will be loaded.
     *
     */
    public void loadRepository() {

        RestoreView view = (RestoreView) getView();
        RestoreModel model = (RestoreModel) getModel();

        if (model.getRepositoryVectorLoadedFromFile() == false) {

            view.setOpenInformationFileDialog(view.createOpenInformationFileDialog());

        } else {

            JFrame frame = new JFrame();
            int count = JOptionPane.showConfirmDialog(frame, "The Repository was loaded. Do you want to load it again?", "Message", JOptionPane.YES_NO_OPTION);

            if (count == 0) {

                view.setOpenInformationFileDialog(view.createOpenInformationFileDialog());

            }

        }

    }


    /**
     * Create a JOptionPane.
     *
     */
    public int createSaveMessage() {


        JFrame frame = new JFrame();
        int value = 0;

        try {

            value = JOptionPane.showConfirmDialog(frame, "Do you want to save possible changes?", "Message", JOptionPane.YES_NO_OPTION);


        } catch (Exception e) {
            System.out.println("There was an error in the method createSaveMessage() in the class Restore.");
        }
        ;

        return value;
    }


    /**
     * This method checks, which RadioButton the user has selcted in a defined ButtonGroup.
     * @param group the ButtonGroup, in which the user has selected a RadioButton
     * @return the selected RadioButton
     *
     */
    public String getRadioButton(ButtonGroup group) {

        String str;
        ButtonModel selected;
        JFrame jframe = new JFrame();

        if (group != null) {

            selected = group.getSelection();

            if (selected != null) {

                str = selected.getActionCommand();
                System.out.println("RadioButton " + str + " was chosen...");

            } else {

                JOptionPane optionpane = new JOptionPane();

                JOptionPane.showMessageDialog(jframe, "Please choose a RadioButton!", "Message", JOptionPane.INFORMATION_MESSAGE);
                str = null;
                System.out.println("No RadioButton was chosen...");
            }

        } else {

            throw new NullPointerException("Could not create ButtonModel. The ButtonModel is null.");
        }

        return str;

    }
}

