/*
 * $RCSfile: FileChooser.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */


package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.io.*;

/**
 * This class represents a diverse FileChooser windows.
 *
 * @version $Revision: 1.4 $ $Date: 2003/01/07 16:20:40 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 */

public class FileChooser extends SwingView {


    /**
     *  Create a FileChooser Dialog to chose a file. The selected file will be added to the the Choice Vector.
     *
     *
     */
    public void createSelectFileDialog() {

        RestoreModel model = (RestoreModel) getModel();

        JFileChooser jfc = new JFileChooser();
        RestoreFileFilter filterImg = new RestoreFileFilter();
        filterImg.addExtension("jpg");
        filterImg.addExtension("gif");
        filterImg.setDescription("JPG & GIF Images");
        jfc.setFileFilter(filterImg);
        RestoreFileFilter filterTxt = new RestoreFileFilter();
        filterTxt.addExtension("txt");
        filterTxt.setDescription("Text");
        jfc.setFileFilter(filterTxt);
        RestoreFileFilter filterXml = new RestoreFileFilter();
        filterXml.addExtension("xml");
        filterXml.setDescription("XML");
        jfc.setFileFilter(filterXml);
        jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);

        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.addToChoiceVector(file, "file");

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        }

    }

    /**
     *  Create a FileChooser Dialog to chose a folder. The selected folder will be added to the the Choice Vector.
     *
     *
     */
    public void createSelectFolderDialog() {

        RestoreModel model = (RestoreModel) getModel();

        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setDragEnabled(false);
        jfc.showOpenDialog(new JFrame());
        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.addToChoiceVector(file, "folder");


            } catch (Exception e) {
                System.out.println("Fehler: " + e);
            }


        }

    }


    /**
     *  Create a FileChooser Dialog to chose a recursive folder. The selected recursive folder will be added to the the Choice Vector.
     *
     *
     */
    public void createSelectFolderRecursiveDialog() {

        RestoreModel model = (RestoreModel) getModel();


        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setDragEnabled(false);
        jfc.showOpenDialog(new JFrame());
        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.addToChoiceVector(file, "recFolder");


            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }
        }

    }

    /**
     *  Create a FileChooser Dialog to chose the Backup Path. The selected Backup Path will be stored.
     *
     *
     */
    public void createBackupPathDialog() {

        RestoreModel model = (RestoreModel) getModel();

        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setDragEnabled(false);
        jfc.showOpenDialog(new JFrame());
        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.setBackupPathString(file.toString());
                model.setRestorePathString("<default>");

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        }

    }

    /**
     *  Create a FileChooser Dialog to chose the Restore Path. The selected Restore Path will be stored.
     *
     *
     */
    public void createRestorePathDialog() {

        RestoreModel model = (RestoreModel) getModel();

        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setDragEnabled(false);
        jfc.showOpenDialog(new JFrame());
        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.setRestorePathString(file.toString());

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        }

    }

    /**
     *  Create a FileChooser Dialog to chose the Storing Path. The selected Storing Path will be stored.
     *
     *
     */
    public void createStoringPathDialog() {

        RestoreModel model = (RestoreModel) getModel();
        JFileChooser jfc = new JFileChooser();

        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setDragEnabled(false);
        jfc.showOpenDialog(new JFrame());

        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                model.setStoringPathString(file.toString());

            } catch (Exception e) {

                System.out.println("Fehler: " + e);

            }

        }

    }

    /**
     *  Create a FileChooser Dialog to chose the Information File RestoreInfo.res. This file will be loaded.
     *
     *
     */
    public void createSelectInformationFileDialog() {

        RestoreModel model = (RestoreModel) getModel();

        JFileChooser jfc = new JFileChooser();
        RestoreFileFilter filterImg = new RestoreFileFilter();
        filterImg.addExtension("res");
        filterImg.setDescription("RestoreInfo");
        jfc.setFileFilter(filterImg);

        jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);

        int value = jfc.showOpenDialog(new JFrame());

        if (value == JFileChooser.APPROVE_OPTION) {

            File file = jfc.getSelectedFile();

            try {

                if (!file.getName().toString().equals("RestoreInfo.res")) {

                    System.out.println("You have to open the file \"RestoreInfo.res\" ");
                    JFrame frame = new JFrame();
                    JOptionPane.showMessageDialog(frame, "You have to open the file \"RestoreInfo.res\" ", "Message", JOptionPane.INFORMATION_MESSAGE);

                } else {

                    model.setInformationFileString(file.toString());
                    model.readRepositoryVectorFromFile();

                }


            } catch (Exception e) {
                System.out.println("Fehler: " + e);
            }

        }

    }

}
