/*
 * $RCSfile: BackupOption.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */


package org.resmedicinae.application.healthcare.restore;

import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;


/**
 * This class represents a BackupOption Window.
 *
 * @version $Revision: 1.5 $ $Date: 2003/01/07 16:20:37 $ $Author: behr78 $
 * @author Dirk Behrendt <schnoerk@web.de>
 */


public class BackupOption extends SwingView {

    private JList repositoryList;
    private JList choiceList;
    private JTextField backupPathTextField;

    private int selectedRepositoryIndex = -1;
    private int selectedChoiceIndex = -1;
    private int oldSelectedRepositoryIndex = -1;

    private int repositoryVectorSize = 0;
    private int oldRepositoryVectorSize = 0;

    private int selectedJTabbedPaneIndex;

    public static ButtonGroup group;
    private JPanel backupOptionPanel;


    /**
     * Initializes this view.
     */


    public void initialize() throws Exception {


        try {
            super.initialize();
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);

            this.setDialogBounds(this.createDialogBounds());
            this.setLayout(new BorderLayout());
            this.setTitle("Backup Options");
            this.setBackupOptionPanel(this.createBackupOptionPanel());
            this.add(this.getBackupOptionPanel(), BorderLayout.WEST);
            this.setResizable(false);

        } catch (Exception e) {
            System.out.println("Fehler: " + e);
        }

    }

    /**
     *  Create the MenuBar.
     * @return the MenuBar
     *
     */
    public ResMenuBar createMenuBar() {


        ResMenuBar mb = new ResMenuBar();
        ResMenu menu1 = new ResMenu(); // Window

        ResMenuItem menuItem11 = new ResMenuItem();

        try {

            menuItem11.setText("Close");
            menuItem11.setActionCommand(Restore.BACKUP_OPTION_WINDOW_CLOSE_WINDOW_ID);
            menuItem11.setEnabled(true);
            menuItem11.addActionListener((Restore) getController());

            menu1.setText("Window");
            menu1.add(menuItem11);
            mb.add(menu1);

        } catch (Exception e) {
            System.out.println("There was an error in the class BackupOption: " + e);
        }
        ;

        return mb;

    }

    /**
     *  Create the Panel.
     * @return the Panel
     *
     */
    public JPanel createBackupOptionPanel() throws Exception {

        JFrame frame1 = new JFrame();
        Container cp1 = frame1.getContentPane();

        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        JPanel p5 = new JPanel();
        JPanel p6 = new JPanel();
        JPanel p7 = new JPanel();
        JPanel p8 = new JPanel();
        JPanel p9 = new JPanel();
        JPanel p10 = new JPanel();


        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();

        // create JLists and ScrollPanes
        repositoryList = new JList();
        choiceList = new JList();

        JScrollPane scroll1;
        JScrollPane scroll2;

        // create labels
        JLabel jl = new JLabel();
        JLabel jl2 = new JLabel();

        // create a TextField
        this.backupPathTextField = new JTextField();

        // create buttons
        JButton b1 = new JButton();
        JButton b2 = new JButton();
        JButton b3 = new JButton();
        JButton b4 = new JButton();
        JButton b5 = new JButton();
        JButton b6 = new JButton();

        // create RadioButtons
        JRadioButton rb1 = new JRadioButton("Add file");
        JRadioButton rb2 = new JRadioButton("Add folder");
        JRadioButton rb3 = new JRadioButton("Add folder recursive");
        JRadioButton rb4 = new JRadioButton("Remove slected");
        JRadioButton rb5 = new JRadioButton("Remove all");


        try {

            p1.setLayout(new FlowLayout(FlowLayout.LEFT));
            p2.setLayout(new FlowLayout());
            p3.setLayout(new GridLayout(3, 1));
            p4.setLayout(new FlowLayout(FlowLayout.LEFT));
            p5.setLayout(new GridLayout(2, 1));
            p6.setLayout(new BorderLayout());
            p8.setLayout(new GridLayout(7, 1));
            p9.setLayout(new BorderLayout());

            cp1.setLayout(new FlowLayout(FlowLayout.LEFT));

            p2.setBorder(BorderFactory.createTitledBorder("Repository"));
            p8.setBorder(BorderFactory.createTitledBorder("Edit"));
            p9.setBorder(BorderFactory.createTitledBorder("Choice"));

            p7.setLayout(gbl);
            p9.setLayout(gbl);
            p10.setLayout(gbl);

            jl.setText("Backup path");
            jl2.setText(" ");

            this.backupPathTextField.setColumns(39);

            b1.setText("New");
            b1.addActionListener((Restore) getController());
            b1.setActionCommand(Restore.BACKUP_OPTION_WINDOW_NEW_ID);
            b1.setToolTipText("Create a new repository file...");

            b2.setText("Save");
            b2.addActionListener((Restore) getController());
            b2.setActionCommand(Restore.BACKUP_OPTION_WINDOW_SAVE_ID);
            b2.setToolTipText("Save the selected repository file with its choice...");

            b3.setText("Delete");
            b3.addActionListener((Restore) getController());
            b3.setActionCommand(Restore.BACKUP_OPTION_WINDOW_DELETE_ID);
            b3.setToolTipText("Delete the selected repository file with its choice...");

            b4.setText("Load repository");
            b4.addActionListener((Restore) getController());
            b4.setActionCommand(Restore.BACKUP_OPTION_WINDOW_LOAD_REPOSITORY_ID);
            b4.setToolTipText("Load an existing repository...");

            b5.setText("Execute");
            b5.addActionListener((Restore) getController());
            b5.setActionCommand(Restore.BACKUP_OPTION_WINDOW_EXECUTE_ID);

            b6.setText("Select path");
            b6.addActionListener((Restore) getController());
            b6.setActionCommand(Restore.BACKUP_OPTION_WINDOW_SELECT_PATH_ID);
            b6.setToolTipText("Select a backup path...");

            rb1.setActionCommand(Restore.BACKUP_OPTION_WINDOW_ADD_FILE_ID);
            rb2.setActionCommand(Restore.BACKUP_OPTION_WINDOW_ADD_FOLDER_ID);
            rb3.setActionCommand(Restore.BACKUP_OPTION_WINDOW_ADD_FOLDER_RECURSIVE_ID);
            rb4.setActionCommand(Restore.BACKUP_OPTION_WINDOW_REMOVE_SELECTED_ID);
            rb5.setActionCommand(Restore.BACKUP_OPTION_WINDOW_REMOVE_ALL_ID);

            rb1.setToolTipText("Add a file to a repository file...");
            rb2.setToolTipText("Add a folder to the a repository file...");
            rb3.setToolTipText("Add a folder (recursive) to a repository file...");
            rb4.setToolTipText("Remove the selected file or folder from the choice...");
            rb5.setToolTipText("Remove all files and folders from the choice...");

            group = new ButtonGroup();

            if (group != null) {

                group.add(rb1);
                group.add(rb2);
                group.add(rb3);
                group.add(rb4);
                group.add(rb5);

            } else {

                throw new NullPointerException("Could not create ButtonGroup. The ButtonGroup is null.");
            }

            this.getRepositoryList().addListSelectionListener((ListSelectionListener) getController());
            this.getChoiceList().addListSelectionListener((ListSelectionListener) getController());
            this.getRepositoryList().setBackground(this.getBackground());

            getChoiceList().setBackground(this.getBackground());
            getChoiceList().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

            scroll1 = new JScrollPane(repositoryList);
            scroll1.setPreferredSize(new Dimension(150, 120));

            p2.add(scroll1, BorderLayout.NORTH);
            p2.setPreferredSize(new Dimension(170, 156));

            scroll2 = new JScrollPane(choiceList);
            scroll2.setPreferredSize(new Dimension(375, 181));

            p3.add(b1);
            p3.add(b3);
            p3.add(b4);

            p1.add(p2);
            p1.add(p3);

            p5.add(jl);
            p5.add(this.backupPathTextField);

            p6.add(b6, BorderLayout.CENTER);
            p6.add(jl2, BorderLayout.NORTH);

            p4.add(p5);
            p4.add(p6);

            p8.add(rb1);
            p8.add(rb2);
            p8.add(rb3);
            p8.add(rb4);
            p8.add(rb5);
            p8.add(b5);
            p8.add(b2);

            p9.add(scroll2);

            gbc = makegbc(0, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p8, gbc);
            p7.add(p8);

            gbc = makegbc(1, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p9, gbc);
            p7.add(p9);

            gbc = makegbc(0, 0, 1, 1);
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbl.setConstraints(p1, gbc);
            p10.add(p1);

            gbc = makegbc(0, 1, 1, 1);
            gbc.anchor = GridBagConstraints.WEST;
            gbc.weightx = 1;
            gbl.setConstraints(p4, gbc);
            p10.add(p4);

            gbc = makegbc(0, 2, 1, 1);
            gbc.anchor = GridBagConstraints.WEST;
            gbc.weightx = 1;
            gbl.setConstraints(p7, gbc);
            p10.add(p7);

        } catch (Exception e) {

            System.out.println("There was an error in the class BackupOption: " + e);

        }
        ;

        return p10;

    }


    public void setBackupOptionPanel(JPanel backupOptionPanel) {

        this.backupOptionPanel = backupOptionPanel;

    }


    public JPanel getBackupOptionPanel() {

        return this.backupOptionPanel;

    }


    public JList getRepositoryList() {

        return this.repositoryList;

    }


    public void setRepositoryList(JList list1) {

        this.repositoryList = list1;

    }


    public JList getChoiceList() {

        return this.choiceList;

    }


    public void setChoiceList(JList list1) {

        this.choiceList = list1;

    }


    public void setBackupPathTextField(JTextField jtf) {

        this.backupPathTextField = jtf;

    }


    public JTextField getBackupPathTextField() {

        return this.backupPathTextField;

    }


    public void updateBackupPathTextField() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();
            this.getBackupPathTextField().setText(model.getBackupPathString());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    public void updateChoiceList() throws Exception {

        try {

            RestoreModel model = (RestoreModel) getModel();

            getChoiceList().setEnabled(true);
            getChoiceList().setListData(model.getChoiceVector());

        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    public void setSelectedChoiceIndex(int index) {

        this.selectedChoiceIndex = index;

    }


    public void updateSelectedChoiceIndex() {

        this.selectedChoiceIndex = getChoiceList().getSelectedIndex();

    }


    public int getSelectedChoiceIndex() {

        return this.selectedChoiceIndex;

    }


    public void setSelectedJTabbedPaneIndex(int index) {

        this.selectedJTabbedPaneIndex = index;
    }


    public void updateSelectedJTabbedPaneIndex() {

        this.selectedJTabbedPaneIndex = getChoiceList().getSelectedIndex();

    }


    public int getSelectedJTabbedPaneIndex() {

        return this.selectedJTabbedPaneIndex;

    }


    /**
     * Update the Repository List.
     */
    public void updateRepositoryList() throws Exception {
        try {

            RestoreModel model = (RestoreModel) getModel();

            getRepositoryList().setEnabled(true);
            getRepositoryList().setListData(model.getRepositoryVector());


        } catch (Exception e) {

            throw new Exception("Couldn't show JList data! \n" + e);

        }
    }


    public void setSelectedRepositoryIndex(int index) {

        this.selectedRepositoryIndex = index;

    }


    public void updateSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = this.selectedRepositoryIndex;
        this.selectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getSelectedRepositoryIndex() {

        return this.selectedRepositoryIndex;

    }


    public void setRepositoryIndexSize(int index) {

        this.repositoryVectorSize = index;

    }


    public void updateRepositoryVectorSize() {

        RestoreModel model = (RestoreModel) getModel();

        this.oldRepositoryVectorSize = this.repositoryVectorSize;
        this.repositoryVectorSize = model.getRepositoryVector().size();

    }


    public int getRepositoryVectorSize() {

        return this.repositoryVectorSize;

    }


    public void setOldRepositoryIndexSize(int index) {

        this.oldRepositoryVectorSize = index;

    }


    public int getOldRepositoryVectorSize() {

        return this.oldRepositoryVectorSize;

    }


    public void setOldSelectedRepositoryIndex(int index) {

        this.oldSelectedRepositoryIndex = index;

    }


    public void updateOldSelectedRepositoryIndex() {

        this.oldSelectedRepositoryIndex = getRepositoryList().getSelectedIndex();

    }


    public int getOldSelectedRepositoryIndex() {

        return this.oldSelectedRepositoryIndex;

    }

    /**
     * Determine the position of an graphical element.
     * @return the determined object
     */
    private GridBagConstraints makegbc(int x, int y, int width, int height) {

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(1, 1, 1, 1);
        return gbc;

    }

    /**
     * Determine the size of the window.
     * @return the window with its special size.
     */
    public Rectangle createDialogBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 580;     //640

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 560;  //520

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new Rectangle(x, y, w, h);
    }


    /**
     * Finalizes this view.
     */
    public void finalizz() throws Exception {

        try {

        } finally {

            super.finalizz();
        }

    }


}
