package org.resmedicinae.application.healthcare.resdata.taglibs;

import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ForVectorTag extends TagSupport
{
	private int i = 0;
   	private Vector v = null;
   	private String parentTimeIdFieldName = "";
   	private String parentDateIdFieldName = "";
   
   	public void setVector (Vector vector) {

		this.v = vector;
   	}

	public Vector getVector() {

    	return v;
   	}

	public int getCounter() {

    	return i;
   	}

   	public void setParentTimeIdFieldName( String parentTimeIdFieldName ) {

		this.parentTimeIdFieldName = parentTimeIdFieldName;
   	}

   	public String getParentTimeIdFieldName() {

		return parentTimeIdFieldName;
   	}

   	public void setParentDateIdFieldName( String parentDateIdFieldName ) {

		this.parentDateIdFieldName = parentDateIdFieldName;
   	}

   	public String getParentDateIdFieldName() {

		return parentDateIdFieldName;
   	}

	
   	public int doStartTag () throws JspTagException {
   		
   		//if set the parentidfieldname, then put the paramenter 
   		//in the actuell vector
       	ForVectorTag parent =
       		(ForVectorTag) findAncestorWithClass(this,ForVectorTag.class);
   		
		if(parent==null) {
			//throw new JspTagException("Case Tag without Switch Tag");
	 	}
	 	else { 

	 		//get the id for the actuell row
	 		Vector parentVector 	= parent.getVector();
		 	int parentCounter   	= parent.getCounter();
		 	Properties parentProp  	= (Properties)parentVector.elementAt(parentCounter);
		 	String parentTimeId 	= parentProp.getProperty( parentTimeIdFieldName );
		 	String parentDateId 	= parentProp.getProperty( parentDateIdFieldName );
		 	
		 	//write the id in the current vector for ech row
		 	if (v!=null) {
  			
  				for (int counter=0;counter<v.size();counter++) {
  			
				 	Properties currentprop = (Properties)v.elementAt(counter);
				 	if ( parentTimeId!=null ) {
	  					currentprop.put( parentTimeIdFieldName, parentTimeId );
				 	}
				 	if ( parentDateId!=null ) {
	  					currentprop.put( parentDateIdFieldName, parentDateId );
				 	}
  				}
		 	}
		 	
	 	}
   	
    	if (i < v.size())
         	return EVAL_BODY_INCLUDE;
      	else
        	return SKIP_BODY;
   	}
   
   	public int doAfterBody () throws JspException {

		i++;
      	if (i < v.size()) {

        	// Weiter iterieren
        	return EVAL_BODY_AGAIN;      
		}
      	else
      	{
			// Wir haben oft genug iteriert.
        	return SKIP_BODY;
      	}
	}
   
   	public int doEndTag () throws JspException {
		return EVAL_PAGE;
   	}

}
