package org.resmedicinae.application.healthcare.resdata.taglibs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.resmedicinae.application.healthcare.resdata.ResDataConfig;
import org.resmedicinae.application.healthcare.resdata.model.IModel;

/**
 * @author Rolf
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DateColor extends TagSupport {

	private String  name;
	private String  action;
	private Integer doc_id;

   	private String parentTimeIdFieldName = "";
   	private String parentDateIdFieldName = "";

	public void setName (String name) {
      	
      	this.name  = name;
   	}

	public void setAction (String action) {
      	
      	this.action  = action;
   	}


	public void setDoc_id (String id) {
      	
      	this.doc_id = Integer.valueOf( id );
   	}


   	public void setParentTimeIdFieldName( String parentTimeIdFieldName ) {

		this.parentTimeIdFieldName = parentTimeIdFieldName;
   	}


   	public String getParentTimeIdFieldName() {

		return parentTimeIdFieldName;
   	}


   	public void setParentDateIdFieldName( String parentDateIdFieldName ) {

		this.parentDateIdFieldName = parentDateIdFieldName;
   	}


   	public String getParentDateIdFieldName() {

		return parentDateIdFieldName;
   	}
	

	public int doStartTag () throws JspTagException
    {
    	try
      	{
        	 // Das out-Objekt beschaffen
         	JspWriter out = pageContext.getOut ();
       
	   		//if set the parentidfieldname, then put the paramenter 
	   		//in the actuell vector
	       	ForVectorTag parent =
	       		(ForVectorTag) findAncestorWithClass(this,ForVectorTag.class);
	   		
			if(parent==null) {
				//throw new JspTagException("Case Tag without Switch Tag");
		 	}
		 	else { 
	
		 		//get the id for the actuell row
	         	//get the id from the over tag
		 		Vector parentVector 	= parent.getVector();
			 	int parentCounter   	= parent.getCounter();
			 	Properties parentProp  	= (Properties)parentVector.elementAt(parentCounter);
			 	String parentTimeId 	= parentProp.getProperty( parentTimeIdFieldName );
			 	String parentDateId 	= parentProp.getProperty( parentDateIdFieldName );
	         	
	  	       	
				HashMap param = new HashMap();
				param.put( "action", action );
				param.put( "doc_id", doc_id );
				param.put( parentTimeIdFieldName, parentTimeId );
				param.put( parentDateIdFieldName, parentDateId );
			 	
			 	
	         	IModel dateModel = (IModel)pageContext.getSession().getAttribute( name );
	         
	         	dateModel.run( param );
	
				param = dateModel.getModelData();
				String datecolor = (String)param.get( "datecolor" );
	         
	         	out.print (datecolor);
		 	}
       
         	
 
         	// Der Body des Tags ist wird nicht ausgegeben
         	return SKIP_BODY;
      	}
		catch (IOException e) {
      		throw new JspTagException 
                    ("JspWriter nicht verfgbar" + e);
      	}
      
   	}


}
