/*
 * $RCSfile: ResDataMail.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The class is the model for the login-activity
 *
 * @version          $Revision: 1.7 $
 *                   $Date: 2003/01/27 08:11:57 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.model;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.resmedicinae.application.healthcare.resdata.*;



public class ResDataMail extends Model implements IModel {

    private Vector time_interval;
    private Vector time_period;
    private Calendar time_start;
    private String desired_date;
    private String desired_time;

    /**
     * Constructor for ResDataDate.
     */
    public ResDataMail() {

        super();
    }


    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#init(String)
     */
    public void init(String action) {
    }


    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#run(HashMap)
     */
    public void run(HashMap param) {

		super.run( param );

        try {

            String action = (String)param.get("action");

            String subject="";
            String to="";
            String text="";

            //set the parameter in dependence on the action
            if ( action.equalsIgnoreCase( "DoctorSendMailDesired") ) {

                subject  = ResDataConfig.getConfig().getMailSubjectDesired();
                to       = (String)param.get( "doc_email");
                text     = (String)param.get( "date_desc");
                sendMail( subject, to, text );
            }

            else if ( action.equalsIgnoreCase( "DoctorSendmailConfirm" ) ) {

                subject  = ResDataConfig.getConfig().getMailSubjectConfirm();
                to       = (String)param.get( "date_patient_email");
                text     = (String)param.get( "date_desc");
                sendMail( subject, to, text );
            }

            else if ( action.equalsIgnoreCase( "DoctorSendmailCancel" ) ) {

                subject  = ResDataConfig.getConfig().getMailSubjectCancel();
                to       = (String)param.get( "date_patient_email");
                text     = (String)param.get( "date_desc");
                sendMail( subject, to, text );
            }

            else {

                Logger.getLogger().logerror( "ResDataMail", "run",
                                             "Actionparameter " + action + " is not handled", null);
                setModelstatus( NO_ACTION_HANDLED );
            }

        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataMail", "run",
                                         "Error", e);
        }
    }


   /**
     *
     * send a mail and set the modelstatus for sending
     * successfull or not
     *
     * @param subject subject of the mail
     * @param to the email adress
     * @param text the content of the mail
     *
     */
    private void sendMail( String subject,String to,String text ) {

        try {

            //get the general parameter from the config
            String protocol = ResDataConfig.getConfig().getMailProtocol();
            String host     = ResDataConfig.getConfig().getMailHost();
            String from     = ResDataConfig.getConfig().getMailFromAdress();

            //Mail versenden
            Properties prop = new Properties();
            prop.put( "mail.smtp.host", host);
            prop.put("mail.smtp.auth","true");

            //create the authentication object
            Authenticator auth = new ResDataMailAuthenticator();
            Session session = Session.getDefaultInstance( prop, auth);

            //set the parameter for the email
            MimeMessage messages = new MimeMessage( session );
            messages.setFrom( new InternetAddress(from) );
            messages.addRecipient( Message.RecipientType.TO,  new InternetAddress(to) );
            messages.setSubject( subject );
            messages.setText( text );

            //send the messages
            Transport.send( messages );

            setModelstatus( MAIL_SEND_SUCCESSFULL );


        } catch (Exception e) {

            setModelstatus( MAIL_SEND_UNSUCCESSFULL );
            Logger.getLogger().logerror( "ResDataMail", "sendMail",
                                         "Error", e);
        }
    }

}
