/*
 * $RCSfile: ResDataLogin.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The class is the model for the login-activity
 *
 * @version         $Revision: 1.7 $
 *                   $Date: 2003/01/27 08:11:57 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import org.resmedicinae.application.healthcare.resdata.Logger;
import org.resmedicinae.application.healthcare.resdata.ResDataDB;



public class ResDataLogin extends Model implements IModel {

	public String loginAdminId;
	public String loginDocId;

   /**
     *
     * initialiation the model
     *
     * @param action for wich action to be initialiation
     *
     */
    public ResDataLogin() {
    	
		loginAdminId = "";
		loginDocId   = "";
    };

    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#run(HashMap)
     */
    public void run ( HashMap param ) {

        try {

            super.run( param );
        
            String action = (String)param.get("action");
        
            if ( action.equalsIgnoreCase( "DoctorLogin" ) ) {
        
                //get the parameter login, password from the formular
                String login = (String)param.get("login");
                String pwd   = (String)param.get("password");
        
                String doc_id = getDoctorIdForLogin(login, pwd, false);

				if ( ((login != null) && (!login.equals(""))) || 
					 ((pwd!=null) && (!pwd.equals(""))) ) {
        
		            if (doc_id.equals("")) {
		    
		                setModelstatus( DOCTOR_LOGIN_UNSUCCESSFULL );
		            }
		            else {
		    
		                setModelstatus( DOCTOR_LOGIN_SUCCESSFULL );
		    
		                clearModelData();
		                putModelData("doc_id", doc_id );
		                loginDocId = doc_id;
		            }
				}
				
				else {

					if (!loginDocId.equals("")) {
	                    putModelData("doc_id", loginDocId );
	                    setModelstatus( DOCTOR_LOGIN_SUCCESSFULL );
					}
					else {

	                    setModelstatus( DOCTOR_LOGIN_REQUIRED );
					}
				}
            }
            else if ( action.equalsIgnoreCase( "AdminLogin" ) ) {
        
                //get the parameter login, password from the formular
                String login = (String)param.get("login");
                String pwd   = (String)param.get("password");
        
                String doc_id = getDoctorIdForLogin(login, pwd, true);

				if ( ((login != null) && (!login.equals(""))) || 
					 ((pwd!=null) && (!pwd.equals(""))) ) {
        
	                if (doc_id.equals("")) {
	        
	                    setModelstatus( ADMIN_LOGIN_UNSUCCESSFULL );
	                }
	                else {
	        
	                    setModelstatus( ADMIN_LOGIN_SUCCESSFULL );
	        
	                    clearModelData();
	                    putModelData("doc_id", doc_id );
	                    loginAdminId = doc_id;
	                }
				}
				else {
					
					if (!loginAdminId.equals("")) {
	                    putModelData("doc_id", loginAdminId );
	                    setModelstatus( ADMIN_LOGIN_SUCCESSFULL );
					}
					else {
	                    setModelstatus( ADMIN_LOGIN_REQUIRED );
					}
				}
            }
            
            else {
        
                Logger.getLogger().logerror( "ResDataLogin", "run",
                                             "Actionparameter " + action + " is not handled", null);
                setModelstatus( NO_ACTION_HANDLED );
            }
                
			
		} catch (Exception e) {

            Logger.getLogger().logerror( "ResDataLogin", "run",
                                         "Error", e);
		}
    }

   /**
     *
     * check the login with the database
     *
     * @param login login for the doctor page
     * @param password password for the doctor page
     *
     * @return doctor id from the database for the login
     *          if no entry in the database, the doctor id
     *          is empty
     */
    public String getDoctorIdForLogin( String login, String pwd, boolean root) {

        Connection con = ResDataDB.getConnection();
        String docid = "";

        try {

            //check in the database
            String sql = " select doc_id from doctor where " +
                         " doc_login = "    + ResDataDB.getSQLString(login) + " and " +
                         " doc_password = " + ResDataDB.getSQLString(pwd);
			if (!root) {
				
				sql = sql + " and " +
                            " doc_login <> " + ResDataDB.getSQLString("root");
			}

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );

            if (res.next()) {

                docid = res.getString("doc_id");
            }

        }

        catch ( Exception e ) {

            Logger.getLogger().logerror( "ResDataLogin", "getDoctorIdForLogin",
                                          e.getMessage(), e );
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return docid;
    }

}
