/*
 * $RCSfile: ResDataDoctor.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The class is the model for the login-activity
 *
 * @version         $Revision: 1.8 $
 *                   $Date: 2003/01/27 08:11:57 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.model;

import java.sql.*;
import java.util.HashMap;
import java.util.Properties;
import org.resmedicinae.application.healthcare.resdata.Logger;
import org.resmedicinae.application.healthcare.resdata.Level;
import org.resmedicinae.application.healthcare.resdata.ResDataDB;


public class ResDataDoctor extends Model implements IModel {

    //variables for the model doctor
    private String doc_id;
    private String doc_name;
    private String doc_firstname;
    private String doc_title;
    private String doc_street;
    private String doc_postcode;
    private String doc_city;
    private String doc_phone1;
    private String doc_phone2;
    private String doc_email;
    private String doc_login;
    private String doc_password;


    /**
     * Constructor for ResDataLogin.
     */
    public ResDataDoctor() {

        super();
        doc_id="";
    }


    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#init(String)
     */
    public void init(String action) {
    }


    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#run(HashMap)
     */
    public void run ( HashMap param ) {

        try {

            super.run( param );
    
            //get the action parameter
            String action = (String)param.get("action");
    
            //evaluate the action parameter

            if ( action.equalsIgnoreCase( "DoctorLogin" ) ) {
    
                doc_id = (String)param.get("doc_id");
                if ( !loadDoctor( doc_id ) ) {
    
                    setModelstatus( ERROR );
                }
            }
    
            else if ( action.equalsIgnoreCase( "AdminLogin" ) ) {
    
                doc_id = (String)param.get("doc_id");
    
                if ( (doc_id != null ) && ( !doc_id.equals("") ) ) {
    
                    if ( !loadDoctor( doc_id ) ) {
        
                        setModelstatus( ERROR );
                    }
                }
                else {
                    
                    clearAttributte();   
                }                
            }
    
            else if ( action.equalsIgnoreCase( "AdminNewDoc" ) ) {
    
                clearAttributte();   
            }
    
            else if ( action.equalsIgnoreCase( "AdminEditDoc" ) ) {
    
                doc_id = (String)param.get("doc_id");

                if ( !loadDoctor( doc_id ) ) {
    
                    setModelstatus( ERROR );
                }
            }
    
    
            else if ( action.equalsIgnoreCase( "AdminDeleteDoc" ) ) {
    
                doc_id = (String)param.get("doc_id");

                if ( !deleteDoctor( doc_id ) ) {
    
                    setModelstatus( ERROR );
                }
                
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateOverview" ) ) {
    
                String id = (String)param.get("doc_id");
    
                if ((id!=null) && (!id.equals(""))) {
    
                    doc_id=id;
                    if ( !loadDoctor( doc_id ) ) {
        
                        setModelstatus( ERROR );
                    }
                }
            }
    
            else if ( action.equalsIgnoreCase( "DoctorSave" ) ) {
    
                //set the parameter into the modell
                setDoc_id(          (String)param.get("doc_id") );
                setDoc_name(        (String)param.get("name") );
                setDoc_firstname(   (String)param.get("firstname") );
                setDoc_title(       (String)param.get("title") );
                setDoc_street(      (String)param.get("street") );
                setDoc_city(        (String)param.get("city") );
                setDoc_postcode(    (String)param.get("postcode") );
                setDoc_phone1(      (String)param.get("phone1") );
                setDoc_phone2(      (String)param.get("phone2") );
                setDoc_email(       (String)param.get("email") );
    
                // save the model
                if ( saveDoctor() ) {
    
                    setModelstatus( DOCTOR_SAVE_SUCCESSFULL );
                }
                else {
    
                    setModelstatus( DOCTOR_SAVE_UNSUCCESSFULL );
                }
            }
    
            else if ( action.equalsIgnoreCase( "AdminDoctorSave" ) ) {
    
                //set the parameter into the modell
                String login        = (String)param.get("login"); 
                String pwd          = (String)param.get("password");
                String pwd_confirm  = (String)param.get("password_confirm");
    
                // save the model
                if (pwd.equals(pwd_confirm)) {
    
                    setDoc_login( login );
                    setDoc_password( pwd );
    
                    if ( saveDoctor() ) {
        
                        setModelstatus( DOCTOR_SAVE_SUCCESSFULL );
                    }
                    else {
        
                        setModelstatus( DOCTOR_SAVE_UNSUCCESSFULL );
                    }
                }
                else {
        
                    setModelstatus( DOCTOR_SAVE_PWD_NOT_CONFIRM );   
                }
    
            }
    
            else if ( ( action.equalsIgnoreCase( "DoctorDateConfirmList" ) ) ||
            		   ( action.equalsIgnoreCase( "DoctorSendMailCancel" ) ) ||
            		   ( action.equalsIgnoreCase( "DoctorSendMailConfirm" ) ) ) {
    
                //the doc_id must in the param
                clearModelData();
                putModelData( "doc_id", getDoc_id() );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateDelete" ) ) {
    
                //the doc_id must in the param
                clearModelData();
                putModelData( "doc_id", getDoc_id() );
            }
    
            else {
    
                Logger.getLogger().logerror( "ResDataDoctor", "run",
                                             "Actionparameter " + action + " is not handled", null);
                setModelstatus( NO_ACTION_HANDLED );
            }
			
		} catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDoctor", "run",
                                         "Error", e);
            setModelstatus( ERROR );
		}
    };


    //
    //  get and set method for the variables
    //
    public void setDoc_id( String id ) {

        if (id==null)

            doc_id = "";
        else

            doc_id = id;
    }

    public String getDoc_id() {

        return doc_id;
    }

    public void setDoc_name( String name ) {

        if (name==null)

            doc_name = "";
        else

            doc_name = name;
    }

    public String getDoc_name() {

        return doc_name;
    }

    public void setDoc_firstname( String firstname ) {

        if (firstname==null)

            doc_firstname = "";
        else

            doc_firstname = firstname;
    }

    public String getDoc_firstname() {

        return doc_firstname;
    }

    public void setDoc_title( String title ) {

        if (title==null)

            doc_title = "";
        else

            doc_title = title;
    }

    public String getDoc_title() {

        return doc_title;
    }

    public void setDoc_street( String street ) {

        if (street==null)

            doc_street = "";
        else

            doc_street = street;
    }

    public String getDoc_street() {

        return doc_street;
    }

    public void setDoc_postcode( String postcode ) {

        if (postcode==null)

            doc_postcode = "";
        else

            doc_postcode = postcode;
    }

    public String getDoc_postcode() {

        return doc_postcode;
    }


    public void setDoc_city( String city ) {

        if (city==null)

            doc_city = "";
        else

            doc_city = city;
    }

    public String getDoc_city() {

        return doc_city;
    }

    public void setDoc_phone1( String phone1 ) {

        if (phone1==null)

            doc_phone1 = "";
        else

            doc_phone1 = phone1;
    }

    public String getDoc_phone1() {

        return doc_phone1;
    }

    public void setDoc_phone2( String phone2 ) {

        if (phone2==null)

            doc_phone2 = "";
        else

           doc_phone2 = phone2;
    }

    public String getDoc_phone2() {

        return doc_phone2;
    }

    public void setDoc_email( String email ) {

        if (email==null)

            doc_email = "";
        else

            doc_email = email;
    }

    public String getDoc_email() {

        return doc_email;
    }


    public void setDoc_login( String login ) {

        doc_login = login;
    }

    public String getDoc_login() {

        return doc_login;
    }


    public void setDoc_password( String password ) {

        doc_password = password;
    }

    public String getDoc_password() {

        return doc_password;
    }



   /**
     *
     * the method load the data in the model from
     * the database.
     *
     * @return true the load was successfull
     * @return false the load was not successfull
     *
     */
    public boolean loadDoctor( String id ) {

        Connection con = ResDataDB.getConnection();

        try {

            //prfen in DB
            String sql = " select " +
                         "   doc_id,doc_name,doc_firstname, " +
                         "   doc_title,doc_street,doc_postcode, " +
                         "   doc_city,doc_phone1,doc_phone2, " +
                         "   doc_email,doc_login,doc_password " +
                         " from doctor " +
                         " where doc_id = " + ResDataDB.getSQLString(id);

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );


            if (res.next()) {

                setDoc_id( res.getString( "doc_id") );
                setDoc_name( res.getString( "doc_name") );
                setDoc_firstname( res.getString( "doc_firstname") );
                setDoc_title( res.getString( "doc_title") );
                setDoc_street( res.getString( "doc_street") );
                setDoc_postcode( res.getString( "doc_postcode") );
                setDoc_city( res.getString( "doc_city") );
                setDoc_phone1( res.getString( "doc_phone1") );
                setDoc_phone2( res.getString( "doc_phone2") );
                setDoc_email( res.getString( "doc_email") );
                setDoc_login( res.getString( "doc_login") );
                setDoc_password( res.getString( "doc_password") );

                return true;
            }
            else {
                Logger.getLogger().log( Level.ALL,
                                        "Fr die doc_id konnten keine Daten " +
                                        "geladen werden" );
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDoctor", "loadDoctor",
                                         "Error", e);
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return false;
    }


   /**
     *
     * the method delete the data from the model in
     * the database.
     *
     * @return true the delete was successfull
     * @return false the delete was not successfull
     *
     */
    public boolean deleteDoctor( String id ) {

        Connection con = ResDataDB.getConnection();

        try {

            //delete the doctor in the database 
            String sql = " delete from doctor " +
                         " where doc_id = " + ResDataDB.getSQLString(id);

            Statement sta = con.createStatement();
            if ( sta.executeUpdate( sql ) == 1 ) {;

                return true;
            }
            else {
                Logger.getLogger().log( Level.ALL,
                                        "no delete for the doc_id = " + id );
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDoctor", "deleteDoctor",
                                         "Error", e);
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return false;
    }

   /**
     *
     * the method clean the data in the model 
     *
     */
    private void  clearAttributte() {

        setDoc_id( "0" );
        setDoc_name( "" );
        setDoc_firstname( "" );
        setDoc_title( "" );
        setDoc_street( "" );
        setDoc_postcode( "" );
        setDoc_city( "" );
        setDoc_phone1( "" );
        setDoc_phone2( "" );
        setDoc_email( "" );
        setDoc_login( "" );
        setDoc_password( "" );
    }



    /**
     *
     * the method save the data of the model into
     * the database.
     *
     * @return true the update was successfull
     * @return false the update was not successfull
     *
     */
    public boolean saveDoctor() {

        Properties values = new Properties();
        String sql = "";
        Connection con = ResDataDB.getConnection();

        try {

            if ( !getDoc_name().equals("") ) {
                values.put( "doc_name"      , getDoc_name() );
            }
            if ( !getDoc_firstname().equals("") ) {
                values.put( "doc_firstname" , getDoc_firstname()  );
            }
            if ( !getDoc_title().equals("") ) {
                values.put( "doc_title"     , getDoc_title()      );
            }
            if ( !getDoc_street().equals("") ) {
                values.put( "doc_street"    , getDoc_street()     );
            }
            if ( !getDoc_postcode().equals("") ) {
                values.put( "doc_postcode"  , getDoc_postcode()   );
            }
            if ( !getDoc_city().equals("") ) {
                values.put( "doc_city"      , getDoc_city()       );
            }
            if ( !getDoc_phone1().equals("") ) {
                values.put( "doc_phone1"    , getDoc_phone1()     );
            }
            if ( !getDoc_phone2().equals("") ) {
                values.put( "doc_phone2"    , getDoc_phone2()     );
            }
            if ( !getDoc_email().equals("") ) {
                values.put( "doc_email"     , getDoc_email()      );
            }
            if ( !getDoc_login().equals("") ) {
                values.put( "doc_login"     , getDoc_login()      );
            }
            if ( !getDoc_password().equals("") ) {
                values.put( "doc_password"  , getDoc_password()   );
            }

            //check insert or update
            if ( (getDoc_id().equals("")) || (getDoc_id().equals("0")) ) {
                
                //insert
                values.put( "doc_id", ResDataDB.getNewId( "doctor", "doc_id" ));
                sql = ResDataDB.getInsertSQL( "doctor", 
                                              values );
            }
            else  {
             
                //update
                sql = ResDataDB.getUpdateSQL( "doctor", "doc_id",
                                              getDoc_id(),
                                              values );
            }

            Statement sta = con.createStatement();

            if ( sta.executeUpdate( sql )==1  ) {

                Logger.getLogger().log( Level.ALL,
                                        "database update successfull");
                return true;
            }
            else {

                Logger.getLogger().log( Level.ALL,
                                        "database update NOT successfull");
            }
        }
        catch (Exception e) {

            try {

                con.rollback();
            }
            catch (Exception ie) {

                Logger.getLogger().logerror( "ResDataDoctor", "saveDoctor",
                                             "Error", e);
            }

            Logger.getLogger().log( Level.ALL, sql);
            Logger.getLogger().logerror( "ResDataDoctor", "saveDoctor",
                                         "Error", e);
        }

        finally {

            ResDataDB.closeConnection(con);
        }

        return false;
    }



    /**
     *
     * check the login with the database
     *
     * @param login login for the doctor page
     * @param password password for the doctor page
     *
     * @return doctor id from the database for the login
     *         if no entry in the database, the doctor id
     *         is empty
     */
/*
    public String getDoctorIdForLogin( String login, String pwd) {

        Connection con = ResDataDB.getConnection();
        String docid = "";

        try {

            //prfen in DB
            String sql = " select doc_id from doctor where " +
                         " doc_login = "    + ResDataDB.getSQLString(login) + " and " +
                         " doc_password = " + ResDataDB.getSQLString(pwd);

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );


            if (res.next()) {
                docid = res.getString("doc_id");
            }

        }

        catch ( Exception e ) {

            Logger.getLogger().logerror( "ResDataLogin", "getDoctorIdForLogin",
                                         "Error", e );
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return docid;
    }
*/
}
