/*
 * $RCSfile: ResDataDate.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The class is the object for the model resdatadate
 *
 * @version         $Revision: 1.8 $
 *                  $Date: 2003/01/27 08:11:57 $
 *                  $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */

package org.resmedicinae.application.healthcare.resdata.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.mail.*;
import org.resmedicinae.application.healthcare.resdata.*;


public class ResDataDate extends Model implements IModel {


    /**
     * is the beginning of the date for overview
     */
    private Calendar time_start;

    /**
     * is the formating value for the desired date
     */
    private String desired_date;

    /**
     * is the formating value for the desired time
     */
    private String desired_time;

    /**
     * is the id for the desired date
     */
    private String desired_date_id;

    /**
     * is the id for the desired time
     */
    private String desired_time_id;

    /**
     * date id for the current date
     */
    private String date_id;

    /**
     * doc id for the current date
     */
    private String doc_id;

    /**
     * patient email for the current date
     */
    private String date_patient_email;

    /**
     * date description for the current date
     */
    private String date_desc;
    
    
    private String search_name;
    private String search_firstname;
    private String search_phone;

    /**
     * a list with all date for the current overview
     * this is dependent of the time_start
     */
    private Vector dateList;

    /**
     * the list for the timesinterval for the overview
     */
    private Vector timeList;

    /**
     * the list for the date wich no confirm status
     */
    private Vector dateConfirmList;


    /**
     * Constructor for the Model ResDataDate.
     */
    public ResDataDate() {

        super();

        time_start      = getFirstDayOfWeek( Calendar.getInstance() );
        timeList        = getTimeListFromDB();
        dateList        = getDateListFromDB();
    }


    /**
     *
     * get the start time for date overview
     *
     * @return String reprasentation of trhe date 
     *
     */             
    public String getStarttime() {

        try {

            DateFormat df = DateFormat.getInstance();
            return         df.format( time_start.getTime() );
		} catch (Exception e) {
            
            Logger.getLogger().logerror( "ResDataDate", "getStartTime",
                                         "Error", e);
            
		}
        return "";
    }

    /**
     *
     * get the start time for the next date overview
     *
     * @return String reprasentation of trhe date 
     *
     */             
    public String getStarttime_next() {

        try {
			
            Calendar c = (Calendar)time_start.clone();
            c.add( Calendar.DATE, 7);
            DateFormat df = DateFormat.getInstance();
            return df.format( c.getTime() );
        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "getStartTime_next",
                                         "Error", e);
        } 
        return "";
    }
                   
    /**
     *
     * get the start time for the preceding date overview
     *
     * @return String reprasentation of trhe date 
     *
     */             
    public String getStarttime_pred() {

        try {

            Calendar c = (Calendar)time_start.clone();
            c.add( Calendar.DATE, -7);
            DateFormat df = DateFormat.getInstance();
            return df.format( c.getTime() );
			 
		} catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "getStartTime_pred",
                                         "Error", e);
		}
        
        return "";
    }



    /**
     *
     * get the timeList of the model
     *
     * @return Vector the list for the timesinterval for the overview
     *
     */
    public Vector getTimeList() {

        return timeList;
    }


    /**
     *
     * get the dateList of the model
     *
     * @return Vector a list with all date for the current overview
     *
     */
    public Vector getDateList() {

        return dateList;
    }


    /**
     *
     * get the dateConfirmList of the model
     *
     * @return Vector the list for the date wich no confirm status
     *
     */
    public Vector getDateConfirmList() {

        return dateConfirmList;
    }


    /**
     *
     * get the desired date
     *
     * @return String desired date
     *
     */
    public String getDesired_date() {

        return desired_date;
    };


    /**
     *
     * get the desired date id
     *
     * @return String desired date id
     *
     */
    public String getDesired_date_id() {

        return desired_date_id;
    };


    /**
     *
     * get the desired time
     *
     * @return String desired time
     *
     */
    public String getDesired_time() {

        return desired_time;
    }


    /**
     *
     * get the desired time id
     *
     * @return String desired time
     *
     */
    public String getDesired_time_id() {

        return desired_time_id;
    }


    /**
     *
     * get the date id
     *
     * @return String date id
     *
     */
    public String getDate_id() {

        return date_id;
    }


    /**
     *
     * get the date patient email
     *
     * @return String date patient email
     *
     */
    public String getDate_patient_email() {

        return date_patient_email;
    }


    /**
     *
     * get the date description
     *
     * @return String date description
     *
     */
    public String getDate_desc() {

        return date_desc;
    }


    /**
     *
     * get the date description
     *
     * @return String date description
     *
     */
    public String getSearch_name() {

        return search_name;
    }

    /**
     *
     * get the date description
     *
     * @return String date description
     *
     */
    public String getSearch_firstname() {

        return search_firstname;
    }


    /**
     *
     * get the date description
     *
     * @return String date description
     *
     */
    public String getSearch_phone() {

        return search_phone;
    }

    /**
     *
     * load the date of the model
     *
     * @param date_id the id if the current date
     * @return boolean if the load of the date successfall then return true
     *
     */
    private boolean loadDate( String date_id ) {

        try {

            Vector erg = ResDataDB.getVectorForSelect("select * from date where date_id = "+date_id);

            if( erg.size() == 1) {

                Properties prop = (Properties)erg.elementAt(0);

                this.date_id            = prop.getProperty( "date_id" );
                this.doc_id             = prop.getProperty( "doc_id" );
                this.date_patient_email = prop.getProperty( "date_patient_email" );
                this.date_desc          = prop.getProperty( "date_desc" );
                
                return true;
            }
            else {

                return false;
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "loadDate",
                                         "Error", e);
        }
        
        return false;
    }


    /**
     *
     * set the desired date and desired time from the parameter for the model
     *
     * @param param parameter of the model
     *
     */
    private void setDesiredDateTime( HashMap param ) {

        try {

            //get the value from the parameter
            String date_id     = (String)param.get( "date_id" );
            String timedesc_id = (String)param.get( "timedesc_id" );
            String datedesc_id = (String)param.get( "datedesc_id" );

            //if setting the date_id, then the other parameter are depended
            if (date_id != null) {

                Vector erg = ResDataDB.getVectorForSelect("select datedesc_id, timedesc_id from date where date_id = "+date_id);

                if( erg.size() == 1) {

                    Properties prop = (Properties)erg.elementAt(0);

                    timedesc_id = prop.getProperty( "timedesc_id" );
                    datedesc_id = prop.getProperty( "datedesc_id" );
                }
            }

            //set the desired id
            desired_date_id = datedesc_id;
            desired_time_id = timedesc_id;

            //set the desired date and time
            Vector erg = null;

            if ( ( timedesc_id != null )    && ( datedesc_id != null ) &&
                 ( !timedesc_id.equals("") ) && (!datedesc_id.equals("")) ) {

                //Desired Date
                erg = ResDataDB.getVectorForSelect(" select *,date_format(datedesc_date, '%d.%m.%Y') datedesc_dateformat from datedesc where datedesc_id = " + datedesc_id );
                if (erg.firstElement()!= null) {

                    Properties prop = (Properties)erg.elementAt(0);
                    desired_date = prop.getProperty( "datedesc_dateformat" );
                }

                //Desired Time
                erg = ResDataDB.getVectorForSelect(" select * from timedesc where timedesc_id = " + timedesc_id );
                if (erg.firstElement()!= null) {

                    Properties prop = (Properties)erg.elementAt(0);
                    desired_time = prop.getProperty( "timedesc_start" );
                }
            }
            else {

                Logger.getLogger().logerror( "ResDataDate", "setDesiredDateTime",
                                             "The parameter timedesc_id or datedesc_id not definition",
                                             null);
            }
        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "setDesiredDateTime",
                                         "Error", e);
        }
    }


    /**
     *
     * set the status confirm for the date
     *
     * @param param the parameter of the model
     *
     */
    private void setConfirmDateTime( HashMap param ) {

        try {

            //et the value from the parameter
            String date_id = (String)param.get( "date_id" );

            //set the status confirm
            if ( date_id != null ) {

                String sql = "update date set status_id=2 where date_id = "+ date_id;
                ResDataDB.executeSelect( sql );
            }
            else {

                Logger.getLogger().logerror( "ResDataDate", "setConfirmDateTime",
                                             "The parameter date_id not definition",
                                             null);
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "setConfirmDateTime",
                                         "Error", e);
        }

    };


    /**
     *
     * the date to be cancel
     *
     * @param param the parameter of the model
     *
     */
    private void setCancelDateTime( HashMap param ) {

        try {

            //get the value from the parameter
            String date_id = (String)param.get( "date_id" );

            //delete the date from the database
            if ( date_id != null ) {

                String sql = "delete from date where date_id = "+ date_id;
                ResDataDB.executeSelect( sql );
            }
            else {

                Logger.getLogger().logerror( "ResDataDate", "setCancelDateTime",
                                             "The parameter date_id not definition",
                                             null);
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "setCancelDateTime",
                                         "Error", e);
        }

    };



    /**
     *
     * to insert a desired date into the database
     *
     * @param param the parameter of the model
     * @return boolean the operation was successfull or not
     *
     */
    private boolean setDateIntoTable( HashMap param ) {

        try {

            //get the value from the parameter
            String timedesc_id  = (String)param.get( "timedesc_id" );
            String datedesc_id  = (String)param.get( "datedesc_id" );
            String doc_id       = (String)param.get( "doc_id" );
            String patientemail = (String)param.get( "patient_email" );
            String datedesc     = (String)param.get( "date_desc" );

            //insert into database
            Vector erg = null;

            if ( ( timedesc_id != null )    && ( datedesc_id != null ) && ( doc_id != null ) &&
                 ( !timedesc_id.equals("") ) && (!datedesc_id.equals("")) && (!doc_id.equals("")) ) {

                Properties values = new Properties();
                String sql = "";
                Connection con = ResDataDB.getConnection();

                try {

                    Integer nid = ResDataDB.getNewId( "date", "date_id" );
                    values.put( "date_id",     nid );
                    values.put( "doc_id",      Integer.valueOf(doc_id)  );
                    values.put( "datedesc_id", Integer.valueOf(datedesc_id)  );
                    values.put( "timedesc_id", Integer.valueOf(timedesc_id)  );
                    values.put( "status_id",   Integer.valueOf("1") );
                    values.put( "date_patient_email",   patientemail );
                    values.put( "date_desc",   datedesc );

                    sql = ResDataDB.getInsertSQL( "date", values );

                    Statement sta = con.createStatement();

                    if ( sta.executeUpdate( sql )==1 ) {

                        Logger.getLogger().log( Level.ALL,
                                        "database insert successfull");
                        return true;
                    }
                    else {

                        Logger.getLogger().log( Level.ALL,
                                                "database insert NOT successfull");
                   }


                }
                catch (Exception e) {

                    try {
                        con.rollback();
                    }
                    catch (Exception ie) {
                        Logger.getLogger().logerror( "ResDataDoctor", "setDateIntoTable",
                                                    e.getMessage(), e);
                    }

                    Logger.getLogger().log( Level.ALL, sql);
                    Logger.getLogger().logerror( "ResDataDoctor", "setDateIntoTable",
                                                 e.getMessage(), e);
                }
                finally {

                    ResDataDB.closeConnection(con);
                }

                return false;

            }
            else {

                Logger.getLogger().logerror( "ResDataDate", "setDateIntoTable",
                                             "The parameter timedesc_id, datedesc_id doc_id not definition",
                                             null);
            }

        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "setDateIntoTable",
                                         "Error", e);
        }

        return false;
    };



    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#init(String)
     */
    public void init(String action) {
    }

    /**
     * @see org.resmedicinae.application.healthcare.resdata.model.IModel#run(HashMap)
     */
    public void run(HashMap param) {

        try {
			
    		super.run( param );
    
            //get the value from the parameter
            String action = (String)param.get("action");
    
            if ( action.equalsIgnoreCase( "DoctorDateOverview" ) ) {
    
                String beginningtime = (String)param.get( "starttime" );
                
                if ( (beginningtime!=null) && (!beginningtime.equals("")) ) {
                   
                    //set the time_start for the parameter 
                    
                    time_start = Calendar.getInstance();
                    DateFormat df = DateFormat.getInstance();
    
                    try {
                        Date d = df.parse( beginningtime );
                        time_start.setTime( d );
    
    				} catch (Exception e) {
                        
                        time_start = Calendar.getInstance();
    				}
                }
                else {
                
                    time_start = Calendar.getInstance();
                }
                dateList = getDateListFromDB();
                
            }
    
	        else if (action.equalsIgnoreCase("DoctorSearch")) {
	        	
	        	search_name = (String)param.get("search_name");
	        	search_firstname = (String)param.get("search_firstname");
	        	search_phone = (String)param.get("search_phone");
	        	
	        }
            else if ( (action.equalsIgnoreCase( "DoctorListAll" )) ||
            		   (action.equalsIgnoreCase( "AdminLogin" )	) ) {
            	
				//clear the doctor filter
            	search_name      = "";
            	search_firstname = "";
            	search_phone     = "";
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDatePred" ) ) {
    
                time_start.add( Calendar.DATE, -7);
                dateList = getDateListFromDB();
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateNext" ) ) {
    
                time_start.add( Calendar.DATE, 7);
                dateList = getDateListFromDB();
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateDesired" ) ) {
    
                setDesiredDateTime( param );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateConfirm" ) ) {
    
                setDesiredDateTime( param );
                loadDate( (String)param.get("date_id") );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateCancel" ) ) {
    
                setDesiredDateTime( param );
                loadDate( (String)param.get("date_id") );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorSendmailDesired" ) ) {
    
                setDateIntoTable( param );
                String doc_id = (String)param.get( "doc_id" );
                dateConfirmList = getDateConfirmListFromDB( doc_id );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorSendmailConfirm" ) ) {
    
                setConfirmDateTime( param );
                dateConfirmList = getDateConfirmListFromDB( doc_id );
                if (dateConfirmList.size()==0) {
                	setModelstatus(Model.DOCTOR_NO_CONFIRM_LIST);
                }
            }
    
            else if ( action.equalsIgnoreCase( "DoctorSendmailCancel" ) ) {
    
                setCancelDateTime( param );
                dateConfirmList = getDateConfirmListFromDB( doc_id );
                if (dateConfirmList.size()==0) {
                	setModelstatus(Model.DOCTOR_NO_CONFIRM_LIST);
                }
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateColor" ) ) {
    
                setDateColor( param );
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateConfirmList" ) ) {
    
                String doc_id = (String)param.get( "doc_id" );
                dateConfirmList = getDateConfirmListFromDB( doc_id );
                if (dateConfirmList.size()==0) {
                	setModelstatus(Model.DOCTOR_NO_CONFIRM_LIST);
                }
            }
    
            else if ( action.equalsIgnoreCase( "DoctorDateDelete" ) ) {
    
                String date_id = (String)param.get( "date_id" );
                deleteFromDate( date_id );
                String doc_id = (String)param.get( "doc_id" );
                dateConfirmList = getDateConfirmListFromDB( doc_id );
                if (dateConfirmList.size()==0) {
                	setModelstatus(Model.DOCTOR_NO_CONFIRM_LIST);
                }
                
            }
    
            else {
    
                Logger.getLogger().logerror( "ResDataDate", "run",
                                             "Actionparameter " + action + " is not handled", null);
                setModelstatus( NO_ACTION_HANDLED );
            }
        } catch (Exception e) {

                Logger.getLogger().logerror( "ResDataDate", "run",
                                             "Error", e);
        }

    }


    /**
     *
     * get a list for the doctors
     *
     * @return Vector vector for the date from all doctors
     *
     */
    public Vector getDoctorList() {

        try {

			String sql = " select * from doctor " +
						 " where doc_login <> " + ResDataDB.getSQLString("root");

			if (!search_name.equals("")) {
				sql = sql + " and doc_name like " + ResDataDB.getSQLString("%"+search_name+"%");
			}
									 
			if (!search_firstname.equals("")) {
				sql = sql + " and doc_firstname like " + ResDataDB.getSQLString("%"+search_firstname+"%");
			}

			if (!search_phone.equals("")) {
				sql = sql + " and ( doc_phone1 = " + ResDataDB.getSQLString(search_phone) + " or " +
				            "     ( doc_phone2 = " + ResDataDB.getSQLString(search_phone) + ")";
			}
						 
            return ResDataDB.getVectorForSelect( sql );
        }

        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDate", "getDoctorList",
                                         "Error", e);
        }

        return null;
    }


    /**
     *
     * get the timeList from the database
     *
     * @return Vector vector for the timelist
     *
     */
    private Vector getTimeListFromDB() {

        try {

            Vector v = ResDataDB.getVectorForSelect(" select * from timedesc");
            return v;
        }

        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDate", "getTimeList",
                                         "Error", e);
        }

        return null;
    }


    /**
     *
     * get the dateList from the database
     *
     * @return Vector vector for the datelist
     *
     */
    private Vector getDateListFromDB() {

        time_start    = getFirstDayOfWeek( time_start );

        Vector period;
        Calendar currentdate = (Calendar)time_start.clone();
        //Calendar currentdate = time_start;
        DateFormat df = DateFormat.getDateInstance();

        try {


            for (int i=0; i<7; i++)  {

                //determined the day of week
                int dayOfWeek = currentdate.get( Calendar.DAY_OF_WEEK );
                String str = "no dayOfWeek";
                switch (dayOfWeek) {
                    case Calendar.MONDAY     : str = "Montag";     break;
                    case Calendar.TUESDAY    : str = "Dienstag";   break;
                    case Calendar.WEDNESDAY  : str = "Mittwoch";   break;
                    case Calendar.THURSDAY   : str = "Donnerstag"; break;
                    case Calendar.FRIDAY     : str = "Freitag";    break;
                    case Calendar.SATURDAY   : str = "Samstag";    break;
                    case Calendar.SUNDAY     : str = "Sonntag";    break;
                }

                //are the date not in the database then insert into the datebase
                if ( !isDateInTable(currentdate) ) {

                    insertDateIntoTable( currentdate );
                }
                currentdate.add( Calendar.DATE, 1);

            }

            //get the datelist from the database
            String whereStatement;
            whereStatement = " datedesc_date >= " + ResDataDB.getSQLDate( time_start );
            whereStatement = whereStatement + " and  ";
            whereStatement = whereStatement + " datedesc_date < " + ResDataDB.getSQLDate( currentdate );
            period = ResDataDB.getVectorForSelect(" select *,  date_format(datedesc_date,'%d.%m.%Y') datedesc_dateformat from datedesc where " + whereStatement + " order by datedesc_date");

            return period;

        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "getDateList",
                                         "Error", e);
        }

        return null;

    }


    /**
     *
     * get the to confirm date list from the database
     *
     * @return Vector vector for the to confirm date list
     *
     */
    private Vector getDateConfirmListFromDB( String doc_id ) {

        try {

            //build the sql-statement
            String sql = " select *, date_format( datedesc_date, '%d.%m.%Y') datedesc_dateformat " +
                         " from date, datedesc, timedesc " +
                         " where doc_id = " + doc_id +
                         " and status_id = 1" +
                         " and date.timedesc_id = timedesc.timedesc_id " +
                         " and date.datedesc_id = datedesc.datedesc_id";

            return ResDataDB.getVectorForSelect(sql);

        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "getDateConfirmList",
                                         "Error", e);
        }

        return null;
    }

    /**
     *
     * get the first day of the week
     *
     * @param date a day in the week
     * @return Calendar first day of the week
     *
     */
    private Calendar getFirstDayOfWeek( Calendar date) {

        try {
			
            int firstDayOfWeek = date.getFirstDayOfWeek();
            int dayOfWeek      = date.get( Calendar.DAY_OF_WEEK );
    
            int changeday = 0;
            switch (dayOfWeek) {
                    case Calendar.MONDAY     : changeday = 0;     break;
                    case Calendar.TUESDAY    : changeday = 1;     break;
                    case Calendar.WEDNESDAY  : changeday = 2;     break;
                    case Calendar.THURSDAY   : changeday = 3;     break;
                    case Calendar.FRIDAY     : changeday = 4;     break;
                    case Calendar.SATURDAY   : changeday = 5;     break;
                    case Calendar.SUNDAY     : changeday = 6;     break;
            }
    
            if ( firstDayOfWeek == Calendar.SUNDAY ) {
                changeday = changeday + 1;
            }
    
            if ( changeday == 7 ) {
                changeday = 0;
            }
    
            date.add( Calendar.DATE, -changeday );
    
            return date;
        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "getFirstDayOfWeek",
                                         "Error", e);
        }
        
        return null;
    }


    /**
     *
     * check the date in the database
     *
     * @param date a day for the checking
     * @return if the date in the database then result true other false
     *
     */
    private boolean isDateInTable( Calendar date ) {

        Connection con = ResDataDB.getConnection();

        try {

            //prfen in DB
            String sql = " select count(*) countdate" +
                         " from datedesc " +
                         " where datedesc_date = " + ResDataDB.getSQLDate(date);

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );

            if (res.next()) {

                int countdate = res.getInt( "countdate");

                if ( countdate  == 0 ) {

                    return false;
                }
                else {

                    return true;
                }
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDoctor", "isDateIntoTable",
                                         "Error", e);
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return false;
    }


    /**
     *
     * delete the date from the database
     *
     * @param date_id the id for the date
     *
     */
    private void deleteFromDate( String date_id ) {

        try {

            String sql = " delete from date where date_id=" + date_id;
            ResDataDB.executeSelect( sql );

        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDate", "deleteFromDate",
                                         "Error", e);
        }

    }


    /**
     *
     * insert the datedescription into the database
     *
     * @param date a day for the insert
     * @return boolean operation successfull or not
     *
     */
    private boolean insertDateIntoTable( Calendar date) {

        Properties values = new Properties();
        String sql = "";
        Connection con = ResDataDB.getConnection();

        try {

            Integer nid = ResDataDB.getNewId( "datedesc", "datedesc_id" );
            values.put( "datedesc_id"   , ResDataDB.getNewId( "datedesc", "datedesc_id" ) );
            values.put( "datedesc_date" ,  date  );

            sql = ResDataDB.getInsertSQL( "datedesc",
                                          values );

            Statement sta = con.createStatement();

            if ( sta.executeUpdate( sql )==1 ) {

                Logger.getLogger().log( Level.ALL,
                                        "database insert successfull");
                return true;
            }
            else {

                Logger.getLogger().log( Level.ALL,
                                        "database insert NOT successfull");
            }
        }

        catch (Exception e) {

            try {

                con.rollback();
            }

            catch (Exception ie) {

                Logger.getLogger().logerror( "ResDataDoctor", "insertDateIntoTable",
                                             "Error", e);
            }

            Logger.getLogger().log( Level.ALL, sql);
            Logger.getLogger().logerror( "ResDataDoctor", "insertDateIntoTable",
                                         "Error", e);
        }
        finally {

            ResDataDB.closeConnection(con);
        }

        return false;
    }


    /**
     *
     * set the datecolor in the modeldata in dependent from the status
     * for the date (no status,request,confirm)
     *
     * @param param parameter of the model
     *
     */
    public void setDateColor( HashMap param ) {

        Connection con = ResDataDB.getConnection();

        try {

            //check in the database
            String sql = " select status_id " +
                         " from date " +
                         " where doc_id = " + param.get( "doc_id" ) +
                         "   and datedesc_id = " + param.get( "datedesc_id" ) +
                         "   and timedesc_id = " + param.get( "timedesc_id" );

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );

            //delete the old value in the modeldata
            this.removeModelData( "datecolor" );

            //insert the value into the modeldata
            if (res.next()) {

                int status = res.getInt( "status_id");

                if ( status == 1 ) {

                    this.putModelData( "datecolor", ResDataConfig.getConfig().getColorForStatusRequest() );
                }
                else {

                    this.putModelData( "datecolor", ResDataConfig.getConfig().getColorForStatusConfirmed() );
                }
            }

            else {

                this.putModelData( "datecolor", ResDataConfig.getConfig().getColorForStatusNo() );
            }
        }

        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDoctor", "setDateColor",
                                         "Error", e);
            this.putModelData( "datecolor", ResDataConfig.getConfig().getColorForStatusNo() );
        }

        finally {

            ResDataDB.closeConnection( con );
        }
    }

}
