/*
 * $RCSfile: Model.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The class is the vather-object for my models
 *
 * @version         $Revision: 1.9 $
 *                  $Date: 2003/01/27 08:11:57 $
 *                  $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.model;


import java.util.HashMap;
import org.resmedicinae.application.healthcare.resdata.ResDataConfig;


public class Model extends Object implements IModel {



    /**
     * Constante for the modelstatus: no status to set.
     */
    public final static int NO_STATUS                   = 0;


    /**
     * Constante for the modelstatus: login successfull.
     */
    public final static int DOCTOR_LOGIN_SUCCESSFULL    = 1;


    /**
     * Constante for the modelstatus: login successfull for root.
     */
    public final static int ADMIN_LOGIN_SUCCESSFULL    = 2;


    /**
     * Constante for the modelstatus: login unsuccessfull.
     */
    public final static int DOCTOR_LOGIN_UNSUCCESSFULL  = 3;


    /**
     * Constante for the modelstatus: login unsuccessfull for root.
     */
    public final static int ADMIN_LOGIN_UNSUCCESSFULL  = 4;

    /**
     * Constante for the modelstatus: login required for root.
     */
    public final static int ADMIN_LOGIN_REQUIRED  = 5;


    /**
     * Constante for the modelstatus: login required for doctor.
     */
    public final static int DOCTOR_LOGIN_REQUIRED  = 6;

    /**
     * Constante for the modelstatus: save the data of the doctor successfull.
     */
    public final static int DOCTOR_SAVE_SUCCESSFULL     = 11;

    /**
     * Constante for the modelstatus: save the data of the doctor unsuccessfull.
     */
    public final static int DOCTOR_SAVE_UNSUCCESSFULL   = 12;


    /**
     * Constante for the modelstatus: save the data of the doctor unsuccessfull.
     */
    public final static int DOCTOR_SAVE_PWD_NOT_CONFIRM = 13;


    /**
     * Constante for the modelstatus: send the mail successfull.
     */
    public final static int MAIL_SEND_SUCCESSFULL       = 21;

    /**
     * Constante for the modelstatus: send the mail unsuccessfull.
     */
    public final static int MAIL_SEND_UNSUCCESSFULL     = 22;


    /**
     * Constante for the modelstatus: no open dates.
     */
    public final static int DOCTOR_NO_CONFIRM_LIST      = 31;

    /**
     * Constante for the modelstatus: no action handled.
     */
    public final static int NO_ACTION_HANDLED      = 998;

    /**
     * Constante for the modelstatus: error, it is the general error.
     */
    public final static int ERROR      = 999;


    /**
     * Variable for the staus of the model
     */
    private int modelstatus;

    /**
     * Variable for the data of the model
     */
    private HashMap modeldata;


    /**
     * Constructor for the Model.
     */
    public Model() {

        super();
        modeldata = new HashMap();
        modelstatus = 0;
    }


    /**
     *
     * initialiation the model
     *
     * @param action for wich action to be initialiation
     *
     */
    public void init( String action ) {

    };


    /**
     *
     * run the model with parameter
     *
     * @param param the parameter for the running of the model
     *
     */
    public void run ( HashMap param ) {

        modelstatus = NO_STATUS;
    };


    /**
     *
     * set the status of the model. This is
     * for example the status for the error or
     * for succerssfull running
     *
     * @param status status of the model
     *
     */
    public void setModelstatus( int status ) {

        this.modelstatus = status;
    }


    /**
     *
     * return the status of the model. This is
     * for example the status for the error or
     * for succerssfull running
     *
     * @return int status of the model
     *
     */
    public int getModelstatus() {

        return  modelstatus;
    }


    /**
     *
     * return the data of the model.
     *
     * @return HashMap data of the model
     *
     */
    public HashMap getModelData() {

        return modeldata;
    }


    /**
     *
     * clear the data of the model
     *
     */
    public void clearModelData() {

        modeldata.clear();
    }


    /**
     *
     * put one data into the model
     *
     * @param key the key of the data
     * @param value the value of the data
     *
     */
    public void putModelData( String key, String value) {

        modeldata.put( key, value);
    }


    /**
     *
     * remove one data fronm the model
     *
     * @param key the key of the data
     *
     */
    public void removeModelData( String key) {

        modeldata.remove( key);
    }


}
