/*
 * $RCSfile: ResDataServlet.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The project ResData is modelling with the mvc pattern.
 * This class represents the controller for the application.
 *
 * It is the sequential control for the view with jsp.
 *
 * @version          $Revision: 1.9 $
 *                   $Date: 2003/01/27 08:08:34 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.controller;


import java.io.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.sound.midi.ControllerEventListener;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.resmedicinae.application.healthcare.resdata.*;


public class ResDataServlet extends HttpServlet{

    /**
     * relativ jsp path
     */
    String jsp_path = "";

    /**
     * the name of the controller in the jsp pages
     */
    String control_param = "";

    /**
     * Constructor for ResDataServlet.
     */
    public ResDataServlet() {

        super();

        jsp_path 		= ResDataConfig.getConfig().getJSPPath();
        control_param 	= ResDataConfig.getConfig().getControlParam();
    }

    /**
     * Get methothe from the http connection
     * This implementation maps GET requests onto POST requests.
     *
     * @param request request for the http connection
     * @param response response for the http connection
     *
     * @exception ServletException
     * @exception IOException
     *
     */
    public void doGet( HttpServletRequest request,
                        HttpServletResponse response
                      ) throws IOException, ServletException {

        Logger.getLogger().log( Level.ALL, "doGet: " + request + ", " + response);
        doPost(request, response);
    }


    /**
     * Post methothe from the http connection
     *
     * @param request request for the http connection
     * @param response response for the http connection
     *
     * @exception ServletException
     * @exception IOException
     *
     */
    public void doPost( HttpServletRequest request,
                         HttpServletResponse response
                       ) throws IOException, ServletException {

        ServletContext application = getServletContext();

		if ( !ResDataConfig.getConfig().isLoaded() ) {
		
			String inifile = application.getInitParameter( "resdata.xml" );
			ResDataConfig.getConfig().loadPreferencesFromXMLFile( inifile );
	        jsp_path 		= ResDataConfig.getConfig().getJSPPath();
	        control_param 	= ResDataConfig.getConfig().getControlParam();
		}
        
        HttpSession session = request.getSession();

        // Copy references to the form parameters into a mutable container
        HashMap formParameters = getFormParameters(request);


        IController myController = getController( formParameters );


        //continues with the page from the controller
        String page = jsp_path + myController.run( formParameters );
        page = response.encodeURL( page );
        RequestDispatcher dispatcher =
            application.getRequestDispatcher( page );
        dispatcher.forward( request, response );
    }



    /**
     * Copy references to all form parameters into a mutable Map.
     * If a parameter has multiple values then the parameter value
     * will be a String[] else a String.
     * <P>
     * This is a useful place to insert default values for missing parameters,
     * for example to map .../servlet/MyServlet onto some default "action"
     * and "view" by inserting those default parameters into the returned
     * HashMap if missing in incoming request.
     * </P>
     *
     * @param inRequest find parameters in this request
     * @return Map containing references to all form parameters, either
     *                      String or String[] if multiple values.
     */
    protected HashMap getFormParameters(HttpServletRequest inRequest) {

        HashMap result = new HashMap();

        //form parameter
        for (Enumeration e = inRequest.getParameterNames(); e.hasMoreElements(); ) {

            Object o = e.nextElement();
            String name = (String)o;

            o = inRequest.getParameterValues(name);
            String[] values = (String[])o;

            if (values.length == 1) {

                result.put(name, values[0]);
            }
            else {

                result.put(name, values);
            }
        }

        //session parameter
        HttpSession session = inRequest.getSession();

        for (Enumeration e = session.getAttributeNames(); e.hasMoreElements(); ) {

            Object o = e.nextElement();
            String name = (String)o;

            o = session.getAttribute(name);

            result.put(name, o);

        }

        return result;
    }


    /**
     * <P>
     * Return a Control instance from request form parameters
     * getting the Control ID from the CONTROL_PARAM form value,
     * and setting the formParameters HashMap as the Control's
     * parameter. Also handles imagemap requests of the form
     * <CODE>imagename.x=ControlId</CODE>.
     * </P>
     * <P>
     * Override this for an application to create a default Control
     * when none is supplied in the request, eg for a simple home request:
     * <PRE>http://localhost:8080/myapp/MyServlet</PRE>
     * with no parameters to display the application's home page.
     * But also see {@link #getFormParameters}.
     * </P>
     *
     * @param ioFormParameters request's form parameters.
     * @return Control instance created from the form parameters
     */
    private IController getController(HashMap ioFormParameters) {

        Iterator it = ioFormParameters.keySet().iterator();

        IController controller = null;

        while ( (it.hasNext()) && (controller == null) ) {

            String key = (String)it.next();
            if ( key.startsWith(control_param) ) {

                Object obj = ioFormParameters.get(key);

                //check og null
                if (obj == null) {
                }

                else if (obj instanceof IController) {
                    controller = (IController)obj;
                }
            }
        }

        if ( controller == null ) {

            Logger.getLogger().log(Level.ALL, "no controller definition - " );
        }

        return controller;
    }

}
