/*
 * $RCSfile: ResDataController.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The project ResData is modelling with the mvc pattern.
 * This class represents the controller for the application.
 *
 * It is the sequential control for the view with jsp.
 *
 * @version          $Revision: 1.9 $
 *                   $Date: 2003/01/27 08:08:34 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.controller;


import java.util.HashMap;
import org.resmedicinae.application.healthcare.resdata.Level;
import org.resmedicinae.application.healthcare.resdata.Logger;
import org.resmedicinae.application.healthcare.resdata.model.IModel;
import org.resmedicinae.application.healthcare.resdata.model.Model;
import org.resmedicinae.application.healthcare.resdata.model.ResDataDoctor;


public class ResDataController extends Controller implements IController{


    /**
     * Constructor for ResDataController.
     */
    public ResDataController() {
    }


    /**
     * @see org.resmedicinae.application.healthcare.resdata.controller.IController#run(HashMap)
     */
    public String run( HashMap param ) {

        String page="";
        String action = (String)param.get( "action" );

        if (action.equalsIgnoreCase("DoctorLoginForm")) {

            page = "ResDataLoginDoctor.jsp";
        }

        else if (action.equalsIgnoreCase("AdminLoginForm")) {

            page = "ResDataLoginAdmin.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDataForm")) {

            page = "ResDataDoctor.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorLogin")) {

            //check of the correkt login
            IModel myModelLogin  = getModel( param, loginmodel_param );
            IModel myModelDoctor = getModel( param, doctormodel_param );

            myModelLogin.run( param );
            if ( myModelLogin.getModelstatus() == Model.DOCTOR_LOGIN_SUCCESSFULL ) {

                param.putAll( myModelLogin.getModelData() );
                myModelDoctor.run( param );
                page = "ResDataDoctor.jsp";
            }

            else if ( myModelLogin.getModelstatus() == Model.DOCTOR_LOGIN_UNSUCCESSFULL ) {

                //Errorpage for incorrekt Login
                page = "ResDataLoginDoctorIncorrect.jsp";
            }

            else if ( myModelLogin.getModelstatus() == Model.DOCTOR_LOGIN_REQUIRED ) {

                //Loginpage for Doctor
                page = "ResDataLoginDoctor.jsp";
            }

            else {

                //no useful modelstatus
                page = "no_modelstatus.jsp";
            }
        }

        else if (action.equalsIgnoreCase("AdminLogin")) {

            //check of the correkt login
            IModel myModelLogin  = getModel( param, loginmodel_param );
            IModel myModelDoctor = getModel( param, doctormodel_param );
            IModel myModelDate   = getModel( param, datemodel_param );

            myModelLogin.run( param );
            if ( myModelLogin.getModelstatus() == Model.ADMIN_LOGIN_SUCCESSFULL ) {

				myModelDate.run(param);

                param.putAll( myModelLogin.getModelData() );
                myModelDoctor.run( param );
                page = "ResDataAdmin.jsp";
            }

            else if ( myModelLogin.getModelstatus() == Model.ADMIN_LOGIN_UNSUCCESSFULL ) {

                page = "ResDataLoginAdminIncorrect.jsp";
            }

            else if ( myModelLogin.getModelstatus() == Model.ADMIN_LOGIN_REQUIRED ) {

                page = "ResDataLoginAdmin.jsp";
            }

            else {

                //no useful modelstatus
                page = "no_modelstatus.jsp";
            }
        }

        else if (action.equalsIgnoreCase("DoctorSave")) {

            //check of the correkt login
            IModel myModel = getModel( param, doctormodel_param );

            myModel.run( param );

            if  (myModel.getModelstatus() == Model.DOCTOR_SAVE_SUCCESSFULL ) {

                page = "ResDataDoctorSaveOK.jsp";
            }

            else if  (myModel.getModelstatus() == Model.DOCTOR_SAVE_UNSUCCESSFULL ) {

                page = "ResDataDoctorSaveFailed.jsp";
            }

            else {

                //no useful modelstatus
                page = "no_modelstatus.jsp";
            }

        }

        else if (action.equalsIgnoreCase("AdminDoctorSave")) {

            //check of the correkt login
            IModel myModel = getModel( param, doctormodel_param );

            myModel.run( param );

            if  (myModel.getModelstatus() == Model.DOCTOR_SAVE_SUCCESSFULL ) {

                page = "ResDataAdminSaveOK.jsp";
            }

            else if  (myModel.getModelstatus() == Model.DOCTOR_SAVE_UNSUCCESSFULL ) {

                page = "ResDataAdminSaveFailed.jsp";
            }

            else if  (myModel.getModelstatus() == Model.DOCTOR_SAVE_PWD_NOT_CONFIRM ) {

                page = "ResDataAdminSaveFailed.jsp";
            }
            else {

                //no useful modelstatus
                page = "no_modelstatus.jsp";
            }

        }

        else if (action.equalsIgnoreCase("DoctorList")) {

            page = "ResDataDoctorList.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorListAll")) {

            IModel myModelDate = getModel( param, datemodel_param );
            
            myModelDate.run( param );
			
            page = "ResDataDoctorList.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorSearch")) {
        	
            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );
            
            page = "ResDataDoctorList.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDateOverview")) {

            IModel myModelDoctor = getModel( param, doctormodel_param );

            myModelDoctor.run( param );

            IModel myModelDate = getModel( param, datemodel_param );

            myModelDate.run( param );

            page = "ResDataDate.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDatePred")) {

            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );

            page = "ResDataDate.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDateNext")) {

            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );

            page = "ResDataDate.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDateDesired")) {

            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );

            page = "ResDataDateDesired.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorSendMailDesired")) {

            IModel myModel = getModel( param, mailmodel_param );

            myModel.run( param );

            if ( myModel.getModelstatus() == Model.MAIL_SEND_SUCCESSFULL ) {

                //the Mail was send successfull
                //now you must a index in the table
                myModel = getModel( param, datemodel_param );
                myModel.run( param );
    
                page = "ResDataDate.jsp";
            }
            else if ( myModel.getModelstatus() == Model.MAIL_SEND_UNSUCCESSFULL ) {
            	
                page = "ResDataMailNoSend.jsp";
            }
            else {
                
                //
                page = "no_status.jsp";
            }

        }
/*
        else if (action.equalsIgnoreCase("DoctorSendMailConfirm")) {

            IModel myModel = getModel( param, mailmodel_param );

            myModel.run( param );

            if ( myModel.getModelstatus() == Model.MAIL_SEND_SUCCESSFULL ) {

                //the Mail was send successfull
                //now you must ein Index in the table
                myModel = getModel( param, datemodel_param );
                myModel.run( param );
            }

            page = "ResDataDateConfirmList.jsp";
        }
*/
        else if ( (action.equalsIgnoreCase("DoctorSendMailCancel")) ||
        		   (action.equalsIgnoreCase("DoctorSendMailConfirm")) ) {

            IModel myModel = getModel( param, mailmodel_param );

            myModel.run( param );

            if ( myModel.getModelstatus() == Model.MAIL_SEND_SUCCESSFULL ) {


	            myModel = getModel( param, doctormodel_param );
	
	            myModel.run( param );
	
	            param.putAll( myModel.getModelData() );
	
	            myModel = getModel( param, datemodel_param );
	
	            myModel.run( param );
	            
	            if ( myModel.getModelstatus() == Model.DOCTOR_NO_CONFIRM_LIST ) {     
	
	  	            page = "ResDataDateNoConfirmList.jsp";
	            }
	            else {
	  	            page = "ResDataDateConfirmList.jsp";
	            }
            }
            else if ( myModel.getModelstatus() == Model.MAIL_SEND_UNSUCCESSFULL ) {

            	page = "ResDataMailNoSend.jsp";
            }
            else {
            	
            	page = "no_modelstatus.jsp";
            }
           
        }

        else if (action.equalsIgnoreCase("DoctorDateConfirmList")) {

            IModel myModel = getModel( param, doctormodel_param );

            myModel.run( param );

            param.putAll( myModel.getModelData() );

            myModel = getModel( param, datemodel_param );

            myModel.run( param );
            
            if ( myModel.getModelstatus() == Model.DOCTOR_NO_CONFIRM_LIST ) {     

  	            page = "ResDataDateNoConfirmList.jsp";
            }
            else {
  	            page = "ResDataDateConfirmList.jsp";
            }
        }

        else if (action.equalsIgnoreCase("DoctorDateConfirm")) {

            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );

            page = "ResDataDateConfirm.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDateCancel")) {

            IModel myModel = getModel( param, datemodel_param );

            myModel.run( param );

            page = "ResDataDateCancel.jsp";
        }

        else if (action.equalsIgnoreCase("DoctorDateDelete")) {

            IModel myModel = getModel( param, doctormodel_param );

            myModel.run( param );

            param.putAll( myModel.getModelData() );

            myModel = getModel( param, datemodel_param );

            myModel.run( param );

            if ( myModel.getModelstatus() == Model.DOCTOR_NO_CONFIRM_LIST ) {     

  	            page = "ResDataDateNoConfirmList.jsp";
            }
            else {
  	            page = "ResDataDateConfirmList.jsp";
            }
        }

        else if (action.equalsIgnoreCase("AdminNewDoc")) {

            IModel myModel = getModel( param, doctormodel_param );
            
            myModel.run( param );

            page = "ResDataAdminDoctor.jsp";
        }

        else if (action.equalsIgnoreCase("AdminEditDoc")) {

            IModel myModel = getModel( param, doctormodel_param );
            
            myModel.run( param );

            page = "ResDataAdminDoctor.jsp";
        }

        else if (action.equalsIgnoreCase("AdminDeleteDoc")) {

            IModel myModel = getModel( param, doctormodel_param );
            
            myModel.run( param );

            page = "ResDataAdmin.jsp";
        }
        else {

          Logger.getLogger().log( Level.ALL, "no action for the controller: " + action );
        }

        return page;
    };


}
