/*
 * $RCSfile: Controller.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The project ResData is modelling with the mvc pattern.
 * This class represents the vather-object for all controller for the application.
 *
 * @version          $Revision: 1.3 $
 *                   $Date: 2002/12/12 13:36:39 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata.controller;


import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.resmedicinae.application.healthcare.resdata.Level;
import org.resmedicinae.application.healthcare.resdata.Logger;
import org.resmedicinae.application.healthcare.resdata.ResDataConfig;
import org.resmedicinae.application.healthcare.resdata.model.*;

public class Controller implements IController {

    /**
     * parameter of the model login
     */
    String loginmodel_param;

    /**
     * parameter of the model doctor
     */
    String doctormodel_param;

    /**
     * parameter of the model date
     */
    String datemodel_param;

    /**
     * parameter of the model mail
     */
    String mailmodel_param;


    /**
     * Constructor for Controller.
     */
    public Controller() {

        loginmodel_param    = ResDataConfig.getConfig().getModelParam( "loginmodel_param");
        doctormodel_param   = ResDataConfig.getConfig().getModelParam( "doctormodel_param");
        datemodel_param     = ResDataConfig.getConfig().getModelParam( "datemodel_param");
        mailmodel_param     = ResDataConfig.getConfig().getModelParam( "mailmodel_param");
    }

    /**
     * @see org.resmedicinae.application.healthcare.resdata.controller.IController#run(HashMap)
     */
    public String run(HashMap param) {

        return null;
    }

    /**
     * get the model-object
     *
     * @param param the parameter of the controller
     * @param model_key parameter of the model (f.e. login, mail,...)
     *
     */
    public IModel getModel( HashMap param, String model_key  ) {

        Iterator it = param.keySet().iterator();

        IModel model = null;

        while ( (it.hasNext()) && (model == null) ) {

            String key = (String)it.next();

            if ( key.startsWith(model_key) ) {

                Object obj = param.get( key );

                //check og null
                if (obj == null) {
                }

                else if (obj instanceof IModel) {

                    model = (IModel)obj;
                }
            }
        }

        if ( model == null ) {

            Logger.getLogger().log(Level.ALL, "no model definition - " );
        }

        return model;
    }

}
