/*
 * $RCSfile: ResDataMailAuthenticator.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */


/**
 * This class is use for the autentication for the email*
 *
 *
 * @version          $Revision: 1.2 $
 *                   $Date: 2002/12/12 13:34:48 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata;

import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;


public class ResDataMailAuthenticator extends Authenticator {

    public PasswordAuthentication getPasswordAuthentication() {

        String user     = ResDataConfig.getConfig().getMailUser();
        String pwd      = ResDataConfig.getConfig().getMailPwd();

        return new PasswordAuthentication( user, pwd);

    }

}
