package org.resmedicinae.application.healthcare.resdata;


import java.sql.*;

public class ResDataLogin {

    /**
     * Constructor for ResDataLogin.
     */
    public ResDataLogin() {
        super();
    }
    
    
    /**
     * 
     * check the login with the database
     * 
     * @param login login for the doctor page
     * @param password password for the doctor page
     * 
     * @return doctor id from the database for the login
     *          if no entry in the database, the doctor id 
     *          is empty
     */
    public String getDoctorIdForLogin( String login, String pwd) {
    
        Connection con = ResDataDB.getConnection();
        String docid = "";
        try {
            
            //prfen in DB
            String sql = " select doc_id from doctor where " +
                         " doc_login = "    + ResDataDB.getSQLString(login) + " and " +
                         " doc_password = " + ResDataDB.getSQLString(pwd);
                         
            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );
            
            
            if (res.next()) {
                docid = res.getString("doc_id");
            }

        }
        catch ( Exception e ) {
            
            Logger.getLogger().logerror( "ResDataLogin", "isDoctorLoginCorrect",
                                          e.getMessage(), e );
        }
        finally {
            
            ResDataDB.closeConnection( con );
        }  
        
        return docid;    
    }

}
