package org.resmedicinae.application.healthcare.resdata;

/*
 * $RCSfile: ResDataDoctor.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The project ResData is modelling with the mvc pattern.
 * This class represents the model for the doctor.
 *
 * The doctor model is compotent for the load and save 
 * the data of the doctor.
 *
 * @version         $Revision: 1.1 $
 *                   $Date: 2002/08/09 15:06:31 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


import java.sql.*;
import java.util.Properties;

public class ResDataDoctor {

    //variables for the model doctor
    private String doc_id;
    private String doc_name;
    private String doc_firstname;
    private String doc_title;
    private String doc_street;
    private String doc_postcode;
    private String doc_city;
    private String doc_phone1;
    private String doc_phone2;
    private String doc_email;
    private String doc_login;
    private String doc_password;
    

    /**
     * Constructor for ResDataDoctor.
     */
    public ResDataDoctor() {
        super();
    }


    //
    //  get and set method for the variables
    //    
    public void setDocId( String id ) {
        if (id==null)
            doc_id = "";
        else
            doc_id = id;
    }

    public String getDocId() {
        return doc_id;   
    }

    public void setDocName( String name ) {
        if (name==null) 
            doc_name = "";
        else
            doc_name = name;
    }

    public String getDocName() {
        return doc_name;   
    }

    public void setDocFirstname( String firstname ) {
        if (firstname==null)
            doc_firstname = "";
        else 
            doc_firstname = firstname;
    }

    public String getDocFirstname() {
        return doc_firstname;   
    }

    public void setDocTitle( String title ) {
        if (title==null)
            doc_title = "";
        else
            doc_title = title;
    }

    public String getDocTitle() {
        return doc_title;   
    }

    public void setDocStreet( String street ) {
        if (street==null)
            doc_street = "";
        else
            doc_street = street;
    }

    public String getDocStreet() {
        return doc_street;   
    }

    public void setDocPostcode( String postcode ) {
        if (postcode==null)
            doc_postcode = "";
        else
            doc_postcode = postcode;
    }

    public String getDocPostcode() {
        return doc_postcode;   
    }


    public void setDocCity( String city ) {
        if (city==null)
            doc_city = "";
        else
            doc_city = city;
    }

    public String getDocCity() {
        return doc_city;   
    }

    public void setDocPhone1( String phone1 ) {
        if (phone1==null)
            doc_phone1 = "";
        else
            doc_phone1 = phone1;
    }

    public String getDocPhone1() {
        return doc_phone1;   
    }

    public void setDocPhone2( String phone2 ) {
        if (phone2==null)
            doc_phone2 = "";
        else
           doc_phone2 = phone2;
    }

    public String getDocPhone2() {
        return doc_phone2;   
    }

    public void setDocEmail( String email ) {
        if (email==null)
            doc_email = "";
        else
            doc_email = email;
    }

    public String getDocEmail() {
        return doc_email;   
    }


    public void setDocLogin( String login ) {
        doc_login = login;
    }

    public String getDocLogin() {
        return doc_login;   
    }


    public void setDocPassword( String password ) {
        doc_password = password;
    }

    public String getDocPassword() {
        return doc_password;   
    }


    /**
     * the method load the data in the model from
     * the database. 
     * 
     * @return true the load was successfull
     * @return false the load was not successfull
     */
    public boolean loadDoctor( String id ) {

        Connection con = ResDataDB.getConnection();

        try {
            
            //prfen in DB
            String sql = " select " +
                         "   doc_id,doc_name,doc_firstname, " +
                         "   doc_title,doc_street,doc_postcode, " +
                         "   doc_city,doc_phone1,doc_phone2, " +
                         "   doc_email,doc_login,doc_password " +
                         " from doctor " +
                         " where doc_id = " + ResDataDB.getSQLString(id);
                         
            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );
            
            
            if (res.next()) {

                setDocId( res.getString( "doc_id") );
                setDocName( res.getString( "doc_name") );
                setDocFirstname( res.getString( "doc_firstname") );
                setDocTitle( res.getString( "doc_title") );
                setDocStreet( res.getString( "doc_street") );
                setDocPostcode( res.getString( "doc_postcode") );
                setDocCity( res.getString( "doc_city") );
                setDocPhone1( res.getString( "doc_phone1") );
                setDocPhone2( res.getString( "doc_phone2") );
                setDocEmail( res.getString( "doc_email") );
                setDocLogin( res.getString( "doc_login") );
                setDocPassword( res.getString( "doc_password") );
                
                return true;
            }
            else {
                Logger.getLogger().log( Level.ALL, 
                                        "Fr die doc_id konnten keine Daten " +
                                        "geladen werden" );   
            }
        }
            
            
        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDoctor", "loadDoctor", 
                                         e.getMessage(), e);
        }
        
        finally {
            
            ResDataDB.closeConnection( con );
        }  

        return false;              
    }



    /**
     * the method save the data of the model into
     * the database. 
     * 
     * @return true the update was successfull
     * @return false the update was not successfull
     */
    public boolean saveDoctor() {
        
        Properties values = new Properties();
        String sql = "";
        Connection con = ResDataDB.getConnection();
        
        try {
        
            values.put( "doc_name"      , ResDataDB.getSQLString( getDocName()      ) );
            values.put( "doc_firstname" , ResDataDB.getSQLString( getDocFirstname() ) );
            values.put( "doc_title"     , ResDataDB.getSQLString( getDocTitle()     ) );
            values.put( "doc_street"    , ResDataDB.getSQLString( getDocStreet()    ) );
            values.put( "doc_postcode"  , ResDataDB.getSQLString( getDocPostcode()  ) );
            values.put( "doc_city"      , ResDataDB.getSQLString( getDocCity()      ) );
            values.put( "doc_phone1"    , ResDataDB.getSQLString( getDocPhone1()    ) );
            values.put( "doc_phone2"    , ResDataDB.getSQLString( getDocPhone2()    ) );
            values.put( "doc_email"     , ResDataDB.getSQLString( getDocEmail()     ) );
            values.put( "doc_login"     , ResDataDB.getSQLString( getDocLogin()     ) );
            values.put( "doc_password"  , ResDataDB.getSQLString( getDocPassword()  ) );
        
            sql = ResDataDB.getUpdateSQL( "doctor", "doc_id", 
                                          ResDataDB.getSQLString( getDocId() ),
                                          values );
                                                 
            Statement sta = con.createStatement();

            if ( sta.executeUpdate( sql )==1 ) {

                Logger.getLogger().log( Level.ALL, 
                                        "database update successfull");                
                return true;
            }
            else {

                Logger.getLogger().log( Level.ALL, 
                                        "database update NOT successfull");                
            }
            
                                                 
        }
        catch (Exception e) {
            
            try {
                con.rollback();
            }
            catch (Exception ie) {
                Logger.getLogger().logerror( "ResDataDoctor", "saveDoctor", 
                                             e.getMessage(), e);
            }
         
            Logger.getLogger().log( Level.ALL, sql);
            Logger.getLogger().logerror( "ResDataDoctor", "saveDoctor", 
                                         e.getMessage(), e);
        }
        finally {
            
            ResDataDB.closeConnection(con);
        }       
        
        return false;
    }

}
