/*
 * $RCSfile: ResDataDB.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */


/**
 * This class represents a interface to the database for the project ResAdress.
 * Is it realisasion with the connection spooling from protomatter.
 * Protomatter ist obtainable http://protomatter.sourceforge.net
 *
 * The database connection description
 * get the from the ResDataConfig modul
 *
 * The control for the open connection is the variable
 * openconnection. After each operation muss the value
 * of the variable equal zero. see into the log
 *
 * For closing the connectin you must tu use the method
 * closeConnection from this class.
 *
 *
 *
 * @version          $Revision: 1.8 $
 *                   $Date: 2003/01/27 08:10:40 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata;


import java.io.*;
import java.sql.*;
import java.text.DateFormat;
import java.util.*;
import com.protomatter.jdbc.pool.JdbcConnectionPool;


public class ResDataDB extends Object {

    /** the connection pool */
    static com.protomatter.jdbc.pool.JdbcConnectionPool pool;

    /** status over the open connection */
    static int openConnection = 0;


    static {
        init();
    }


    /**
     * init the connection pool
     *
     */
     static void init() {

        try {

            Hashtable args = new Hashtable();

            Logger.getLogger().log( Level.ALL, ResDataConfig.getConfig().getDatabaseDriver());
            Logger.getLogger().log( Level.ALL, ResDataConfig.getConfig().getDatabaseURL());
            Logger.getLogger().log( Level.ALL, ResDataConfig.getConfig().getDatabaseUser());
            Logger.getLogger().log( Level.ALL, ResDataConfig.getConfig().getDatabasePwd());

            args.put( "jdbc.driver", ResDataConfig.getConfig().getDatabaseDriver() );
            args.put( "jdbc.URL",    ResDataConfig.getConfig().getDatabaseURL() );
            args.put( "jdbc.login",  ResDataConfig.getConfig().getDatabaseUser() );
            args.put( "jdbc.pwd",    ResDataConfig.getConfig().getDatabasePwd() );

            // these are properties that get passed
            // to DriverManager.getConnection(...)
            Properties jdbcProperties = new Properties();
            jdbcProperties.put("user",     ResDataConfig.getConfig().getDatabaseUser() );
            jdbcProperties.put("password", ResDataConfig.getConfig().getDatabasePwd()  );
			jdbcProperties.put("autoReconnect", "true");            
			args.put("jdbc.properties", jdbcProperties);

            pool = new com.protomatter.jdbc.pool.JdbcConnectionPool( "ResData", args );

            Logger.getLogger().log( Level.ALL,
                                    "Connection Manager initialisiert" );

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDB",
                                         "init",
                                         e.getMessage(), e);
        }
    }


    /**
     * get the connection from the connection pool
     *
     * @return Connection instanz of the connection class
     */
    public static Connection getConnection() {

        Connection con = null;
        try {
            con =
                DriverManager.getConnection("jdbc:protomatter:pool:ResData");
            openConnection = openConnection + 1;
            Logger.getLogger().log( Level.ALL,
                                    "getConnection - actuell open connection: " +
                                    String.valueOf( openConnection ));

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDB",
                                         "getConnection",
                                         e.getMessage(), e);
        }

        return con;

    }


    /**
     * close the connection in the connection pool
     *
     * @param con the actual connection
     */
    public static Connection closeConnection( Connection con ) {

        try {

            con.close();
            openConnection = openConnection-1;
            Logger.getLogger().log( Level.ALL,
                                    "closeConnection - actuell open connection: " +
                                    String.valueOf( openConnection ));

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConnectionManager",
                                         "closeConnection",
                                         e.getMessage(), e);
        }

        return con;

    }


    /**
     * return the sql-string
     * the sql string is a string include from '
     *
     * @param str normal string without '
     * @return string with '
     */
    public static String getSQLString( String str ) {

        try {

			if (str != null) {
	            str = str.replaceAll( "","&Auml;" );
	            str = str.replaceAll( "","&auml;" );
	            str = str.replaceAll( "","&Ouml;" );
	            str = str.replaceAll( "","&ouml;" );
	            str = str.replaceAll( "","&Uuml;" );
	            str = str.replaceAll( "","&uuml;" );
	            str = str.replaceAll( "","&szlig;" );
	            str = '"' + str + '"';
			}
			else {
	            str = '"' + "" + '"';
			}

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConnectionManager",
                                         "getSQLString",
                                         e.getMessage(), e);
        }

        return str;
    }


    /**
     * return the sql-string for the prasentation of a date
     *
     * @param date a date
     * @return string reprasentation of a date in a sql-syntax
     */
    public static String getSQLDate( Calendar date ) {

        String erg = "";

        try {

            int year  = date.get(Calendar.YEAR);
            int month = date.get(Calendar.MONTH) + 1;   //Docu Calendar
            int day   = date.get(Calendar.DAY_OF_MONTH);

            String yearstr  = "";
            String monthstr = "";
            String daystr   = "";

            //year format
            yearstr  = String.valueOf(year);

            //month format
            if ( month < 10 ) {

                monthstr = "0" + String.valueOf(month);
            }

            else {

                monthstr = String.valueOf(month);
            }

            //day format
            if ( day < 10 ) {

                daystr = "0" + String.valueOf(day);
            }

            else {

                daystr = String.valueOf(day);
            }

            //date format
            erg = yearstr + "-" + monthstr + "-" + daystr;

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConnectionManager",
                                         "getSQLString",
                                         e.getMessage(), e);
        }

        return ResDataDB.getSQLString(erg);
    }



    /**
     * return the update sql statement
     * update creating over the id of the table
     *
     * @param table table for the update
     * @param idfield columnname for the id
     * @param id value for the id
     * @param values column und value for the updates
     *
     * @return update sql statement
     */
    public static String getUpdateSQL( String table, String idfield,
                                         String id, Properties values ) {

        String sql = "";
        try {

            String key;
            String value;

            Enumeration e = values.propertyNames();
            while (e.hasMoreElements()) {

                key = (String)e.nextElement();

                Object obj = values.get( key );
                if ( obj instanceof String ) {

                    value = ResDataDB.getSQLString( (String)obj );
                }
                else if ( obj instanceof Integer ) {

                    value = String.valueOf( (Integer)values.get( key ) );
                }
                else if ( obj instanceof Calendar ) {

                    value = ResDataDB.getSQLDate( (Calendar)obj );
                }
                else {
                    value = "";
                }


                if ( !sql.equals("") ) {
                    sql = sql + ",";
                }

                sql = sql + key + " = " + value;
            }

            sql = "update " + table + " set " + sql;
            sql = sql + " where " + idfield + " = " + id;

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDB",
                                         "getUpdateSQL",
                                         e.getMessage(), e);
        }

        return sql;
    };


    /**
     * return the insert sql statement
     *
     * @param table table for the update
     * @param values column und value for the insert
     *
     * @return insert sql statement
     */
    public static String getInsertSQL( String table,
                                         Properties values ) {

        String sql = "";
        try {

            String key   = "";
            String value = "";
            String onevalue = "";
            String onekey = "";

            Enumeration e = values.propertyNames();


            while (e.hasMoreElements()) {

                //generate the key-list
                onekey = (String)e.nextElement();
                if ( key.length()==0 ) {
                    key = "( " ;
                }
                else {
                    key = key + " , ";
                }
                key = key + onekey;

                //get the value
                Object obj = values.get( onekey );
                if ( obj instanceof String ) {

                    onevalue = ResDataDB.getSQLString( (String)obj );
                }
                else if ( obj instanceof Integer ) {

                    onevalue = String.valueOf( (Integer)obj );
                }
                else if ( obj instanceof Calendar ) {

                    onevalue = ResDataDB.getSQLDate( (Calendar)obj );
                }
                else {
                    onevalue = "";
                }


                //generate the value-list
                if ( value.length() == 0 ) {
                    value = " ( ";
                }
                else {
                    value = value + " , ";
                }
                value = value + onevalue;

            }

            //conlude the key and values
            key= key + " ) ";
            value = value + " ) ";

            sql = "insert into  " + table + key + " values " + value;

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConnectionManager",
                                         "getUpdateSQL",
                                         e.getMessage(), e);
        }

        return sql;
    };


    /**
     * return a new id for the table
     *
     * @param table tablename for the getting the new id
     * @param idfield id columnname for the getting the new id
     *
     * @return Integer a new id
     */
    public static Integer getNewId( String tabelle, String idfield ) {

        Integer erg = new Integer(0);
        try {

            String sql = " select max(" + idfield + ") from " + tabelle ;

            Vector v = getVectorForSelect( sql );

            if ( (v!=null) && (v.size()==1) ) {

                Properties pr = (Properties)v.elementAt( 0 );

                Enumeration e = pr.propertyNames();


                if (e.hasMoreElements()) {

                    String key = (String)e.nextElement();

                    //generate the value-list
                    String maxid = (String)pr.get( key );
                    if ( (maxid == null) || (maxid=="") ) {
                        maxid="0";
                    }
                    erg = Integer.valueOf( maxid );
                }
            }

            erg = erg.valueOf( String.valueOf( (erg.intValue()+1) ) );

        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDB",
                                         "getNewId",
                                         e.getMessage(), e);
        }

        return erg;
    }


    /**
     * return the reprasentation of the resultset
     * in form for a Vector of Properties
     * each row of the Vector is ein row in the resultset
     * the value for a column in a row of the resultset
     * is in the propertiers
     *
     * @param rs resultset
     *
     * @return vector with properties
     */
    private static Vector getVectorForResultset( ResultSet rs ) {

        Vector v = new Vector();
        try {

            ResultSetMetaData rsmeta = rs.getMetaData();

            rs.beforeFirst();
            while ( rs.next() ) {

                Properties row = new Properties();

                for ( int i=1; i<=rsmeta.getColumnCount(); i++) {
                    String columnname = rsmeta.getColumnName(i);
                    String value      = rs.getString(i);
                    if ( value == null ) {
                        value = "";
                    }
                    row.put( columnname, value );
                }
                v.addElement( row );

            }

        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataDB",
                                         "getVectorForResultset",
                                         e.getMessage(), e);
        }

        return v;
    };


    /**
     * return the reprasentation of a sql-statement
     * in form for a Vector of Properties
     * each row of the Vector is ein row in the resultset
     * the value for a column in a row of the resultset
     * is in the propertiers
     *
     * @param sql the sql statement
     *
     * @return vector with properties
     */
    public static Vector getVectorForSelect( String sql ) {

        Connection con = ResDataDB.getConnection();

        try {

            Statement sta = con.createStatement();
            ResultSet res = sta.executeQuery( sql );

            return ResDataDB.getVectorForResultset(res);

        }

        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDB", "getVectorForSQL",
                                         e.getMessage(), e);
        }

        finally {

            ResDataDB.closeConnection( con );
        }

        return null;
    }


    /**
     * execute the sql-statement*
     *
     * @param sql the execute sql statement
     *
     * @return operation successfull or not
     */
    public static boolean executeSelect( String sql ) {

        Connection con = ResDataDB.getConnection();

        try {

            Statement sta = con.createStatement();
            return sta.execute( sql );

        }

        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDB", "getVectorForSQL",
                                         e.getMessage(), e);
            return false;
        }

        finally {

            ResDataDB.closeConnection( con );
        }

    }


}
