package org.resmedicinae.application.healthcare.resdata;

/*
 * $RCSfile: ResDataControllerJSP.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * The project ResData is modelling with the mvc pattern.
 * This class represents the controller for the application.
 *
 * It is the sequential control for the view with jsp.
 *
 * @version         $Revision: 1.1 $
 *                   $Date: 2002/08/09 15:06:31 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;


public class ResDataControllerJSP extends HttpServlet{

    // relativ jsp path
    String jsp_path; 

    /**
     * Constructor for ResDataController.
     */
    public ResDataControllerJSP() {
        super();
        jsp_path = ResDataConfig.getConfig().getJSPPath();
    }

    /**
     * Post methothe from the http connection
     * 
     * @param request request for the http connection
     * @param response response for the http connection
     * 
     * @exception ServletException
     * @exception IOException
     * 
     */
    public void doGet( HttpServletRequest request, 
                        HttpServletResponse response 
                      ) throws IOException, ServletException {
    
        ServletContext application = getServletContext();
        HttpSession session = request.getSession();
        
        String action = request.getParameter( "action" );

        
        if (action.equalsIgnoreCase("DoctorLoginForm")) {
         
            String page = jsp_path + "ResDataLogin.jsp";
            
            RequestDispatcher dispatcher = 
                application.getRequestDispatcher( page );
            dispatcher.forward( request, response );
              
        }
        
        else if (action.equalsIgnoreCase("DoctorDataForm")) {
         
            String page = jsp_path + "ResDataDoctor.jsp";
            
            RequestDispatcher dispatcher = 
                application.getRequestDispatcher( page );
            dispatcher.forward( request, response );
              
        }
        else {
            
          throw new ServletException( "no action for the controller: " + action );
        }
        
    }


    /**
     * Post methothe from the http connection
     * 
     * @param request request for the http connection
     * @param response response for the http connection
     * 
     * @exception ServletException
     * @exception IOException
     * 
     */
    public void doPost( HttpServletRequest request, 
                         HttpServletResponse response 
                       ) throws IOException, ServletException {
    
        ServletContext application = getServletContext();
        HttpSession session = request.getSession();
        
        String action = request.getParameter( "action" );

        
        if (action.equalsIgnoreCase("DoctorLogin")) {

            //get the parameter login, password from the formular
            String login = request.getParameter("login");
            String pwd   = request.getParameter("password");
    
            //check of the correkt login
            ResDataLogin myLogin = new ResDataLogin();
            String docid = myLogin.getDoctorIdForLogin( login, pwd );
            if ( !docid.equals("") ) {

                //get the Model
                ResDataDoctor myDoctor = getModelDoctor( session );
                
                //load the data of the doctor
                myDoctor.loadDoctor( docid );
                   

                //continues with the doctor edit page
                String page = jsp_path + "ResDataDoctor.jsp";

                RequestDispatcher dispatcher = 
                    application.getRequestDispatcher( page );
                dispatcher.forward( request, response );
            }
            else {

                //Errorpage for incorrekt Login
                String page = jsp_path + "ResDataLoginIncorrect.jsp";
                
                RequestDispatcher dispatcher = 
                    application.getRequestDispatcher( page );
                dispatcher.forward( request, response );
            }
            
            
        }
        else if (action.equalsIgnoreCase("DoctorSave")) {
            
            //get the parameter login, password from the formular
            String name         = request.getParameter("name");
            String firstname    = request.getParameter("firstname");
            String title        = request.getParameter("title");
            String street       = request.getParameter("street");
            String postcode     = request.getParameter("postcode");
            String city         = request.getParameter("city");
            String phone1       = request.getParameter("phone1");
            String phone2       = request.getParameter("phone2");
            String email        = request.getParameter("email");
            
            //get the Model
            ResDataDoctor myDoctor = getModelDoctor( session );
            
            //set the parameter into the modell
            myDoctor.setDocName( name );
            myDoctor.setDocFirstname( firstname );
            myDoctor.setDocTitle( title );
            myDoctor.setDocStreet( street );
            myDoctor.setDocCity( city );
            myDoctor.setDocPostcode( postcode );
            myDoctor.setDocPhone1( phone1 );
            myDoctor.setDocPhone2( phone2 );
            myDoctor.setDocEmail( email );
            
            // save the model
            myDoctor.saveDoctor();

            // confirm page
            String page = jsp_path + "ResDataDoctorSaveOK.jsp";
                
            RequestDispatcher dispatcher = 
                application.getRequestDispatcher( page );
            dispatcher.forward( request, response );
            
            
        }
        else {
            
          throw new ServletException( "no action for the controller: " + action );
        }
    }
    
    
    /**
     * give the model for the ResDataDoctor from the session. 
     * Ther are not the model in the session, create the model
     * and add the model in the session
     * 
     * 
     * @param session 
     * 
     * @exception ServletException
     * 
     */
    private ResDataDoctor getModelDoctor( HttpSession session) {

        ResDataDoctor myDoctor = null; 
        try {

            myDoctor = 
                (ResDataDoctor)session.getAttribute("ResDataDoctor");
            if (myDoctor==null) {
                myDoctor = new ResDataDoctor();
                session.setAttribute( "ResDataDoctor", myDoctor );       
            };
            
        }
        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataDoctor", "getModelDoctor",
                                         e.getMessage(), e );
        }
        
        return myDoctor;
        
    }


}
