/*
 * $RCSfile: ResDataConfig.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * This class represents a configuration for the project ResAdress.
 *
 * It wraps <code>java.util.prefs.Preferences</code>, which offers a standard
 * mechanism for dealing with preference data in an application.
 *
 * There are a option for read and save to and from a xml-file
 *
 *
 * @version          $Revision: 1.11 $
 *                   $Date: 2003/01/27 08:10:40 $
 *                   $Author: rholzmueller $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


package org.resmedicinae.application.healthcare.resdata;

import java.util.prefs.*;
import java.io.FileInputStream;
import java.io.FileOutputStream;


public class ResDataConfig extends Object{


    /** The singelton for the config-class. */
    static private ResDataConfig myConfig;
    
    /** The ini-file */
    static private String inifile = "";

    /** The reference to the actual preferences object. */
    private Preferences preferences;


    /**
     * Constructor for configuration.
     */
    private ResDataConfig() {

        super();
        preferences = null;
    }

    /**
     * Returns the Singleton for the Config.
     *
     * @return the ResDataConfig
     */
    static public ResDataConfig getConfig() {

        if (myConfig==null) {
            myConfig = new ResDataConfig();
        }

        return myConfig;
    }


    /**
     * Returns the Singleton for the Config.
     *
     * @return the ResDataConfig
     */
    public boolean isLoaded() {

        if ( (inifile!=null) && !(inifile.equals("")) ) {
			return true;
        }

        return false;
    }


    /**
     * get the preference object,
     * if there are not the prefernce object,
     * then create the preference object.
     * it is re-use the system preferences
     */
    public Preferences getPreferences() {

        if (preferences==null) {

            preferences = Preferences.systemNodeForPackage( this.getClass() );
        };

        if (preferences!=null) {

            return preferences;
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * save the preference in a xml-file
     * ther are applies the System-Preferences forever
     *
     * @param location the location for the xml-file
     */
    public void savePreferencesToXMLFile( String location) {
        try{

            FileOutputStream os = new FileOutputStream(location);
            getPreferences().exportNode(os);
        }
        catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConfig",
                                         "savePreferenceToXMLFile",
                                         e.getMessage(), e);
        }

    }


    /**
     * read the preference from a xml-file
     * the result gets in the system preference
     *
     * @param location the location for the xml-file
     */
    public void loadPreferencesFromXMLFile( String location) {
        try{

            FileInputStream is = new FileInputStream(location);
            getPreferences().clear();
            getPreferences().importPreferences(is);
            
            inifile = location;
            
            //initialization the log
            String file = this.getLogFile();
            if  ( ( file !=null) && (!file.equals("")) ) {
                Logger.getLogger().addFileHandler( file );
            }
        }
        catch (Exception e) {
            Logger.getLogger().logerror( "ResDataConfig",
                                         "savePreferenceToXMLFile",
                                         e.getMessage(), e );
            inifile = "";
        }
    }



    /**
     * Print the all configuration into the Log.
     * It is a recursiv method
     *
     * @param pref the node of the preferences
     */
    public void printToLog( Preferences pref ) {

        try {

            //print the keys fpr the preferences
            Logger.getLogger().log( Level.INFO, pref.toString()) ;
            for ( int i=0; i<pref.keys().length; i++ ) {
                Logger.getLogger().log( Level.ALL,
                                        pref.keys()[i] + ": " +
                                        pref.get( pref.keys()[i], "notget")) ;
            }

            //call back for the childrens of the preferneces
            for ( int i=0; i<pref.childrenNames().length; i++ ) {
                printToLog( pref.node( pref.childrenNames()[i] ));
            }

        } catch (Exception e) {

            Logger.getLogger().logerror( "ResDataConfig",
                                         "printToLog",
                                         e.getMessage(), e );
        }

    }


    //
    //  Logging
    //

    /**
     * return the loglevel.
     *
     * @param level the log level
     */
    public int getLogLevel() {

        int level = 0;

        Preferences pref = getPreferences().node("logging");
        if (pref!=null) {

            level = pref.getInt( "log_level", 1 );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return level;
    }

    /**
     * Set the loglevel.
     *
     * @param level the log level
     * @exception NullPointerException if the prefernece is null
     */
    public void setLogLevel(int level) {

        Preferences pref = getPreferences().node("logging");

        if (pref!=null) {

            pref.putInt( "log_level", level );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * return the log file.
     *
     * @param level the log level
     */
    public String getLogFile() {

        String file = "";

        Preferences pref = getPreferences().node("logging");
        if (pref!=null) {

            file = pref.get( "log_file", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return file;
    }


    //
    //  database
    //

    /**
     * return the database driver.
     *
     * @exception NullPointerException if the prefernece is null
     *
     */
    public String getDatabaseDriver() {

        String driver="";

        Preferences pref = getPreferences().node("database");
        if (pref!=null) {

            driver = pref.get( "driver", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return driver;
    }

    /**
     * Set the database driver.
     *
     * @param driver the database driver
     * @exception NullPointerException if the prefernece is null
     */
    public void setDatabaseDriver(String driver) {

        Preferences pref = getPreferences().node("database");

        if (pref!=null) {

            pref.put( "driver", driver );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }

    /**
     * return the database url.
     *
     * @exception NullPointerException if the prefernece is null
     *
     */
    public String getDatabaseURL() {

        String url="";

        Preferences pref = getPreferences().node("database");
        if (pref!=null) {

            url = pref.get( "url", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return url;
    }

    /**
     * Set the database url.
     *
     * @param driver the database driver
     * @exception NullPointerException if the prefernece is null
     */
    public void setDatabaseURL(String url) {

        Preferences pref = getPreferences().node("database");

        if (pref!=null) {

            pref.put( "url", url );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }

    /**
     * return the database login
     *
     * @exception NullPointerException if the prefernece is null
     *
     */
    public String getDatabaseUser() {

        String login="";

        Preferences pref = getPreferences().node("database");
        if (pref!=null) {

            login = pref.get( "user", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return login;
    }

    /**
     * return the database password
     *
     * @exception NullPointerException if the prefernece is null
     *
     */
    public String getDatabasePwd() {

        String pwd="";

        Preferences pref = getPreferences().node("database");
        if (pref!=null) {

            pwd = pref.get( "pwd", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return pwd;
    }


    //
    //  path
    //

    /**
     * return the servlet path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getServletPath() {

        String path="";

        Preferences pref = getPreferences().node("path");
        if (pref!=null) {

            path = pref.get( "servlet_path", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }

    /**
     * Set the servlet path.
     *
     * @param path the servletpath
     * @exception NullPointerException if the prefernece is null
     */
    public void setServletPath(String path) {

        Preferences pref = getPreferences().node("path");

        if (pref!=null) {

            pref.put( "servlet_path", path );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * return the jsp path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getJSPPath() {

        String path="";

        Preferences pref = getPreferences().node("path");
        if (pref!=null) {

            path = pref.get( "jsp_path", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }

    /**
     * Set the jsp path.
     *
     * @param path the servletpath
     * @exception NullPointerException if the prefernece is null
     */
    public void setJSPPath(String path) {

        Preferences pref = getPreferences().node("path");

        if (pref!=null) {

            pref.put( "jsp_path", path );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * return the css path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getCSSPath() {

        String path="";

        Preferences pref = getPreferences().node("path");
        if (pref!=null) {

            path = pref.get( "css_path", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }

    /**
     * Set the css path.
     *
     * @param path the servletpath
     * @exception NullPointerException if the prefernece is null
     */
    public void setCSSPath(String path) {

        Preferences pref = getPreferences().node("path");

        if (pref!=null) {

            pref.put( "css_path", path );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }

    /**
     * return the image path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getImagePath() {

        String path="";

        Preferences pref = getPreferences().node("path");
        if (pref!=null) {

            path = pref.get( "image_path", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }

    /**
     * Set the image path.
     *
     * @param path the servletpath
     * @exception NullPointerException if the prefernece is null
     */
    public void setImageCSSPath(String path) {

        Preferences pref = getPreferences().node("path");

        if (pref!=null) {

            pref.put( "image_path", path );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }



    /**
     * return the navigation fpr the remdidicinae home path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getResmedicinaeHome() {

        String path="";

        Preferences pref = getPreferences().node("navigation");
        if (pref!=null) {

            path = pref.get( "resmedicinae_home", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }


    /**
     * return the navigation fpr the remdidicinae home path.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getResdataHome() {

        String path="";

        Preferences pref = getPreferences().node("navigation");
        if (pref!=null) {

            path = pref.get( "resdata_home", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return path;
    }


    /**
     * return the control parameter.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getControlParam() {

        String result="";

        Preferences pref = getPreferences().node("parameter");
        if (pref!=null) {

            result = pref.get( "control_param", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }

    /**
     * Set the control parameter.
     *
     * @param control_param the control parameter
     * @exception NullPointerException if the prefernece is null
     */
    public void setControlParam(String control_param) {

        Preferences pref = getPreferences().node("parameter");

        if (pref!=null) {

            pref.put( "control_param", control_param );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * return the model parameter.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getModelParam( String key ) {

        String result="";

        Preferences pref = getPreferences().node("parameter");
        if (pref!=null) {

            result = pref.get( key, "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }

    /**
     * return the model parameter.
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getResultModelParam() {

        String result="";

        Preferences pref = getPreferences().node("parameter");
        if (pref!=null) {

            result = pref.get( "resultmodel_param", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * Set the model parameter.
     *
     * @param model_param the model parameter
     * @exception NullPointerException if the prefernece is null
     */
    public void setModelParam(String model_param) {

        Preferences pref = getPreferences().node("parameter");

        if (pref!=null) {

            pref.put( "model_param", model_param );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }

    /**
     * return the mail protocol
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailProtocol() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "protocol", "smtp" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the mail host
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailHost() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "host", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }




    /**
     * return the mail user
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailUser() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "user", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the mail user password
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailPwd() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "pwd", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the mail standard subject for date confirm
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailSubjectConfirm() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "subject_confirm", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }

    /**
     * return the mail standard subject for date cancel
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailSubjectCancel() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "subject_cancel", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }
    /**
     * return the mail standard subject for date desired
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailSubjectDesired() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "subject_desired", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the mail standard subject
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getMailFromAdress() {

        String result="";

        Preferences pref = getPreferences().node("mail");
        if (pref!=null) {

            result = pref.get( "fromadress", "" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the color for the status no
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getColorForStatusNo() {

        String result="";

        Preferences pref = getPreferences().node("color");
        if (pref!=null) {

            result = pref.get( "status_no", "blue" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }


    /**
     * return the color for the status no
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getColorForStatusRequest() {

        String result="";

        Preferences pref = getPreferences().node("color");
        if (pref!=null) {

            result = pref.get( "status_request", "green" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }

    /**
     * return the color for the status no
     *
     * @exception NullPointerException if the prefernece is null
     */
    public String getColorForStatusConfirmed() {

        String result="";

        Preferences pref = getPreferences().node("color");
        if (pref!=null) {

            result = pref.get( "status_confirmed", "gray" );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return result;
    }



}
