package org.resmedicinae.application.healthcare.resdata;

/*
 * $RCSfile: ConfigurationResData.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

/**
 * This class represents a configuration for the project ResAdress.
 *
 * It wraps <code>java.util.prefs.Preferences</code>, which offers a standard
 * mechanism for dealing with preference data in an application.
 *
 * There are a option for read and save to and from a xml-file
 *
 *
 * @version     $Revision: 1.2 $
 *                 $Date: 2002/08/09 21:12:41 $
 *                 $Author: chrissy $
 * @author Rolf Holzmller <rolf.holzmueller@gmx.de>
 */


import java.util.prefs.*;
import java.io.FileInputStream;
import java.io.FileOutputStream;



public class ConfigurationResData {


    //
    // Constants.
    //
    /** The log level. */
    static final String LOG_LEVEL = "log_level";


    /** The reference to the actual preferences object. */
    private Preferences preferences;


    /**
     * Constructor for configuration.
     */
    public ConfigurationResData() {

        super();
        preferences = null;
    }


    /**
     * get the preference object,
     * if there are not the prefernce object,
     * then create the preference object.
     * it is re-use the system preferences
     */
    public Preferences getPreferences() {

        if (preferences==null) {

            preferences = Preferences.systemNodeForPackage( this.getClass() );
        };

        if (preferences!=null) {

            return preferences;
        }
         else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }


    /**
     * save the preference in a xml-file
     * ther are applies the System-Preferences forever
     *
     * @param location the location for the xml-file
     */
    public void savePreferencesToXMLFile( String location) {

        try {

            FileOutputStream os = new FileOutputStream(location);
            getPreferences().exportNode(os);
        
        } catch (Exception e) {

            System.out.println("Exception: " + e);
//??            Logger.getLogger().log( Level.ALL, e.getMessage(), e);
        }
    }

    /**
     * read the preference from a xml-file
     * the result gets in the system preference
     *
     * @param location the location for the xml-file
     */
    public void loadPreferencesFromXMLFile( String location) {

        try {

            FileInputStream is = new FileInputStream(location);
            getPreferences().importPreferences(is);
        
        } catch (Exception e) {
            
            System.out.println("Exception: " + e);
//??            Logger.getLogger().log( Level.ALL, e.getMessage(), e);
        }
    }

   /**
     * return the loglevel.
     *
     * @param level the log level
     */
    public int getLogLevel() {

        int level = 0;

        Preferences pref = getPreferences();
        if (pref!=null) {

            level = pref.getInt( LOG_LEVEL, 1 );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }

        return level;
    }

   /**
     * Set the loglevel.
     *
     * @param level the log level
     * @exception NullPointerException if the prefernece is null
     */
    public void setLogLevel(int level) {

        Preferences pref = getPreferences();

        if (pref!=null) {

            pref.putInt( LOG_LEVEL, level );
        }
        else {

            throw new NullPointerException("Could not create a preferences.");
        }
    }

}
