/*
 * $RCSfile: XmlStructure.java,v $XmlStructure.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.resadmin.dialog;

import org.resmedicinae.application.healthcare.resadmin.*;
import org.resmedicinae.application.healthcare.resadmin.data.XmlPersonTag;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;
import java.util.ResourceBundle;

/**
 * This class represents the XmlStructure application view.
 *
 * @version $Revision: 1.1 $ $Date: 2003/01/26 23:35:53 $ $Author: kumanan $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 */

public class XmlStructure extends SwingView {
    private ResLabel currentLabel;
    private ResLabel actualLabel;
    private ResLabel rootTagLabel;
    private ResLabel idTagLabel;
    private ResLabel groupTagLabel;
    private ResLabel firstNameTagLabel;
    private ResLabel lastNameTagLabel;
    private ResLabel streetTagLabel;
    private ResLabel zipTagLabel;
    private ResLabel cityTagLabel;
    private ResLabel stateTagLabel;
    private ResLabel countryTagLabel;
    private ResLabel genderTagLabel;
    private ResLabel dateOfBirthTagLabel;
    private ResLabel homeTelTagLabel;
    private ResLabel workTelTagLabel;
    private ResLabel faxTagLabel;
    private ResLabel cellTagLabel;
    private ResLabel emailTagLabel;
    private ResLabel webpageTagLabel;
    private ResLabel addressTagLabel;
    private ResLabel contactTagLabel;

    private ResTextField rootTagField;
    private ResTextField idTagField;
    private ResTextField groupTagField;
    private ResTextField firstNameTagField;
    private ResTextField lastNameTagField;
    private ResTextField streetTagField;
    private ResTextField zipTagField;
    private ResTextField cityTagField;
    private ResTextField stateTagField;
    private ResTextField countryTagField;
    private ResTextField genderTagField;
    private ResTextField dateOfBirthTagField;
    private ResTextField homeTelTagField;
    private ResTextField workTelTagField;
    private ResTextField faxTagField;
    private ResTextField cellTagField;
    private ResTextField emailTagField;
    private ResTextField webpageTagField;
    private ResTextField addressTagField;
    private ResTextField contactTagField;

    private ResButton cancelButton;
    private ResButton saveButton;
    private ResButton resetButton;

    private ResLabel topMessage;
    private Font englishFontplain = null;

    private JTextArea sampletext;

    public void initialize() throws Exception {


        try {
            super.initialize();
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);

            this.setDialogBounds(this.createDialogBounds());
            this.setLayout(new BorderLayout());

            this.setResizable(false);
            this.add(createTopMessage(), BorderLayout.NORTH);

            this.add(createPanel(), BorderLayout.CENTER);
            this.add(createButton(), BorderLayout.SOUTH);
            this.setXmlPersonTag();
            this.setLocaleChange();
        } catch (Exception e) {
            System.out.println("Fehler bei Dialog XmlStructure: " + e);
        }
    }

    public ResPanel createTopMessage() {

        ResPanel p = new ResPanel();

        p.setLayout(new FlowLayout());
        topMessage = new ResLabel();
        JTextField tf = new JTextField();

        Font f = new Font("Latha", Font.PLAIN, 12);

                   //  Font ff = new Font(Font.
        sampletext = new JTextArea();
         tf.setFont(f);
        tf.setColumns(20);
        sampletext.setFont(f);
        sampletext.setText("hello");

        sampletext.setColumns(20);
      //  sampletext.setc setCompositionEnabled(true);

        p.add(topMessage);
        p.add(sampletext) ;
        p.add(tf);

        return p;
    }

    public XmlPersonTag getXmlPersonTag() {

        XmlPersonTag pTag = new XmlPersonTag();

        pTag.setRootTag(this.rootTagField.getText());
        pTag.setIDTag(this.idTagField.getText());
        pTag.setGroupTag(this.groupTagField.getText());
        pTag.setFirstNameTag(this.firstNameTagField.getText());
        pTag.setLastNameTag(this.lastNameTagField.getText());
        pTag.setGenderTag(this.genderTagField.getText());
        pTag.setDateOfBirthTag(this.dateOfBirthTagField.getText());
        pTag.setAddressTag(this.addressTagField.getText());
        pTag.setStreetTag(this.streetTagField.getText());
        pTag.setZipTag(this.zipTagField.getText());
        pTag.setCityTag(this.cityTagField.getText());
        pTag.setStateTag(this.stateTagField.getText());
        pTag.setCountryTag(this.countryTagField.getText());
        pTag.setContactTag(this.contactTagField.getText());
        pTag.setHomTelTag(this.homeTelTagField.getText());
        pTag.setWorkTelTag(this.workTelTagField.getText());
        pTag.setCellTag(this.cellTagField.getText());
        pTag.setFaxTag(this.faxTagField.getText());
        pTag.setEmailTag(this.emailTagField.getText());
        pTag.setWebpageTag(this.webpageTagField.getText());

        return pTag;

    }

    public void setXmlPersonTag() {

        ResAdminModel model = (ResAdminModel) getModel();

        XmlPersonTag pTag = model.getPersonTag();

        this.rootTagField.setText(pTag.getRootTag());
        this.idTagField.setText(pTag.getIDTag());
        this.groupTagField.setText(pTag.getGroupTag());
        this.firstNameTagField.setText(pTag.getFirstNameTag());
        this.lastNameTagField.setText(pTag.getLastNameTag());
        this.streetTagField.setText(pTag.getStreetTag());
        this.zipTagField.setText(pTag.getZipTag());
        this.cityTagField.setText(pTag.getCityTag());
        this.stateTagField.setText(pTag.getStateTag());
        this.countryTagField.setText(pTag.getCountryTag());
        this.addressTagField.setText(pTag.getAddressTag());
        this.contactTagField.setText(pTag.getContactTag());
        this.genderTagField.setText(pTag.getGenderTag());
        this.dateOfBirthTagField.setText(pTag.getDateOfBirthTag());
        this.homeTelTagField.setText(pTag.getHomeTelTag());
        this.workTelTagField.setText(pTag.getWorkTelTag());
        this.faxTagField.setText(pTag.getFaxTag());
        this.cellTagField.setText(pTag.getCellTag());
        this.emailTagField.setText(pTag.getEmailTag());
        this.webpageTagField.setText(pTag.getWebpageTag());


    }

    public ResPanel createButton() {

        ResPanel buttonPanel = new ResPanel();

        buttonPanel.setLayout(new FlowLayout());

        saveButton = new ResButton();
        cancelButton = new ResButton();
        resetButton = new ResButton();


        saveButton.addActionListener((ResAdmin) getController());
        saveButton.setActionCommand(ResAdmin.XMLSTRDIALOG_SAVE_BUTTON);


        resetButton.addActionListener((ResAdmin) getController());
        resetButton.setActionCommand(ResAdmin.XMLSTRDIALOG_RESET_BUTTON);


        cancelButton.addActionListener((ResAdmin) getController());
        cancelButton.setActionCommand(ResAdmin.XMLSTRDIALOG_CANCEL_BUTTON);

        buttonPanel.add(resetButton);
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);

        return buttonPanel;
    }

    public ResPanel createPanel() {

        this.createLabels();

        ResPanel strPanel = new ResPanel();

        GridBagLayout gridBagStr = new GridBagLayout();
        GridBagConstraints constrainStr = new GridBagConstraints();
        strPanel.setLayout(gridBagStr);

        constrainStr.fill = GridBagConstraints.HORIZONTAL;
        constrainStr.insets = new Insets(3, 3, 3, 3);


        constrainStr.gridy = 0;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(rootTagLabel, constrainStr);
        strPanel.add(rootTagLabel);

        constrainStr.gridy = 0;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 3;
        gridBagStr.setConstraints(rootTagField, constrainStr);
        strPanel.add(rootTagField);

        constrainStr.gridy = 1;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(idTagLabel, constrainStr);
        strPanel.add(idTagLabel);

        constrainStr.gridy = 1;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(idTagField, constrainStr);
        strPanel.add(idTagField);

        constrainStr.gridy = 1;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(groupTagLabel, constrainStr);
        strPanel.add(groupTagLabel);

        constrainStr.gridy = 1;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(groupTagField, constrainStr);
        strPanel.add(groupTagField);

        constrainStr.gridy = 2;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(lastNameTagLabel, constrainStr);
        strPanel.add(lastNameTagLabel);

        constrainStr.gridy = 2;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(lastNameTagField, constrainStr);
        strPanel.add(lastNameTagField);

        constrainStr.gridy = 2;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(firstNameTagLabel, constrainStr);
        strPanel.add(firstNameTagLabel);

        constrainStr.gridy = 2;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(firstNameTagField, constrainStr);
        strPanel.add(firstNameTagField);

        constrainStr.gridy = 3;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(genderTagLabel, constrainStr);
        strPanel.add(genderTagLabel);

        constrainStr.gridy = 3;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(genderTagField, constrainStr);
        strPanel.add(genderTagField);

        constrainStr.gridy = 3;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(dateOfBirthTagLabel, constrainStr);
        strPanel.add(dateOfBirthTagLabel);

        constrainStr.gridy = 3;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(dateOfBirthTagField, constrainStr);
        strPanel.add(dateOfBirthTagField);

        constrainStr.gridy = 4;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 3;
        ResLabel blank = new ResLabel();
        blank.setText("   ");
        gridBagStr.setConstraints(blank, constrainStr);
        strPanel.add(blank);


        constrainStr.gridy = 5;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(addressTagLabel, constrainStr);
        strPanel.add(addressTagLabel);

        constrainStr.gridy = 5;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(addressTagField, constrainStr);
        strPanel.add(addressTagField);

        constrainStr.gridy = 5;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(contactTagLabel, constrainStr);
        strPanel.add(contactTagLabel);

        constrainStr.gridy = 5;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(contactTagField, constrainStr);
        strPanel.add(contactTagField);

        constrainStr.gridy = 6;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(streetTagLabel, constrainStr);
        strPanel.add(streetTagLabel);

        constrainStr.gridy = 6;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(streetTagField, constrainStr);
        strPanel.add(streetTagField);


        constrainStr.gridy = 6;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(homeTelTagLabel, constrainStr);
        strPanel.add(homeTelTagLabel);

        constrainStr.gridy = 6;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(homeTelTagField, constrainStr);
        strPanel.add(homeTelTagField);


        constrainStr.gridy = 7;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(zipTagLabel, constrainStr);
        strPanel.add(zipTagLabel);

        constrainStr.gridy = 7;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(zipTagField, constrainStr);
        strPanel.add(zipTagField);

        constrainStr.gridy = 7;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(workTelTagLabel, constrainStr);
        strPanel.add(workTelTagLabel);

        constrainStr.gridy = 7;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(workTelTagField, constrainStr);
        strPanel.add(workTelTagField);

        constrainStr.gridy = 8;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(cityTagLabel, constrainStr);
        strPanel.add(cityTagLabel);

        constrainStr.gridy = 8;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(cityTagField, constrainStr);
        strPanel.add(cityTagField);


        constrainStr.gridy = 8;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(faxTagLabel, constrainStr);
        strPanel.add(faxTagLabel);

        constrainStr.gridy = 8;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(faxTagField, constrainStr);
        strPanel.add(faxTagField);


        constrainStr.gridy = 9;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(stateTagLabel, constrainStr);
        strPanel.add(stateTagLabel);

        constrainStr.gridy = 9;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(stateTagField, constrainStr);
        strPanel.add(stateTagField);

        constrainStr.gridy = 9;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(cellTagLabel, constrainStr);
        strPanel.add(cellTagLabel);

        constrainStr.gridy = 9;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(cellTagField, constrainStr);
        strPanel.add(cellTagField);

        constrainStr.gridy = 10;
        constrainStr.gridx = 0;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(countryTagLabel, constrainStr);
        strPanel.add(countryTagLabel);

        constrainStr.gridy = 10;
        constrainStr.gridx = 1;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(countryTagField, constrainStr);
        strPanel.add(countryTagField);

        constrainStr.gridy = 10;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(emailTagLabel, constrainStr);
        strPanel.add(emailTagLabel);

        constrainStr.gridy = 10;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(emailTagField, constrainStr);
        strPanel.add(emailTagField);

        constrainStr.gridy = 11;
        constrainStr.gridx = 2;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(webpageTagLabel, constrainStr);
        strPanel.add(webpageTagLabel);

        constrainStr.gridy = 11;
        constrainStr.gridx = 3;
        constrainStr.gridwidth = 1;
        gridBagStr.setConstraints(webpageTagField, constrainStr);
        strPanel.add(webpageTagField);

        return strPanel;
    }

    public void setLabel(ResLabel label) {


        label.setFont(englishFontplain);
        label.setHorizontalAlignment(ResTextField.RIGHT);

    }

    public void setField(ResTextField field, int c) {

        field.setColumns(c);
        field.setHorizontalAlignment(ResTextField.LEFT);

    }

    public void createLabels() {

        XmlPersonTag pTag = new XmlPersonTag();

        currentLabel = new ResLabel();
        currentLabel.setText("Current Structure");

        actualLabel = new ResLabel();
        actualLabel.setText("Actual Structure");

        rootTagLabel = new ResLabel();
        rootTagLabel.setText("<" + pTag.getRootTag() + ">");
        this.setLabel(rootTagLabel);

        idTagLabel = new ResLabel();
        idTagLabel.setText("<" + pTag.getIDTag() + ">");
        this.setLabel(idTagLabel);

        groupTagLabel = new ResLabel();
        groupTagLabel.setText("<" + pTag.getGroupTag() + ">");
        this.setLabel(groupTagLabel);

        firstNameTagLabel = new ResLabel();
        firstNameTagLabel.setText("<" + pTag.getFirstNameTag() + ">");
        this.setLabel(firstNameTagLabel);

        lastNameTagLabel = new ResLabel();
        lastNameTagLabel.setText("<" + pTag.getLastNameTag() + ">");
        this.setLabel(lastNameTagLabel);

        streetTagLabel = new ResLabel();
        streetTagLabel.setText("<" + pTag.getStreetTag() + ">");
        this.setLabel(streetTagLabel);

        zipTagLabel = new ResLabel();
        zipTagLabel.setText("<" + pTag.getZipTag() + ">");
        this.setLabel(zipTagLabel);

        cityTagLabel = new ResLabel();
        cityTagLabel.setText("<" + pTag.getCityTag() + ">");
        this.setLabel(cityTagLabel);

        stateTagLabel = new ResLabel();
        stateTagLabel.setText("<" + pTag.getStateTag() + ">");
        this.setLabel(stateTagLabel);

        countryTagLabel = new ResLabel();
        countryTagLabel.setText("<" + pTag.getCountryTag() + ">");
        this.setLabel(countryTagLabel);

        genderTagLabel = new ResLabel();
        genderTagLabel.setText("<" + pTag.getGenderTag() + ">");
        this.setLabel(genderTagLabel);

        dateOfBirthTagLabel = new ResLabel();
        dateOfBirthTagLabel.setText("<" + pTag.getDateOfBirthTag() + ">");
        this.setLabel(dateOfBirthTagLabel);

        homeTelTagLabel = new ResLabel();
        homeTelTagLabel.setText("<" + pTag.getHomeTelTag() + ">");
        this.setLabel(homeTelTagLabel);

        workTelTagLabel = new ResLabel();
        workTelTagLabel.setText("<" + pTag.getWorkTelTag() + ">");
        this.setLabel(workTelTagLabel);

        faxTagLabel = new ResLabel();
        faxTagLabel.setText("<" + pTag.getFaxTag() + ">");
        this.setLabel(faxTagLabel);

        cellTagLabel = new ResLabel();
        cellTagLabel.setText("<" + pTag.getCellTag() + ">");
        this.setLabel(cellTagLabel);

        emailTagLabel = new ResLabel();
        emailTagLabel.setText("<" + pTag.getEmailTag() + ">");
        this.setLabel(emailTagLabel);

        webpageTagLabel = new ResLabel();
        webpageTagLabel.setText("<" + pTag.getWebpageTag() + ">");
        this.setLabel(webpageTagLabel);

        addressTagLabel = new ResLabel();
        addressTagLabel.setText("<" + pTag.getAddressTag() + ">");
        this.setLabel(addressTagLabel);

        contactTagLabel = new ResLabel();
        contactTagLabel.setText("<" + pTag.getContactTag() + ">");
        this.setLabel(contactTagLabel);

        rootTagField = new ResTextField();
        this.setField(rootTagField, 12);

        idTagField = new ResTextField();
        this.setField(idTagField, 8);

        groupTagField = new ResTextField();
        this.setField(groupTagField, 8);

        firstNameTagField = new ResTextField();
        this.setField(firstNameTagField, 8);

        lastNameTagField = new ResTextField();
        this.setField(lastNameTagField, 8);

        streetTagField = new ResTextField();
        this.setField(streetTagField, 8);

        zipTagField = new ResTextField();
        this.setField(zipTagField, 8);

        cityTagField = new ResTextField();
        this.setField(cityTagField, 8);

        stateTagField = new ResTextField();
        this.setField(stateTagField, 8);

        countryTagField = new ResTextField();
        this.setField(countryTagField, 8);

        genderTagField = new ResTextField();
        this.setField(genderTagField, 8);

        dateOfBirthTagField = new ResTextField();
        this.setField(dateOfBirthTagField, 8);

        homeTelTagField = new ResTextField();
        this.setField(homeTelTagField, 8);

        workTelTagField = new ResTextField();
        this.setField(workTelTagField, 8);

        faxTagField = new ResTextField();
        this.setField(faxTagField, 8);

        cellTagField = new ResTextField();
        this.setField(cellTagField, 8);

        emailTagField = new ResTextField();
        this.setField(emailTagField, 8);

        webpageTagField = new ResTextField();
        this.setField(webpageTagField, 8);

        addressTagField = new ResTextField();
        this.setField(addressTagField, 12);

        contactTagField = new ResTextField();
        this.setField(contactTagField, 12);

    }

    public void setLocaleChange() {

        ResAdminModel model = (ResAdminModel) getModel();

        ResourceBundle resources = ResourceBundle.getBundle("locale.ResAdmin", model.getResAminLocale());

        englishFontplain = new Font(resources.getString("englishFontplain"), Font.PLAIN, 12);

        this.setTitle(resources.getString("XML_DIALOG_TITLE"));
        this.topMessage.setText(resources.getString("XML_DIALOG_TOPMESSAGE"));
        this.saveButton.setText(resources.getString("XML_DIALOG_SAVE"));
        this.cancelButton.setText(resources.getString("XML_DIALOG_CANCEL"));
        this.resetButton.setText(resources.getString("XML_DIALOG_RESET"));

    }

    public Rectangle createDialogBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 550;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     *
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {

        Control c = new Control();

        if (c != null) {
            c.setId(ResAdmin.XMLSTRDIALOG_CANCEL_BUTTON);
            c.setSender((Controller) getController());

        } else {

            throw new NullPointerException("Could not create close control. The control is null.");
        }

        return c;
    }


}
